/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

public final class TaggingPresetReader {
    public static final String PRESET_MIME_TYPES = "application/xml, text/xml, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5";
    private static volatile File zipIcons = null;

    public static Set<String> getPresetSources() {
        return new TaggingPresetPreference.PresetPrefHelper().getActiveUrls();
    }

    private static XmlObjectParser buildParser() {
        XmlObjectParser parser = new XmlObjectParser();
        parser.mapOnStart("item", TaggingPreset.class);
        parser.mapOnStart("separator", TaggingPresetSeparator.class);
        parser.mapBoth("group", TaggingPresetMenu.class);
        parser.map("text", TaggingPresetItems.Text.class);
        parser.map("link", TaggingPresetItems.Link.class);
        parser.map("preset_link", TaggingPresetItems.PresetLink.class);
        parser.mapOnStart("optional", TaggingPresetItems.Optional.class);
        parser.mapOnStart("roles", TaggingPresetItems.Roles.class);
        parser.map("role", TaggingPresetItems.Role.class);
        parser.map("checkgroup", TaggingPresetItems.CheckGroup.class);
        parser.map("check", TaggingPresetItems.Check.class);
        parser.map("combo", TaggingPresetItems.Combo.class);
        parser.map("multiselect", TaggingPresetItems.MultiSelect.class);
        parser.map("label", TaggingPresetItems.Label.class);
        parser.map("space", TaggingPresetItems.Space.class);
        parser.map("key", TaggingPresetItems.Key.class);
        parser.map("list_entry", TaggingPresetItems.PresetListEntry.class);
        parser.map("item_separator", TaggingPresetItems.ItemSeparator.class);
        parser.mapBoth("chunk", Chunk.class);
        parser.map("reference", Reference.class);
        return parser;
    }

    public static Collection<TaggingPreset> readAll(Reader in, boolean validate) throws SAXException {
        XmlObjectParser parser = TaggingPresetReader.buildParser();
        LinkedList<TaggingPreset> all = new LinkedList<TaggingPreset>();
        TaggingPreset lastmenu = null;
        TaggingPresetItems.Roles lastrole = null;
        LinkedList<TaggingPresetItems.Check> checks = new LinkedList<TaggingPresetItems.Check>();
        LinkedList<TaggingPresetItems.PresetListEntry> listEntries = new LinkedList<TaggingPresetItems.PresetListEntry>();
        HashMap byId = new HashMap();
        ArrayDeque<String> lastIds = new ArrayDeque<String>();
        ArrayDeque lastIdIterators = new ArrayDeque();
        if (validate) {
            parser.startWithValidation(in, Main.getXMLBase() + "/tagging-preset-1.0", "resource://data/tagging-preset.xsd");
        } else {
            parser.start(in);
        }
        while (parser.hasNext() || !lastIdIterators.isEmpty()) {
            TaggingPreset tp;
            Object o;
            if (!lastIdIterators.isEmpty()) {
                o = ((Iterator)lastIdIterators.peek()).next();
                if (!((Iterator)lastIdIterators.peek()).hasNext()) {
                    lastIdIterators.pop();
                }
            } else {
                o = parser.next();
            }
            if (o instanceof Chunk) {
                if (!lastIds.isEmpty() && ((Chunk)o).id.equals(lastIds.peek())) {
                    lastIds.pop();
                    ((Chunk)o).id = null;
                    continue;
                }
                String lastId = ((Chunk)o).id;
                lastIds.push(lastId);
                byId.put(lastId, new ArrayList());
                continue;
            }
            if (!lastIds.isEmpty()) {
                ((List)byId.get(lastIds.peek())).add(o);
                continue;
            }
            if (o instanceof Reference) {
                String ref = ((Reference)o).ref;
                if (byId.get(ref) == null) {
                    throw new SAXException(I18n.tr("Reference {0} is being used before it was defined", ref));
                }
                Iterator it = ((List)byId.get(ref)).iterator();
                if (it.hasNext()) {
                    lastIdIterators.push(it);
                    continue;
                }
                Main.warn("Ignoring reference '" + ref + "' denoting an empty chunk");
                continue;
            }
            if (!(o instanceof TaggingPresetItem) && !checks.isEmpty()) {
                ((TaggingPreset)all.getLast()).data.addAll(checks);
                checks.clear();
            }
            if (o instanceof TaggingPresetMenu) {
                tp = (TaggingPresetMenu)o;
                if (tp == lastmenu) {
                    lastmenu = ((TaggingPresetMenu)tp).group;
                } else {
                    ((TaggingPresetMenu)tp).group = lastmenu;
                    ((TaggingPresetMenu)tp).setDisplayName();
                    lastmenu = tp;
                    all.add(tp);
                }
                lastrole = null;
                continue;
            }
            if (o instanceof TaggingPresetSeparator) {
                tp = (TaggingPresetSeparator)o;
                ((TaggingPresetSeparator)tp).group = lastmenu;
                all.add(tp);
                lastrole = null;
                continue;
            }
            if (o instanceof TaggingPreset) {
                tp = (TaggingPreset)o;
                tp.group = lastmenu;
                tp.setDisplayName();
                all.add(tp);
                lastrole = null;
                continue;
            }
            if (!all.isEmpty()) {
                if (o instanceof TaggingPresetItems.Roles) {
                    ((TaggingPreset)all.getLast()).data.add((TaggingPresetItem)o);
                    if (((TaggingPreset)all.getLast()).roles != null) {
                        throw new SAXException(I18n.tr("Roles cannot appear more than once", new Object[0]));
                    }
                    ((TaggingPreset)all.getLast()).roles = (TaggingPresetItems.Roles)o;
                    lastrole = (TaggingPresetItems.Roles)o;
                    continue;
                }
                if (o instanceof TaggingPresetItems.Role) {
                    if (lastrole == null) {
                        throw new SAXException(I18n.tr("Preset role element without parent", new Object[0]));
                    }
                    lastrole.roles.add((TaggingPresetItems.Role)o);
                    continue;
                }
                if (o instanceof TaggingPresetItems.Check) {
                    checks.add((TaggingPresetItems.Check)o);
                    continue;
                }
                if (o instanceof TaggingPresetItems.PresetListEntry) {
                    listEntries.add((TaggingPresetItems.PresetListEntry)o);
                    continue;
                }
                if (o instanceof TaggingPresetItems.CheckGroup) {
                    ((TaggingPreset)all.getLast()).data.add((TaggingPresetItem)o);
                    ((TaggingPresetItems.CheckGroup)o).checks.clear();
                    ((TaggingPresetItems.CheckGroup)o).checks.addAll(checks);
                    checks.clear();
                    continue;
                }
                if (!checks.isEmpty()) {
                    ((TaggingPreset)all.getLast()).data.addAll(checks);
                    checks.clear();
                }
                ((TaggingPreset)all.getLast()).data.add((TaggingPresetItem)o);
                if (o instanceof TaggingPresetItems.ComboMultiSelect) {
                    ((TaggingPresetItems.ComboMultiSelect)o).addListEntries(listEntries);
                } else if (o instanceof TaggingPresetItems.Key && ((TaggingPresetItems.Key)o).value == null) {
                    ((TaggingPresetItems.Key)o).value = "";
                }
                listEntries = new LinkedList();
                lastrole = null;
                continue;
            }
            throw new SAXException(I18n.tr("Preset sub element without parent", new Object[0]));
        }
        if (!all.isEmpty() && !checks.isEmpty()) {
            ((TaggingPreset)all.getLast()).data.addAll(checks);
            checks.clear();
        }
        return all;
    }

    public static Collection<TaggingPreset> readAll(String source, boolean validate) throws SAXException, IOException {
        Collection<TaggingPreset> tp;
        CachedFile cf = new CachedFile(source).setHttpAccept(PRESET_MIME_TYPES);
        try (InputStream zip = cf.findZipEntryInputStream("xml", "preset");){
            if (zip != null) {
                zipIcons = cf.getFile();
            }
            try (UTFInputStreamReader r = UTFInputStreamReader.create(zip == null ? cf.getInputStream() : zip);){
                tp = TaggingPresetReader.readAll(new BufferedReader(r), validate);
            }
        }
        return tp;
    }

    public static Collection<TaggingPreset> readAll(Collection<String> sources, boolean validate) {
        return TaggingPresetReader.readAll(sources, validate, true);
    }

    public static Collection<TaggingPreset> readAll(Collection<String> sources, boolean validate, boolean displayErrMsg) {
        LinkedList<TaggingPreset> allPresets = new LinkedList<TaggingPreset>();
        for (String source : sources) {
            try {
                allPresets.addAll(TaggingPresetReader.readAll(source, validate));
            }
            catch (IOException e) {
                Main.error(e, false);
                Main.error(source);
                if (source.startsWith("http")) {
                    Main.addNetworkError(source, (Throwable)e);
                }
                if (!displayErrMsg) continue;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read tagging preset source: {0}", source), I18n.tr("Error", new Object[0]), 0);
            }
            catch (SAXException e) {
                Main.error(e);
                Main.error(source);
                JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("Error parsing {0}: ", source) + "<br><br><table width=600>" + e.getMessage() + "</table></html>", I18n.tr("Error", new Object[0]), 0);
            }
        }
        return allPresets;
    }

    public static Collection<TaggingPreset> readFromPreferences(boolean validate, boolean displayErrMsg) {
        return TaggingPresetReader.readAll(TaggingPresetReader.getPresetSources(), validate, displayErrMsg);
    }

    public static File getZipIcons() {
        return zipIcons;
    }

    public static class Reference {
        public String ref;
    }

    public static class Chunk {
        public String id;
    }
}

