/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;

public class TaggingPresetMenu
extends TaggingPreset {
    public JMenu menu = null;

    @Override
    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("Optional tooltip text", this.group != null ? I18n.tr("Preset group {1} / {0}", this.getLocaleName(), this.group.getName()) : I18n.tr("Preset group {0}", this.getLocaleName()));
        this.putValue("toolbar", "tagginggroup_" + this.getRawName());
    }

    private Component copyMenuComponent(Component menuComponent) {
        if (menuComponent instanceof JMenu) {
            JMenu menu = (JMenu)menuComponent;
            JMenu result = new JMenu(menu.getAction());
            for (Component item : menu.getMenuComponents()) {
                result.add(this.copyMenuComponent(item));
            }
            result.setText(menu.getText());
            return result;
        }
        if (menuComponent instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)menuComponent;
            JMenuItem result = new JMenuItem(menuItem.getAction());
            result.setText(menuItem.getText());
            return result;
        }
        if (menuComponent instanceof JSeparator) {
            return new JSeparator();
        }
        return menuComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (this.menu != null && s instanceof Component) {
            JPopupMenu pm = new JPopupMenu(this.getName());
            for (Component c : this.menu.getMenuComponents()) {
                pm.add(this.copyMenuComponent(c));
            }
            Point p = MouseInfo.getPointerInfo().getLocation();
            pm.show(Main.parent, p.x - Main.parent.getX(), p.y - Main.parent.getY());
        }
    }

    public void sortMenu() {
        TaggingPresetMenu.sortMenu(this.menu);
    }

    public static void sortMenu(JMenu menu) {
        Component[] items = menu.getMenuComponents();
        PresetTextComparator comp = new PresetTextComparator();
        ArrayList<JMenuItem> sortarray = new ArrayList<JMenuItem>();
        int lastSeparator = 0;
        for (int i = 0; i < items.length; ++i) {
            int oldPos;
            int pos;
            Component item = items[i];
            if (item instanceof JMenu) {
                TaggingPresetMenu.sortMenu((JMenu)item);
            }
            if (item instanceof JMenuItem) {
                sortarray.add((JMenuItem)item);
                if (i != items.length - 1) continue;
                Collections.sort(sortarray, comp);
                pos = 0;
                for (JMenuItem menuItem : sortarray) {
                    oldPos = lastSeparator == 0 ? pos : pos + lastSeparator + 1;
                    menu.add((Component)menuItem, oldPos);
                    ++pos;
                }
                sortarray = new ArrayList();
                lastSeparator = 0;
                continue;
            }
            if (!(item instanceof JSeparator)) continue;
            Collections.sort(sortarray, comp);
            pos = 0;
            for (JMenuItem menuItem : sortarray) {
                oldPos = lastSeparator == 0 ? pos : pos + lastSeparator + 1;
                menu.add((Component)menuItem, oldPos);
                ++pos;
            }
            sortarray = new ArrayList();
            lastSeparator = i;
        }
    }

    private static class PresetTextComparator
    implements Serializable,
    Comparator<JMenuItem> {
        private PresetTextComparator() {
        }

        @Override
        public int compare(JMenuItem o1, JMenuItem o2) {
            if (Main.main.menu.presetSearchAction.equals(o1.getAction())) {
                return -1;
            }
            if (Main.main.menu.presetSearchAction.equals(o2.getAction())) {
                return 1;
            }
            return AlphanumComparator.getInstance().compare(o1.getText(), o2.getText());
        }
    }
}

