/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.tagging.PresetLabel;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.QuadStateCheckBox;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public final class TaggingPresetItems {
    private static int auto_increment_selected = 0;
    public static final String DIFFERENT = I18n.tr("<different>", new Object[0]);
    private static final BooleanProperty PROP_FILL_DEFAULT = new BooleanProperty("taggingpreset.fill-default-for-tagged-primitives", false);
    private static final Map<String, EnumSet<TaggingPresetType>> TYPE_CACHE = new LinkedHashMap<String, EnumSet<TaggingPresetType>>(16, 1.1f, true);
    private static final Map<String, String> LAST_VALUES = new HashMap<String, String>();

    public static EnumSet<TaggingPresetType> getType(String types) throws SAXException {
        if (TYPE_CACHE.containsKey(types)) {
            return TYPE_CACHE.get(types);
        }
        EnumSet<TaggingPresetType> result = EnumSet.noneOf(TaggingPresetType.class);
        for (String type : Arrays.asList(types.split(","))) {
            try {
                TaggingPresetType presetType = TaggingPresetType.fromString(type);
                result.add(presetType);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(I18n.tr("Unknown type: {0}", type), e);
            }
        }
        TYPE_CACHE.put(types, result);
        return result;
    }

    static String fixPresetString(String s) {
        return s == null ? s : s.replaceAll("'", "''");
    }

    private static String getLocaleText(String text, String text_context, String defaultText) {
        if (text == null) {
            return defaultText;
        }
        if (text_context != null) {
            return I18n.trc(text_context, TaggingPresetItems.fixPresetString(text));
        }
        return I18n.tr(TaggingPresetItems.fixPresetString(text), new Object[0]);
    }

    private static String[] splitEscaped(char delimiter, String s) {
        if (s == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean backslash = false;
        StringBuilder item = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (backslash) {
                item.append(ch);
                backslash = false;
                continue;
            }
            if (ch == '\\') {
                backslash = true;
                continue;
            }
            if (ch == delimiter) {
                result.add(item.toString());
                item.setLength(0);
                continue;
            }
            item.append(ch);
        }
        if (item.length() > 0) {
            result.add(item.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    static Usage determineTextUsage(Collection<OsmPrimitive> sel, String key) {
        Usage returnValue = new Usage();
        returnValue.values = new TreeSet();
        for (OsmPrimitive s : sel) {
            String v = s.get(key);
            if (v != null) {
                returnValue.values.add(v);
            } else {
                returnValue.hadEmpty = true;
            }
            if (!s.hasKeys()) continue;
            returnValue.hadKeys = true;
        }
        return returnValue;
    }

    static Usage determineBooleanUsage(Collection<OsmPrimitive> sel, String key) {
        Usage returnValue = new Usage();
        returnValue.values = new TreeSet();
        for (OsmPrimitive s : sel) {
            String booleanValue = OsmUtils.getNamedOsmBoolean(s.get(key));
            if (booleanValue == null) continue;
            returnValue.values.add(booleanValue);
        }
        return returnValue;
    }

    protected static ImageIcon loadImageIcon(String iconName, File zipIcons, Integer maxSize) {
        Collection<String> s = Main.pref.getCollection("taggingpreset.icon.sources", null);
        ImageProvider imgProv = new ImageProvider(iconName).setDirs(s).setId("presets").setArchive(zipIcons).setOptional(true);
        if (maxSize != null) {
            imgProv.setMaxSize(maxSize);
        }
        return imgProv.get();
    }

    protected static Integer parseInteger(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            if (Main.isTraceEnabled()) {
                Main.trace(e.getMessage());
            }
            return null;
        }
    }

    private static class ConcatenatingJList
    extends JList<PresetListEntry> {
        private String delimiter;

        public ConcatenatingJList(String del, PresetListEntry[] o) {
            super(o);
            this.delimiter = del;
        }

        public void setSelectedItem(Object o) {
            if (o == null) {
                this.clearSelection();
            } else {
                String s = o.toString();
                TreeSet<String> parts = new TreeSet<String>(Arrays.asList(s.split(this.delimiter)));
                ListModel lm = this.getModel();
                int[] intParts = new int[lm.getSize()];
                int j = 0;
                for (int i = 0; i < lm.getSize(); ++i) {
                    String value = ((PresetListEntry)lm.getElementAt((int)i)).value;
                    if (!parts.contains(value)) continue;
                    intParts[j++] = i;
                    parts.remove(value);
                }
                this.setSelectedIndices(Arrays.copyOf(intParts, j));
                this.setEnabled(parts.isEmpty());
            }
        }

        public String getSelectedItem() {
            ListModel lm = this.getModel();
            int[] si = this.getSelectedIndices();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < si.length; ++i) {
                if (i > 0) {
                    builder.append(this.delimiter);
                }
                builder.append(((PresetListEntry)lm.getElementAt((int)si[i])).value);
            }
            return builder.toString();
        }
    }

    public static class MultiSelect
    extends ComboMultiSelect {
        public String rows;
        protected ConcatenatingJList list;

        @Override
        protected void addToPanelAnchor(JPanel p, String def, boolean presetInitiallyMatches) {
            this.list = new ConcatenatingJList(this.delimiter, this.lhm.values().toArray(new PresetListEntry[0]));
            this.component = this.list;
            ListCellRenderer<PresetListEntry> renderer = this.getListCellRenderer();
            this.list.setCellRenderer(renderer);
            if (this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.originalValue = this.usage.getFirst();
                this.list.setSelectedItem(this.originalValue);
            } else if (def != null && !this.usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                this.originalValue = DIFFERENT;
                this.list.setSelectedItem(def);
            } else if (this.usage.unused()) {
                this.originalValue = null;
                this.list.setSelectedItem(this.originalValue);
            } else {
                this.originalValue = DIFFERENT;
                this.list.setSelectedItem(this.originalValue);
            }
            JScrollPane sp = new JScrollPane(this.list);
            if (this.rows != null) {
                double height = renderer.getListCellRendererComponent(this.list, new PresetListEntry("x"), 0, false, false).getPreferredSize().getHeight() * (double)Integer.valueOf(this.rows).intValue();
                sp.setPreferredSize(new Dimension((int)sp.getPreferredSize().getWidth(), (int)height));
            }
            p.add((Component)sp, GBC.eol().fill(2));
        }

        @Override
        protected Object getSelectedItem() {
            return this.list.getSelectedItem();
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
            if (this.list.isEnabled()) {
                super.addCommands(changedTags);
            }
        }
    }

    public static class Combo
    extends ComboMultiSelect {
        public boolean editable = true;
        protected JosmComboBox<PresetListEntry> combo;
        public String length;

        public Combo() {
            this.delimiter = ",";
        }

        @Override
        protected void addToPanelAnchor(JPanel p, String def, boolean presetInitiallyMatches) {
            AutoCompletionList acList;
            if (!this.usage.unused()) {
                for (String s : this.usage.values) {
                    if (this.lhm.containsKey(s)) continue;
                    this.lhm.put(s, new PresetListEntry(s));
                }
            }
            if (def != null && !this.lhm.containsKey(def)) {
                this.lhm.put(def, new PresetListEntry(def));
            }
            this.lhm.put("", new PresetListEntry(""));
            this.component = this.combo = new JosmComboBox<PresetListEntry>(this.lhm.values().toArray(new PresetListEntry[0]));
            this.combo.setRenderer(this.getListCellRenderer());
            this.combo.setEditable(this.editable);
            this.combo.reinitialize(this.lhm.values());
            AutoCompletingTextField tf = new AutoCompletingTextField();
            this.initAutoCompletionField(tf, this.key);
            if (Main.pref.getBoolean("taggingpreset.display-keys-as-hint", true)) {
                tf.setHint(this.key);
            }
            if (this.length != null && !this.length.isEmpty()) {
                tf.setMaxChars(Integer.valueOf(this.length));
            }
            if ((acList = tf.getAutoCompletionList()) != null) {
                acList.add(this.getDisplayValues(), AutoCompletionItemPriority.IS_IN_STANDARD);
            }
            this.combo.setEditor(tf);
            if (this.usage.hasUniqueValue()) {
                this.originalValue = this.lhm.get(this.usage.getFirst());
                this.combo.setSelectedItem(this.originalValue);
            } else if (def != null && this.usage.unused()) {
                if (!this.usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                    this.combo.setSelectedItem(((PresetListEntry)this.lhm.get(def)).getDisplayValue(true));
                } else {
                    this.combo.setSelectedItem("");
                }
                this.originalValue = this.lhm.get(DIFFERENT);
            } else if (this.usage.unused()) {
                this.originalValue = this.lhm.get("");
                if ("force".equals(this.use_last_as_default) && LAST_VALUES.containsKey(this.key) && !presetInitiallyMatches) {
                    this.combo.setSelectedItem(this.lhm.get(LAST_VALUES.get(this.key)));
                } else {
                    this.combo.setSelectedItem(this.originalValue);
                }
            } else {
                this.originalValue = this.lhm.get(DIFFERENT);
                this.combo.setSelectedItem(this.originalValue);
            }
            p.add(this.combo, GBC.eol().fill(2));
        }

        @Override
        protected Object getSelectedItem() {
            return this.combo.getSelectedItem();
        }

        @Override
        protected String getDisplayIfNull() {
            if (this.combo.isEditable()) {
                return this.combo.getEditor().getItem().toString();
            }
            return null;
        }
    }

    public static abstract class ComboMultiSelect
    extends KeyedItem {
        public String locale_text;
        public String values;
        public String values_from;
        public String values_context;
        public String display_values;
        public String locale_display_values;
        public String short_descriptions;
        public String locale_short_descriptions;
        public String default_;
        public String delimiter = ";";
        public String use_last_as_default = "false";
        public String values_searchable = "false";
        protected JComponent component;
        protected final Map<String, PresetListEntry> lhm = new LinkedHashMap<String, PresetListEntry>();
        private boolean initialized = false;
        protected Usage usage;
        protected Object originalValue;
        private static final ListCellRenderer<PresetListEntry> RENDERER = new ListCellRenderer<PresetListEntry>(){
            JLabel lbl = new JLabel();

            @Override
            public Component getListCellRendererComponent(JList<? extends PresetListEntry> list, PresetListEntry item, int index, boolean isSelected, boolean cellHasFocus) {
                if (!list.isShowing() && item.prefferedWidth != -1 && item.prefferedHeight != -1) {
                    if (index == -1) {
                        this.lbl.setPreferredSize(new Dimension(item.prefferedWidth, 10));
                    } else {
                        this.lbl.setPreferredSize(new Dimension(item.prefferedWidth, item.prefferedHeight));
                    }
                    return this.lbl;
                }
                this.lbl.setPreferredSize(null);
                if (isSelected) {
                    this.lbl.setBackground(list.getSelectionBackground());
                    this.lbl.setForeground(list.getSelectionForeground());
                } else {
                    this.lbl.setBackground(list.getBackground());
                    this.lbl.setForeground(list.getForeground());
                }
                this.lbl.setOpaque(true);
                this.lbl.setFont(this.lbl.getFont().deriveFont(0));
                this.lbl.setText("<html>" + item.getListDisplay() + "</html>");
                this.lbl.setIcon(item.getIcon());
                this.lbl.setEnabled(list.isEnabled());
                item.prefferedWidth = this.lbl.getPreferredSize().width;
                item.prefferedHeight = this.lbl.getPreferredSize().height;
                if (index == -1) {
                    this.lbl.setPreferredSize(new Dimension(this.lbl.getPreferredSize().width, 10));
                }
                return this.lbl;
            }
        };

        protected abstract Object getSelectedItem();

        protected abstract void addToPanelAnchor(JPanel var1, String var2, boolean var3);

        protected char getDelChar() {
            return this.delimiter.isEmpty() ? (char)';' : this.delimiter.charAt(0);
        }

        @Override
        public Collection<String> getValues() {
            this.initListEntries();
            return this.lhm.keySet();
        }

        public Collection<String> getDisplayValues() {
            this.initListEntries();
            return Utils.transform(this.lhm.values(), new Utils.Function<PresetListEntry, String>(){

                @Override
                public String apply(PresetListEntry x) {
                    return x.getDisplayValue(true);
                }
            });
        }

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            this.initListEntries();
            this.usage = TaggingPresetItems.determineTextUsage(sel, this.key);
            if (!this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.lhm.put(DIFFERENT, new PresetListEntry(DIFFERENT));
            }
            p.add((Component)new JLabel(I18n.tr("{0}:", this.locale_text)), GBC.std().insets(0, 0, 10, 0));
            this.addToPanelAnchor(p, this.default_, presetInitiallyMatches);
            return true;
        }

        private void initListEntries() {
            if (this.initialized) {
                this.lhm.remove(DIFFERENT);
                return;
            }
            if (this.lhm.isEmpty()) {
                this.initListEntriesFromAttributes();
            } else {
                if (this.values != null) {
                    Main.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "values", "list_entry"));
                }
                if (this.display_values != null || this.locale_display_values != null) {
                    Main.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "display_values", "list_entry"));
                }
                if (this.short_descriptions != null || this.locale_short_descriptions != null) {
                    Main.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "short_descriptions", "list_entry"));
                }
                for (PresetListEntry e : this.lhm.values()) {
                    if (e.value_context != null) continue;
                    e.value_context = this.values_context;
                }
            }
            if (this.locale_text == null) {
                this.locale_text = TaggingPresetItems.getLocaleText(this.text, this.text_context, null);
            }
            this.initialized = true;
        }

        private String[] initListEntriesFromAttributes() {
            String[] short_descriptions_array;
            String displ;
            String[] class_method;
            char delChar = this.getDelChar();
            String[] value_array = null;
            if (this.values_from != null && (class_method = this.values_from.split("#")) != null && class_method.length == 2) {
                try {
                    Method method = Class.forName(class_method[0]).getMethod(class_method[1], new Class[0]);
                    int mod = method.getModifiers();
                    if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && method.getReturnType().equals(String[].class) && method.getParameterTypes().length == 0) {
                        value_array = (String[])method.invoke(null, new Object[0]);
                    } else {
                        Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' is not \"{2}\"", this.key, this.text, "public static String[] methodName()"));
                    }
                }
                catch (Exception e) {
                    Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' threw {2} ({3})", this.key, this.text, e.getClass().getName(), e.getMessage()));
                }
            }
            if (value_array == null) {
                value_array = TaggingPresetItems.splitEscaped(delChar, this.values);
            }
            String[] display_array = (displ = Utils.firstNonNull(this.locale_display_values, this.display_values)) == null ? value_array : TaggingPresetItems.splitEscaped(delChar, displ);
            String descr = Utils.firstNonNull(this.locale_short_descriptions, this.short_descriptions);
            String[] stringArray = short_descriptions_array = descr == null ? null : TaggingPresetItems.splitEscaped(delChar, descr);
            if (display_array.length != value_array.length) {
                Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''display_values'' must be the same as in ''values''", this.key, this.text));
                display_array = value_array;
            }
            if (short_descriptions_array != null && short_descriptions_array.length != value_array.length) {
                Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''short_descriptions'' must be the same as in ''values''", this.key, this.text));
                short_descriptions_array = null;
            }
            for (int i = 0; i < value_array.length; ++i) {
                PresetListEntry e = new PresetListEntry(value_array[i]);
                String string = e.locale_display_value = this.locale_display_values != null ? display_array[i] : I18n.trc(this.values_context, TaggingPresetItems.fixPresetString(display_array[i]));
                if (short_descriptions_array != null) {
                    e.locale_short_description = this.locale_short_descriptions != null ? short_descriptions_array[i] : I18n.tr(TaggingPresetItems.fixPresetString(short_descriptions_array[i]), new Object[0]);
                }
                this.lhm.put(value_array[i], e);
                display_array[i] = e.getDisplayValue(true);
            }
            return display_array;
        }

        protected String getDisplayIfNull() {
            return null;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
            Object obj = this.getSelectedItem();
            String display = obj == null ? null : obj.toString();
            String value = null;
            if (display == null) {
                display = this.getDisplayIfNull();
            }
            if (display != null) {
                for (String val : this.lhm.keySet()) {
                    String k = this.lhm.get(val).toString();
                    if (k == null || !k.equals(display)) continue;
                    value = val;
                    break;
                }
                if (value == null) {
                    value = display;
                }
            } else {
                value = "";
            }
            value = Tag.removeWhiteSpaces(value);
            if (this.originalValue == null ? value.length() == 0 : value.equals(this.originalValue.toString())) {
                return;
            }
            if (!"false".equals(this.use_last_as_default)) {
                LAST_VALUES.put(this.key, value);
            }
            changedTags.add(new Tag(this.key, value));
        }

        public void addListEntry(PresetListEntry e) {
            this.lhm.put(e.value, e);
        }

        public void addListEntries(Collection<PresetListEntry> e) {
            for (PresetListEntry i : e) {
                this.addListEntry(i);
            }
        }

        protected ListCellRenderer<PresetListEntry> getListCellRenderer() {
            return RENDERER;
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.NONE;
        }
    }

    public static class Check
    extends KeyedItem {
        public String locale_text;
        public String value_on = "yes";
        public String value_off = "no";
        public boolean disable_off = false;
        public boolean default_ = false;
        private QuadStateCheckBox check;
        private QuadStateCheckBox.State initialState;
        private boolean def;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            Usage usage = TaggingPresetItems.determineBooleanUsage(sel, this.key);
            String oneValue = usage.values.isEmpty() ? null : usage.values.last();
            this.def = this.default_;
            if (this.locale_text == null) {
                this.locale_text = TaggingPresetItems.getLocaleText(this.text, this.text_context, null);
            }
            if (usage.values.size() < 2 && (oneValue == null || this.value_on.equals(oneValue) || this.value_off.equals(oneValue))) {
                if (this.def && !PROP_FILL_DEFAULT.get().booleanValue()) {
                    for (OsmPrimitive s : sel) {
                        if (!s.hasKeys()) continue;
                        this.def = false;
                    }
                }
                this.initialState = this.value_on.equals(oneValue) ? QuadStateCheckBox.State.SELECTED : (this.value_off.equals(oneValue) ? QuadStateCheckBox.State.NOT_SELECTED : (this.def ? QuadStateCheckBox.State.SELECTED : QuadStateCheckBox.State.UNSET));
            } else {
                this.def = false;
                this.initialState = QuadStateCheckBox.State.PARTIAL;
            }
            ArrayList<QuadStateCheckBox.State> allowedStates = new ArrayList<QuadStateCheckBox.State>(4);
            if (QuadStateCheckBox.State.PARTIAL.equals((Object)this.initialState)) {
                allowedStates.add(QuadStateCheckBox.State.PARTIAL);
            }
            allowedStates.add(QuadStateCheckBox.State.SELECTED);
            if (!this.disable_off || this.value_off.equals(oneValue)) {
                allowedStates.add(QuadStateCheckBox.State.NOT_SELECTED);
            }
            allowedStates.add(QuadStateCheckBox.State.UNSET);
            this.check = new QuadStateCheckBox(this.locale_text, this.initialState, allowedStates.toArray(new QuadStateCheckBox.State[allowedStates.size()]));
            p.add((Component)this.check, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
            if (this.check.getState() == this.initialState && !this.def) {
                return;
            }
            changedTags.add(new Tag(this.key, this.check.getState() == QuadStateCheckBox.State.SELECTED ? this.value_on : (this.check.getState() == QuadStateCheckBox.State.NOT_SELECTED ? this.value_off : null)));
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.NONE;
        }

        @Override
        public Collection<String> getValues() {
            return this.disable_off ? Arrays.asList(this.value_on) : Arrays.asList(this.value_on, this.value_off);
        }

        @Override
        public String toString() {
            return "Check [" + (this.locale_text != null ? "locale_text=" + this.locale_text + ", " : "") + (this.value_on != null ? "value_on=" + this.value_on + ", " : "") + (this.value_off != null ? "value_off=" + this.value_off + ", " : "") + "default_=" + this.default_ + ", " + (this.check != null ? "check=" + this.check + ", " : "") + (this.initialState != null ? "initialState=" + (Object)((Object)this.initialState) + ", " : "") + "def=" + this.def + "]";
        }
    }

    public static class CheckGroup
    extends TaggingPresetItem {
        public String columns;
        public final List<Check> checks = new LinkedList<Check>();

        @Override
        boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            Integer cols = Integer.valueOf(this.columns);
            int rows = (int)Math.ceil((double)this.checks.size() / cols.doubleValue());
            JPanel panel = new JPanel(new GridLayout(rows, cols));
            for (Check check : this.checks) {
                check.addToPanel(panel, sel, presetInitiallyMatches);
            }
            p.add((Component)panel, GBC.eol());
            return false;
        }

        @Override
        void addCommands(List<Tag> changedTags) {
            for (Check check : this.checks) {
                check.addCommands(changedTags);
            }
        }

        public String toString() {
            return "CheckGroup [columns=" + this.columns + "]";
        }
    }

    public static class Text
    extends KeyedItem {
        public String locale_text;
        public String default_;
        public String originalValue;
        public String use_last_as_default = "false";
        public String auto_increment;
        public String length;
        public String alternative_autocomplete_keys;
        private JComponent value;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            Usage usage = TaggingPresetItems.determineTextUsage(sel, this.key);
            AutoCompletingTextField textField = new AutoCompletingTextField();
            if (this.alternative_autocomplete_keys != null) {
                this.initAutoCompletionField(textField, (this.key + "," + this.alternative_autocomplete_keys).split(","));
            } else {
                this.initAutoCompletionField(textField, this.key);
            }
            if (Main.pref.getBoolean("taggingpreset.display-keys-as-hint", true)) {
                textField.setHint(this.key);
            }
            if (this.length != null && !this.length.isEmpty()) {
                textField.setMaxChars(Integer.valueOf(this.length));
            }
            if (usage.unused()) {
                if (auto_increment_selected != 0 && this.auto_increment != null) {
                    try {
                        textField.setText(Integer.toString(Integer.parseInt((String)LAST_VALUES.get(this.key)) + auto_increment_selected));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (!usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                    if (!"false".equals(this.use_last_as_default) && LAST_VALUES.containsKey(this.key) && !presetInitiallyMatches) {
                        textField.setText((String)LAST_VALUES.get(this.key));
                    } else {
                        textField.setText(this.default_);
                    }
                } else {
                    textField.setText("");
                }
                this.value = textField;
                this.originalValue = null;
            } else if (usage.hasUniqueValue()) {
                textField.setText(usage.getFirst());
                this.value = textField;
                this.originalValue = usage.getFirst();
            } else {
                JosmComboBox<String> comboBox = new JosmComboBox<String>(usage.values.toArray(new String[0]));
                comboBox.setEditable(true);
                comboBox.setEditor(textField);
                comboBox.getEditor().setItem(DIFFERENT);
                this.value = comboBox;
                this.originalValue = DIFFERENT;
            }
            if (this.locale_text == null) {
                this.locale_text = TaggingPresetItems.getLocaleText(this.text, this.text_context, null);
            }
            if (this.auto_increment != null) {
                ButtonGroup bg = new ButtonGroup();
                JPanel pnl = new JPanel(new GridBagLayout());
                pnl.add((Component)this.value, GBC.std().fill(2));
                for (String ai : this.auto_increment.split(",")) {
                    JToggleButton aibutton = new JToggleButton(ai);
                    aibutton.setToolTipText(I18n.tr("Select auto-increment of {0} for this field", ai));
                    aibutton.setMargin(new Insets(0, 0, 0, 0));
                    aibutton.setFocusable(false);
                    bg.add(aibutton);
                    try {
                        final int buttonvalue = NumberFormat.getIntegerInstance().parse(ai.replace("+", "")).intValue();
                        if (auto_increment_selected == buttonvalue) {
                            aibutton.setSelected(true);
                        }
                        aibutton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                auto_increment_selected = buttonvalue;
                            }
                        });
                        pnl.add((Component)aibutton, GBC.std());
                    }
                    catch (ParseException x) {
                        Main.error("Cannot parse auto-increment value of '" + ai + "' into an integer");
                    }
                }
                final JToggleButton clearbutton = new JToggleButton("X");
                clearbutton.setVisible(false);
                clearbutton.setFocusable(false);
                bg.add(clearbutton);
                JButton releasebutton = new JButton("X");
                releasebutton.setToolTipText(I18n.tr("Cancel auto-increment for this field", new Object[0]));
                releasebutton.setMargin(new Insets(0, 0, 0, 0));
                releasebutton.setFocusable(false);
                releasebutton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        auto_increment_selected = 0;
                        clearbutton.setSelected(true);
                    }
                });
                pnl.add((Component)releasebutton, GBC.eol());
                this.value = pnl;
            }
            p.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)this.value, GBC.eol().fill(2));
            return true;
        }

        private static String getValue(Component comp) {
            if (comp instanceof JosmComboBox) {
                return ((JosmComboBox)comp).getEditor().getItem().toString();
            }
            if (comp instanceof JosmTextField) {
                return ((JosmTextField)comp).getText();
            }
            if (comp instanceof JPanel) {
                return Text.getValue(((JPanel)comp).getComponent(0));
            }
            return null;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
            String v = Text.getValue(this.value);
            if (v == null) {
                Main.error("No 'last value' support for component " + this.value);
                return;
            }
            v = Tag.removeWhiteSpaces(v);
            if (!"false".equals(this.use_last_as_default) || this.auto_increment != null) {
                LAST_VALUES.put(this.key, v);
            }
            if (v.equals(this.originalValue) || this.originalValue == null && v.length() == 0) {
                return;
            }
            changedTags.add(new Tag(this.key, v));
            AutoCompletionManager.rememberUserInput(this.key, v, true);
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.NONE;
        }

        @Override
        public Collection<String> getValues() {
            if (this.default_ == null || this.default_.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singleton(this.default_);
        }
    }

    public static class Key
    extends KeyedItem {
        public String value;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            return false;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
            changedTags.add(new Tag(this.key, this.value));
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.KEY_VALUE_REQUIRED;
        }

        @Override
        public Collection<String> getValues() {
            return Collections.singleton(this.value);
        }

        @Override
        public String toString() {
            return "Key [key=" + this.key + ", value=" + this.value + ", text=" + this.text + ", text_context=" + this.text_context + ", match=" + this.match + "]";
        }
    }

    public static abstract class KeyedItem
    extends TaggingPresetItem {
        public String key;
        public String text;
        public String text_context;
        public String match = this.getDefaultMatch().getValue();

        public abstract MatchType getDefaultMatch();

        public abstract Collection<String> getValues();

        @Override
        Boolean matches(Map<String, String> tags) {
            switch (MatchType.ofString(this.match)) {
                case NONE: {
                    return null;
                }
                case KEY: {
                    return tags.containsKey(this.key) ? Boolean.valueOf(true) : null;
                }
                case KEY_REQUIRED: {
                    return tags.containsKey(this.key);
                }
                case KEY_VALUE: {
                    return tags.containsKey(this.key) && this.getValues().contains(tags.get(this.key)) ? Boolean.valueOf(true) : null;
                }
                case KEY_VALUE_REQUIRED: {
                    return tags.containsKey(this.key) && this.getValues().contains(tags.get(this.key));
                }
            }
            throw new IllegalStateException();
        }

        public String toString() {
            return "KeyedItem [key=" + this.key + ", text=" + this.text + ", text_context=" + this.text_context + ", match=" + this.match + "]";
        }
    }

    public static class ItemSeparator
    extends TaggingPresetItem {
        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            p.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            return false;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
        }

        public String toString() {
            return "ItemSeparator";
        }
    }

    public static class Space
    extends TaggingPresetItem {
        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            p.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
        }

        public String toString() {
            return "Space";
        }
    }

    public static class Optional
    extends TaggingPresetTextItem {
        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            this.initializeLocaleText(I18n.tr("Optional Attributes:", new Object[0]));
            p.add((Component)new JLabel(" "), GBC.eol());
            p.add((Component)new JLabel(this.locale_text), GBC.eol());
            p.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }
    }

    public static class Roles
    extends TaggingPresetItem {
        public final List<Role> roles = new LinkedList<Role>();

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            p.add((Component)new JLabel(" "), GBC.eol());
            if (!this.roles.isEmpty()) {
                JPanel proles = new JPanel(new GridBagLayout());
                proles.add((Component)new JLabel(I18n.tr("Available roles", new Object[0])), GBC.std().insets(0, 0, 10, 0));
                proles.add((Component)new JLabel(I18n.tr("role", new Object[0])), GBC.std().insets(0, 0, 10, 0));
                proles.add((Component)new JLabel(I18n.tr("count", new Object[0])), GBC.std().insets(0, 0, 10, 0));
                proles.add((Component)new JLabel(I18n.tr("elements", new Object[0])), GBC.eol());
                for (Role i : this.roles) {
                    i.addToPanel(proles, sel);
                }
                p.add((Component)proles, GBC.eol());
            }
            return false;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
        }
    }

    public static class PresetLink
    extends TaggingPresetItem {
        public String preset_name = "";

        @Override
        boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            final String presetName = this.preset_name;
            final TaggingPreset t = Utils.filter(TaggingPresets.getTaggingPresets(), new Predicate<TaggingPreset>(){

                @Override
                public boolean evaluate(TaggingPreset object) {
                    return presetName.equals(object.name);
                }
            }).iterator().next();
            if (t == null) {
                return false;
            }
            PresetLabel lbl = new PresetLabel(t);
            lbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    t.actionPerformed(null);
                }
            });
            p.add((Component)lbl, GBC.eol().fill(2));
            return false;
        }

        @Override
        void addCommands(List<Tag> changedTags) {
        }
    }

    public static class Link
    extends TaggingPresetTextItem {
        public String href;
        public String locale_href;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            this.initializeLocaleText(I18n.tr("More information about this feature", new Object[0]));
            String url = this.locale_href;
            if (url == null) {
                url = this.href;
            }
            if (url != null) {
                p.add((Component)new UrlLabel(url, this.locale_text, 2), GBC.eol().insets(0, 10, 0, 0).fill(2));
            }
            return false;
        }

        @Override
        protected String fieldsToString() {
            return super.fieldsToString() + (this.href != null ? "href=" + this.href + ", " : "") + (this.locale_href != null ? "locale_href=" + this.locale_href + ", " : "");
        }
    }

    public static class Label
    extends TaggingPresetTextItem {
        public String icon;
        public String icon_size;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
            this.initializeLocaleText(null);
            Label.addLabel(p, this.getIcon(), this.locale_text);
            return true;
        }

        public static void addLabel(JPanel p, Icon icon, String label) {
            p.add((Component)new JLabel(label, icon, 10), GBC.eol().fill(2));
        }

        public ImageIcon getIcon() {
            Integer size = TaggingPresetItems.parseInteger(this.icon_size);
            return this.icon == null ? null : TaggingPresetItems.loadImageIcon(this.icon, TaggingPresetReader.getZipIcons(), size != null ? size : 16);
        }
    }

    public static abstract class TaggingPresetTextItem
    extends TaggingPresetItem {
        public String text;
        public String text_context;
        public String locale_text;

        protected final void initializeLocaleText(String defaultText) {
            if (this.locale_text == null) {
                this.locale_text = TaggingPresetItems.getLocaleText(this.text, this.text_context, defaultText);
            }
        }

        @Override
        void addCommands(List<Tag> changedTags) {
        }

        protected String fieldsToString() {
            return (this.text != null ? "text=" + this.text + ", " : "") + (this.text_context != null ? "text_context=" + this.text_context + ", " : "") + (this.locale_text != null ? "locale_text=" + this.locale_text : "");
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + this.fieldsToString() + "]";
        }
    }

    public static class Usage {
        TreeSet<String> values;
        boolean hadKeys = false;
        boolean hadEmpty = false;

        public boolean hasUniqueValue() {
            return this.values.size() == 1 && !this.hadEmpty;
        }

        public boolean unused() {
            return this.values.isEmpty();
        }

        public String getFirst() {
            return this.values.first();
        }

        public boolean hadKeys() {
            return this.hadKeys;
        }
    }

    public static enum MatchType {
        NONE("none"),
        KEY("key"),
        KEY_REQUIRED("key!"),
        KEY_VALUE("keyvalue"),
        KEY_VALUE_REQUIRED("keyvalue!");

        private final String value;

        private MatchType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static MatchType ofString(String type) {
            for (MatchType i : EnumSet.allOf(MatchType.class)) {
                if (!i.getValue().equals(type)) continue;
                return i;
            }
            throw new IllegalArgumentException(type + " is not allowed");
        }
    }

    public static class Role {
        public EnumSet<TaggingPresetType> types;
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public SearchCompiler.Match memberExpression;
        public boolean required = false;
        private long count = 0L;

        public void setType(String types) throws SAXException {
            this.types = TaggingPresetItems.getType(types);
        }

        public void setRequisite(String str) throws SAXException {
            if ("required".equals(str)) {
                this.required = true;
            } else if (!"optional".equals(str)) {
                throw new SAXException(I18n.tr("Unknown requisite: {0}", str));
            }
        }

        public void setMember_expression(String member_expression) throws SAXException {
            try {
                this.memberExpression = SearchCompiler.compile(member_expression, true, true);
            }
            catch (SearchCompiler.ParseError ex) {
                throw new SAXException(I18n.tr("Illegal member expression: {0}", ex.getMessage()), ex);
            }
        }

        public void setCount(String count) {
            this.count = Long.parseLong(count);
        }

        public long getValidCount(long c) {
            if (this.count > 0L && !this.required) {
                return c != 0L ? this.count : 0L;
            }
            if (this.count > 0L) {
                return this.count;
            }
            if (!this.required) {
                return c != 0L ? c : 0L;
            }
            return c != 0L ? c : 1L;
        }

        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            String cstring = this.count > 0L && !this.required ? "0," + this.count : (this.count > 0L ? String.valueOf(this.count) : (!this.required ? "0-..." : "1-..."));
            if (this.locale_text == null) {
                this.locale_text = TaggingPresetItems.getLocaleText(this.text, this.text_context, null);
            }
            p.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)new JLabel(this.key), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)new JLabel(cstring), this.types == null ? GBC.eol() : GBC.std().insets(0, 0, 10, 0));
            if (this.types != null) {
                JPanel pp = new JPanel();
                for (TaggingPresetType t : this.types) {
                    pp.add(new JLabel(ImageProvider.get(t.getIconName())));
                }
                p.add((Component)pp, GBC.eol());
            }
            return true;
        }
    }

    public static class PresetListEntry {
        public String value;
        public String value_context;
        public String display_value;
        public String short_description;
        public String icon;
        public String icon_size;
        public String locale_display_value;
        public String locale_short_description;
        private final File zipIcons = TaggingPresetReader.getZipIcons();
        private int prefferedWidth = -1;
        private int prefferedHeight = -1;

        public String getListDisplay() {
            if (this.value.equals(DIFFERENT)) {
                return "<b>" + DIFFERENT.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</b>";
            }
            if (this.value.isEmpty()) {
                return "&nbsp;";
            }
            StringBuilder res = new StringBuilder("<b>");
            res.append(this.getDisplayValue(true).replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
            res.append("</b>");
            if (this.getShortDescription(true) != null) {
                res.append("<div style=\"width:300px; padding:0 0 5px 5px\">");
                res.append(this.getShortDescription(true));
                res.append("</div>");
            }
            return res.toString();
        }

        public ImageIcon getIcon() {
            return this.icon == null ? null : TaggingPresetItems.loadImageIcon(this.icon, this.zipIcons, TaggingPresetItems.parseInteger(this.icon_size));
        }

        public PresetListEntry() {
        }

        public PresetListEntry(String value) {
            this.value = value;
        }

        public String getDisplayValue(boolean translated) {
            return translated ? Utils.firstNonNull(this.locale_display_value, I18n.tr(this.display_value, new Object[0]), I18n.trc(this.value_context, this.value)) : Utils.firstNonNull(this.display_value, this.value);
        }

        public String getShortDescription(boolean translated) {
            return translated ? Utils.firstNonNull(this.locale_short_description, I18n.tr(this.short_description, new Object[0])) : this.short_description;
        }

        public String toString() {
            if (this.value.equals(DIFFERENT)) {
                return DIFFERENT;
            }
            return this.getDisplayValue(true).replaceAll("<.*>", "");
        }
    }
}

