/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.PasteTagsAction;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.dialogs.relation.RunnableAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.TextTagParser;
import org.openstreetmap.josm.tools.Utils;

public class TagTable
extends JTable {
    private TagCellEditor editor = null;
    private final TagEditorModel model;
    private Component nextFocusComponent;
    private final CopyOnWriteArrayList<Component> doNotStopCellEditingWhenFocused = new CopyOnWriteArrayList();
    private CellEditorRemover editorRemover;
    private RunnableAction deleteAction = null;
    private RunnableAction addAction = null;
    private RunnableAction pasteAction = null;

    public RunnableAction getDeleteAction() {
        return this.deleteAction;
    }

    public RunnableAction getAddAction() {
        return this.addAction;
    }

    public RunnableAction getPasteAction() {
        return this.pasteAction;
    }

    protected final void init() {
        this.setAutoResizeMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setSelectionMode(1);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.deleteAction = new DeleteAction();
        this.addAction = new AddAction();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(107, 2), "addTag");
        this.getActionMap().put("addTag", this.addAction);
        this.pasteAction = new PasteAction();
        TagCellEditor tmpEditor = new TagCellEditor();
        this.setRowHeight(tmpEditor.getEditor().getPreferredSize().height);
        this.setTagCellEditor(tmpEditor);
    }

    public TagTable(TagEditorModel model) {
        super(model, new TagTableColumnModel(model.getColumnSelectionModel()), model.getRowSelectionModel());
        this.model = model;
        this.init();
    }

    @Override
    public Dimension getPreferredSize() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof JViewport); c = c.getParent()) {
        }
        if (c != null) {
            Dimension d = super.getPreferredSize();
            d.width = c.getSize().width;
            return d;
        }
        return super.getPreferredSize();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 127) {
            if (this.isEditing() && this.getSelectedColumnCount() == 1 && this.getSelectedRowCount() == 1) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            this.getDeleteAction().run();
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        if (autoCompletionList == null) {
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionList(autoCompletionList);
        }
    }

    public void setAutoCompletionManager(AutoCompletionManager autocomplete) {
        if (autocomplete == null) {
            Main.warn("argument autocomplete should not be null. Aborting.");
            Thread.dumpStack();
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionManager(autocomplete);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        if (this.editor != null) {
            return this.editor.getAutoCompletionList();
        }
        return null;
    }

    public void setNextFocusComponent(Component nextFocusComponent) {
        this.nextFocusComponent = nextFocusComponent;
    }

    public TagCellEditor getTableCellEditor() {
        return this.editor;
    }

    public void addOKAccelatorListener(KeyListener l) {
        this.addKeyListener(l);
        if (this.editor != null) {
            this.editor.getEditor().addKeyListener(l);
        }
    }

    public void setTagCellEditor(TagCellEditor editor) {
        if (this.isEditing()) {
            this.editor.cancelCellEditing();
        }
        this.editor = editor;
        this.getColumnModel().getColumn(0).setCellEditor(editor);
        this.getColumnModel().getColumn(1).setCellEditor(editor);
    }

    public void requestFocusInCell(int row, int col) {
        this.changeSelection(row, col, false, false);
        this.editCellAt(row, col);
        Component c = this.getEditorComponent();
        if (c != null) {
            c.requestFocusInWindow();
            if (c instanceof JTextComponent) {
                ((JTextComponent)c).selectAll();
            }
        }
    }

    public void addComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.addIfAbsent(component);
    }

    public void removeComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.remove(component);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        return super.editCellAt(row, column, e);
    }

    @Override
    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeEditor();
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeNotify();
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!TagTable.this.isEditing()) {
                return;
            }
            for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                if (c == TagTable.this) {
                    return;
                }
                if (TagTable.this.doNotStopCellEditingWhenFocused.contains(c)) {
                    return;
                }
                if (!(c instanceof Window)) continue;
                if (c != SwingUtilities.getRoot(TagTable.this) || TagTable.this.getCellEditor().stopCellEditing()) break;
                TagTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    class PasteAction
    extends RunnableAction
    implements PropertyChangeListener {
        public PasteAction() {
            this.putValue("SmallIcon", ImageProvider.get("", "pastetags"));
            this.putValue("ShortDescription", I18n.tr("Paste tags from buffer", new Object[0]));
            TagTable.this.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        @Override
        public void run() {
            Relation relation = new Relation();
            TagTable.this.model.applyToPrimitive(relation);
            String buf = Utils.getClipboardContent();
            if (buf == null || buf.isEmpty() || buf.matches("((node|way|relation)\\s\\d+,)*(node|way|relation)\\s\\d+")) {
                List<PrimitiveData> directlyAdded = Main.pasteBuffer.getDirectlyAdded();
                if (directlyAdded == null || directlyAdded.isEmpty()) {
                    return;
                }
                PasteTagsAction.TagPaster tagPaster = new PasteTagsAction.TagPaster(directlyAdded, Collections.singletonList(relation));
                TagTable.this.model.updateTags(tagPaster.execute());
            } else {
                Map<String, String> tags = TextTagParser.readTagsFromText(buf);
                if (tags == null || tags.isEmpty()) {
                    TextTagParser.showBadBufferMessage(HelpUtil.ht("/Action/PasteTags"));
                } else if (TextTagParser.validateTags(tags)) {
                    ArrayList<Tag> newTags = new ArrayList<Tag>();
                    for (Map.Entry<String, String> entry : tags.entrySet()) {
                        String k = entry.getKey();
                        String v = entry.getValue();
                        newTags.add(new Tag(k, v));
                    }
                    TagTable.this.model.updateTags(newTags);
                }
            }
        }

        protected final void updateEnabledState() {
            this.setEnabled(TagTable.this.isEnabled());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends RunnableAction
    implements PropertyChangeListener {
        public AddAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            this.putValue("ShortDescription", I18n.tr("Add a new tag", new Object[0]));
            TagTable.this.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        @Override
        public void run() {
            TableCellEditor editor = TagTable.this.getCellEditor();
            if (editor != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            int rowIdx = TagTable.this.model.getRowCount() - 1;
            String key = ((TagModel)TagTable.this.model.getValueAt(rowIdx, 0)).getName();
            if (!key.trim().isEmpty()) {
                TagTable.this.model.appendNewTag();
            }
            TagTable.this.requestFocusInCell(TagTable.this.model.getRowCount() - 1, 0);
        }

        protected final void updateEnabledState() {
            this.setEnabled(TagTable.this.isEnabled());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends RunnableAction
    implements ListSelectionListener {
        public DeleteAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selection in the tag table", new Object[0]));
            TagTable.this.getSelectionModel().addListSelectionListener(this);
            TagTable.this.getColumnModel().getSelectionModel().addListSelectionListener(this);
            this.updateEnabledState();
        }

        protected void deleteTagNames() {
            int[] rows = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTagNames(rows);
        }

        protected void deleteTagValues() {
            int[] rows = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTagValues(rows);
        }

        protected void deleteTags() {
            int[] rows = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTags(rows);
        }

        @Override
        public void run() {
            TableCellEditor editor;
            if (!this.isEnabled()) {
                return;
            }
            switch (TagTable.this.getSelectedColumnCount()) {
                case 1: {
                    if (TagTable.this.getSelectedColumn() == 0) {
                        this.deleteTagNames();
                        break;
                    }
                    if (TagTable.this.getSelectedColumn() != 1) break;
                    this.deleteTagValues();
                    break;
                }
                case 2: {
                    this.deleteTags();
                }
            }
            if (TagTable.this.isEditing() && (editor = TagTable.this.getCellEditor()) != null) {
                editor.cancelCellEditing();
            }
            if (TagTable.this.model.getRowCount() == 0) {
                TagTable.this.model.ensureOneTag();
                TagTable.this.requestFocusInCell(0, 0);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            if (TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else if (!TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else if (TagTable.this.getSelectedColumnCount() > 1 || TagTable.this.getSelectedRowCount() > 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int col = TagTable.this.getSelectedColumn();
            int row = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (col > 0 || row > 0) {
                if (col == 1) {
                    --col;
                } else {
                    col = 1;
                    --row;
                }
            }
            TagTable.this.requestFocusInCell(row, col);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int col = TagTable.this.getSelectedColumn();
            int row = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (row == -1 && col == -1) {
                TagTable.this.requestFocusInCell(0, 0);
                return;
            }
            if (col == 0) {
                ++col;
            } else if (col == 1 && row < TagTable.this.getRowCount() - 1) {
                col = 0;
                ++row;
            } else if (col == 1 && row == TagTable.this.getRowCount() - 1) {
                String key = ((TagModel)TagTable.this.model.getValueAt(row, 0)).getName();
                if (!key.trim().isEmpty()) {
                    TagTable.this.model.appendNewTag();
                    col = 0;
                    ++row;
                } else {
                    TagTable.this.clearSelection();
                    if (TagTable.this.nextFocusComponent != null) {
                        TagTable.this.nextFocusComponent.requestFocusInWindow();
                    }
                    return;
                }
            }
            TagTable.this.requestFocusInCell(row, col);
        }
    }

    static class TagTableColumnModel
    extends DefaultTableColumnModel {
        public TagTableColumnModel(DefaultListSelectionModel selectionModel) {
            this.setSelectionModel(selectionModel);
            TableColumn col = null;
            TagCellRenderer renderer = new TagCellRenderer();
            col = new TableColumn(0);
            col.setHeaderValue(I18n.tr("Key", new Object[0]));
            col.setResizable(true);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            col = new TableColumn(1);
            col.setHeaderValue(I18n.tr("Value", new Object[0]));
            col.setResizable(true);
            col.setCellRenderer(renderer);
            this.addColumn(col);
        }
    }
}

