/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.awt.Component;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class SwingRenderingProgressMonitor
extends AbstractProgressMonitor {
    private int currentProgressValue = 0;
    private ProgressRenderer delegate;

    public SwingRenderingProgressMonitor(ProgressRenderer delegate) {
        super(new CancelHandler());
        CheckParameterUtil.ensureParameterNotNull(delegate, "delegate");
        this.delegate = delegate;
    }

    @Override
    public void doBeginTask() {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setCustomText("");
                SwingRenderingProgressMonitor.this.delegate.setMaximum(100);
            }
        });
    }

    @Override
    public void doFinishTask() {
    }

    @Override
    protected void updateProgress(double progressValue) {
        int newValue = (int)(progressValue * 100.0);
        if (newValue != this.currentProgressValue) {
            this.currentProgressValue = newValue;
            GuiHelper.runInEDT(new Runnable(){

                @Override
                public void run() {
                    SwingRenderingProgressMonitor.this.delegate.setValue(SwingRenderingProgressMonitor.this.currentProgressValue);
                }
            });
        }
    }

    @Override
    protected void doSetCustomText(final String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setCustomText(title);
            }
        });
    }

    @Override
    protected void doSetTitle(final String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setTaskTitle(title);
            }
        });
    }

    @Override
    protected void doSetIntermediate(final boolean value) {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setIndeterminate(value);
            }
        });
    }

    @Override
    public void setProgressTaskId(ProgressTaskId taskId) {
    }

    @Override
    public ProgressTaskId getProgressTaskId() {
        return null;
    }

    @Override
    public Component getWindowParent() {
        return Main.parent;
    }
}

