/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressException;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;

public class PleaseWaitProgressMonitor
extends AbstractProgressMonitor {
    public static final int PROGRESS_BAR_MAX = 10000;
    private final Window dialogParent;
    private int currentProgressValue = 0;
    private String customText;
    private String title;
    private boolean indeterminate;
    private boolean isInBackground;
    private PleaseWaitDialog dialog;
    private String windowTitle;
    protected ProgressTaskId taskId;
    private boolean cancelable;
    private ActionListener cancelListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PleaseWaitProgressMonitor.this.cancel();
        }
    };
    private ActionListener inBackgroundListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PleaseWaitProgressMonitor.this.isInBackground = true;
            ProgressMonitorDialog dialog = PleaseWaitProgressMonitor.this.getDialog();
            if (dialog != null) {
                PleaseWaitProgressMonitor.this.reset();
                dialog.setVisible(true);
            }
        }
    };
    private WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            PleaseWaitProgressMonitor.this.cancel();
        }
    };

    private void doInEDT(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    private void setDialogVisible(boolean visible) {
        if (this.dialog.isVisible() != visible) {
            this.dialog.setVisible(visible);
        }
    }

    private ProgressMonitorDialog getDialog() {
        MapStatus.BackgroundProgressMonitor backgroundMonitor = null;
        MapFrame map = Main.map;
        if (map != null) {
            backgroundMonitor = map.statusLine.progressMonitor;
        }
        if (backgroundMonitor != null) {
            backgroundMonitor.setVisible(this.isInBackground);
        }
        if (this.dialog != null) {
            this.setDialogVisible(!this.isInBackground || backgroundMonitor == null);
        }
        if (this.isInBackground && backgroundMonitor != null) {
            backgroundMonitor.setVisible(true);
            if (this.dialog != null) {
                this.setDialogVisible(false);
            }
            return backgroundMonitor;
        }
        if (backgroundMonitor != null) {
            backgroundMonitor.setVisible(false);
            if (this.dialog != null) {
                this.setDialogVisible(true);
            }
            return this.dialog;
        }
        if (this.dialog != null) {
            this.setDialogVisible(true);
            return this.dialog;
        }
        return null;
    }

    public PleaseWaitProgressMonitor() {
        this("");
    }

    public PleaseWaitProgressMonitor(String windowTitle) {
        this(Main.parent);
        this.windowTitle = windowTitle;
    }

    public PleaseWaitProgressMonitor(Component dialogParent) {
        super(new CancelHandler());
        this.dialogParent = JOptionPane.getFrameForComponent(dialogParent);
        this.cancelable = true;
    }

    public PleaseWaitProgressMonitor(Component dialogParent, String windowTitle) {
        this(JOptionPane.getFrameForComponent(dialogParent));
        this.windowTitle = windowTitle;
    }

    public final boolean isCancelable() {
        return this.cancelable;
    }

    public final void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    @Override
    public void doBeginTask() {
        this.doInEDT(new Runnable(){

            @Override
            public void run() {
                Main.currentProgressMonitor = PleaseWaitProgressMonitor.this;
                if (PleaseWaitProgressMonitor.this.dialogParent instanceof Frame && PleaseWaitProgressMonitor.this.dialog == null) {
                    PleaseWaitProgressMonitor.this.dialog = new PleaseWaitDialog((Component)PleaseWaitProgressMonitor.this.dialogParent);
                } else if (PleaseWaitProgressMonitor.this.dialogParent instanceof Dialog && PleaseWaitProgressMonitor.this.dialog == null) {
                    PleaseWaitProgressMonitor.this.dialog = new PleaseWaitDialog((Component)PleaseWaitProgressMonitor.this.dialogParent);
                } else {
                    throw new ProgressException("PleaseWaitDialog parent must be either Frame or Dialog", new Object[0]);
                }
                if (PleaseWaitProgressMonitor.this.windowTitle != null) {
                    PleaseWaitProgressMonitor.this.dialog.setTitle(PleaseWaitProgressMonitor.this.windowTitle);
                }
                PleaseWaitProgressMonitor.this.dialog.setCancelEnabled(PleaseWaitProgressMonitor.this.cancelable);
                PleaseWaitProgressMonitor.this.dialog.setCancelCallback(PleaseWaitProgressMonitor.this.cancelListener);
                PleaseWaitProgressMonitor.this.dialog.setInBackgroundCallback(PleaseWaitProgressMonitor.this.inBackgroundListener);
                PleaseWaitProgressMonitor.this.dialog.setCustomText("");
                PleaseWaitProgressMonitor.this.dialog.addWindowListener(PleaseWaitProgressMonitor.this.windowListener);
                ((PleaseWaitProgressMonitor)PleaseWaitProgressMonitor.this).dialog.progress.setMaximum(10000);
                PleaseWaitProgressMonitor.this.dialog.setVisible(true);
            }
        });
    }

    @Override
    public void doFinishTask() {
    }

    @Override
    protected void updateProgress(double progressValue) {
        int newValue = (int)(progressValue * 10000.0);
        if (newValue != this.currentProgressValue) {
            this.currentProgressValue = newValue;
            this.doInEDT(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitorDialog dialog = PleaseWaitProgressMonitor.this.getDialog();
                    if (dialog != null) {
                        dialog.updateProgress(PleaseWaitProgressMonitor.this.currentProgressValue);
                    }
                }
            });
        }
    }

    @Override
    protected void doSetCustomText(final String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.customText = title;
        this.doInEDT(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog dialog = PleaseWaitProgressMonitor.this.getDialog();
                if (dialog != null) {
                    dialog.setCustomText(title);
                }
            }
        });
    }

    @Override
    protected void doSetTitle(final String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.title = title;
        this.doInEDT(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog dialog = PleaseWaitProgressMonitor.this.getDialog();
                if (dialog != null) {
                    dialog.setCurrentAction(title);
                }
            }
        });
    }

    @Override
    protected void doSetIntermediate(final boolean value) {
        this.indeterminate = value;
        this.doInEDT(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog dialog = PleaseWaitProgressMonitor.this.getDialog();
                if (dialog != null) {
                    dialog.setIndeterminate(value && PleaseWaitProgressMonitor.this.currentProgressValue == 0);
                }
            }
        });
    }

    @Override
    public void appendLogMessage(final String message) {
        this.doInEDT(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog dialog = PleaseWaitProgressMonitor.this.getDialog();
                if (dialog != null) {
                    dialog.appendLogMessage(message);
                }
            }
        });
    }

    public void reset() {
        if (this.dialog != null) {
            this.dialog.setTitle(this.title);
            this.dialog.setCustomText(this.customText);
            this.dialog.updateProgress(this.currentProgressValue);
            this.dialog.setIndeterminate(this.indeterminate && this.currentProgressValue == 0);
        }
        MapStatus.BackgroundProgressMonitor backgroundMonitor = null;
        MapFrame map = Main.map;
        if (map != null) {
            backgroundMonitor = map.statusLine.progressMonitor;
        }
        if (backgroundMonitor != null) {
            backgroundMonitor.setCurrentAction(this.title);
            backgroundMonitor.setCustomText(this.customText);
            backgroundMonitor.updateProgress(this.currentProgressValue);
            backgroundMonitor.setIndeterminate(this.indeterminate && this.currentProgressValue == 0);
        }
    }

    public void close() {
        this.doInEDT(new Runnable(){

            @Override
            public void run() {
                if (PleaseWaitProgressMonitor.this.dialog != null) {
                    PleaseWaitProgressMonitor.this.dialog.setVisible(false);
                    PleaseWaitProgressMonitor.this.dialog.setCancelCallback(null);
                    PleaseWaitProgressMonitor.this.dialog.setInBackgroundCallback(null);
                    PleaseWaitProgressMonitor.this.dialog.removeWindowListener(PleaseWaitProgressMonitor.this.windowListener);
                    PleaseWaitProgressMonitor.this.dialog.dispose();
                    PleaseWaitProgressMonitor.this.dialog = null;
                    Main.currentProgressMonitor = null;
                    MapFrame map = Main.map;
                    if (map != null) {
                        map.statusLine.progressMonitor.setVisible(false);
                    }
                }
            }
        });
    }

    public void showForegroundDialog() {
        this.isInBackground = false;
        this.doInEDT(new Runnable(){

            @Override
            public void run() {
                if (PleaseWaitProgressMonitor.this.dialog != null) {
                    PleaseWaitProgressMonitor.this.dialog.setInBackgroundPossible(PleaseWaitProgressMonitor.this.taskId != null && Main.isDisplayingMapView());
                    PleaseWaitProgressMonitor.this.reset();
                    PleaseWaitProgressMonitor.this.getDialog();
                }
            }
        });
    }

    @Override
    public void setProgressTaskId(ProgressTaskId taskId) {
        this.taskId = taskId;
        this.doInEDT(new Runnable(){

            @Override
            public void run() {
                if (PleaseWaitProgressMonitor.this.dialog != null) {
                    PleaseWaitProgressMonitor.this.dialog.setInBackgroundPossible(PleaseWaitProgressMonitor.this.taskId != null && Main.isDisplayingMapView());
                }
            }
        });
    }

    @Override
    public ProgressTaskId getProgressTaskId() {
        return this.taskId;
    }

    @Override
    public Component getWindowParent() {
        PleaseWaitDialog parent = this.dialog;
        if (this.isInBackground || parent == null) {
            return Main.parent;
        }
        return parent;
    }

    public static interface ProgressMonitorDialog {
        public void setVisible(boolean var1);

        public void updateProgress(int var1);

        public void setCustomText(String var1);

        public void setCurrentAction(String var1);

        public void setIndeterminate(boolean var1);

        public void appendLogMessage(String var1);
    }
}

