/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.SourceProvider;
import org.openstreetmap.josm.gui.preferences.SourceType;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.tools.I18n;

public class ValidatorTagCheckerRulesPreference
implements SubPreferenceSetting {
    private static final List<SourceProvider> ruleSourceProviders = new ArrayList<SourceProvider>();
    private SourceEditor sources;

    public static final boolean registerSourceProvider(SourceProvider provider) {
        if (provider != null) {
            return ruleSourceProviders.add(provider);
        }
        return false;
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        ValidatorPreference valPref = gui.getValidatorPreference();
        this.sources = new TagCheckerRulesSourceEditor();
        valPref.addSubTab(this, I18n.tr("Tag checker rules", new Object[0]), this.sources, I18n.tr("Choose Tag checker rules to enable", new Object[0]));
        this.sources.deferLoading(valPref, this.sources);
    }

    @Override
    public boolean ok() {
        MapCSSTagChecker tagChecker;
        if (this.sources.finish() && (tagChecker = OsmValidator.getTest(MapCSSTagChecker.class)) != null) {
            OsmValidator.initializeTests(Collections.singleton(tagChecker));
        }
        return false;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getValidatorPreference();
    }

    public static class RulePrefHelper
    extends SourceEditor.SourcePrefHelper {
        public static final RulePrefHelper INSTANCE = new RulePrefHelper();

        public RulePrefHelper() {
            super(MapCSSTagChecker.ENTRIES_PREF_KEY);
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            ArrayList<SourceEditor.ExtendedSourceEntry> def = new ArrayList<SourceEditor.ExtendedSourceEntry>();
            this.addDefault(def, "addresses", I18n.tr("Addresses", new Object[0]), I18n.tr("Checks for errors on addresses", new Object[0]));
            this.addDefault(def, "combinations", I18n.tr("Tag combinations", new Object[0]), I18n.tr("Checks for missing tag or suspicious combinations", new Object[0]));
            this.addDefault(def, "deprecated", I18n.tr("Deprecated features", new Object[0]), I18n.tr("Checks for deprecated features", new Object[0]));
            this.addDefault(def, "geometry", I18n.tr("Geometry", new Object[0]), I18n.tr("Checks for geometry errors", new Object[0]));
            this.addDefault(def, "highway", I18n.tr("Highways", new Object[0]), I18n.tr("Checks for errors on highways", new Object[0]));
            this.addDefault(def, "multiple", I18n.tr("Multiple values", new Object[0]), I18n.tr("Checks for wrong multiple values", new Object[0]));
            this.addDefault(def, "numeric", I18n.tr("Numeric values", new Object[0]), I18n.tr("Checks for wrong numeric values", new Object[0]));
            this.addDefault(def, "power", I18n.tr("Power", new Object[0]), I18n.tr("Checks for errors on power infrastructures", new Object[0]));
            this.addDefault(def, "religion", I18n.tr("Religion", new Object[0]), I18n.tr("Checks for errors on religious objects", new Object[0]));
            this.addDefault(def, "relation", I18n.tr("Relations", new Object[0]), I18n.tr("Checks for errors on relations", new Object[0]));
            this.addDefault(def, "unnecessary", I18n.tr("Unnecessary tags", new Object[0]), I18n.tr("Checks for unnecessary tags", new Object[0]));
            this.addDefault(def, "wikipedia", I18n.tr("Wikipedia", new Object[0]), I18n.tr("Checks for wrong wikipedia tags", new Object[0]));
            return def;
        }

        private void addDefault(List<SourceEditor.ExtendedSourceEntry> defaults, String filename, String title, String description) {
            SourceEditor.ExtendedSourceEntry i = new SourceEditor.ExtendedSourceEntry(filename + ".mapcss", "resource://data/validator/" + filename + ".mapcss");
            i.title = title;
            i.description = description;
            defaults.add(i);
        }

        @Override
        public Map<String, String> serialize(SourceEntry entry) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("url", entry.url);
            res.put("title", entry.title == null ? "" : entry.title);
            res.put("active", Boolean.toString(entry.active));
            return res;
        }

        @Override
        public SourceEntry deserialize(Map<String, String> s) {
            return new SourceEntry(s.get("url"), null, s.get("title"), Boolean.parseBoolean(s.get("active")));
        }
    }

    static class TagCheckerRulesSourceEditor
    extends SourceEditor {
        public TagCheckerRulesSourceEditor() {
            super(SourceType.TAGCHECKER_RULE, Main.getJOSMWebsite() + "/rules", ruleSourceProviders, false);
        }

        @Override
        public Collection<? extends SourceEntry> getInitialSourcesList() {
            return RulePrefHelper.INSTANCE.get();
        }

        @Override
        public boolean finish() {
            return RulePrefHelper.INSTANCE.put(this.activeSourcesModel.getSources());
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            return RulePrefHelper.INSTANCE.getDefault();
        }

        @Override
        public Collection<String> getInitialIconPathsList() {
            return null;
        }

        @Override
        public String getStr(SourceEditor.I18nString ident) {
            switch (ident) {
                case AVAILABLE_SOURCES: {
                    return I18n.tr("Available rules:", new Object[0]);
                }
                case ACTIVE_SOURCES: {
                    return I18n.tr("Active rules:", new Object[0]);
                }
                case NEW_SOURCE_ENTRY_TOOLTIP: {
                    return I18n.tr("Add a new rule by entering filename or URL", new Object[0]);
                }
                case NEW_SOURCE_ENTRY: {
                    return I18n.tr("New rule entry:", new Object[0]);
                }
                case REMOVE_SOURCE_TOOLTIP: {
                    return I18n.tr("Remove the selected rules from the list of active rules", new Object[0]);
                }
                case EDIT_SOURCE_TOOLTIP: {
                    return I18n.tr("Edit the filename or URL for the selected active rule", new Object[0]);
                }
                case ACTIVATE_TOOLTIP: {
                    return I18n.tr("Add the selected available rules to the list of active rules", new Object[0]);
                }
                case RELOAD_ALL_AVAILABLE: {
                    return I18n.marktr("Reloads the list of available rules from ''{0}''");
                }
                case LOADING_SOURCES_FROM: {
                    return I18n.marktr("Loading rule sources from ''{0}''");
                }
                case FAILED_TO_LOAD_SOURCES_FROM: {
                    return I18n.marktr("<html>Failed to load the list of rule sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>");
                }
                case FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC: {
                    return "/Preferences/Rules#FailedToLoadRuleSources";
                }
                case ILLEGAL_FORMAT_OF_ENTRY: {
                    return I18n.marktr("Warning: illegal format of entry in rule list ''{0}''. Got ''{1}''");
                }
            }
            throw new AssertionError();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ValidatorTagCheckerRulesPreference();
        }
    }
}

