/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.tools.I18n;

public final class ServerAccessPreference
extends DefaultTabPreferenceSetting {
    private OsmApiUrlInputPanel pnlApiUrlPreferences;

    private ServerAccessPreference() {
        super("connection", I18n.tr("Connection Settings", new Object[0]), I18n.tr("Connection Settings for the OSM server.", new Object[0]), false, new JTabbedPane());
    }

    protected JPanel buildTabbedServerPreferences() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.getTabPane(), "Center");
        return pnl;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 0, 0, 0);
        this.pnlApiUrlPreferences = new OsmApiUrlInputPanel();
        pnl.add((Component)this.pnlApiUrlPreferences, gc);
        gc.gridy = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.insets = new Insets(10, 0, 3, 3);
        pnl.add((Component)this.buildTabbedServerPreferences(), gc);
        HelpUtil.setHelpContext(pnl, HelpUtil.ht("/Preferences/Connection"));
        return pnl;
    }

    public final void addApiUrlChangeListener(PropertyChangeListener listener) {
        this.pnlApiUrlPreferences.addPropertyChangeListener(listener);
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 18;
        gui.createPreferenceTab(this).add((Component)this.buildContentPanel(), gc);
        this.pnlApiUrlPreferences.initFromPreferences();
    }

    @Override
    public boolean ok() {
        this.pnlApiUrlPreferences.saveToPreferences();
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ServerAccessPreference();
        }
    }
}

