/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ProxyPreferencesPanel
extends VerticallyScrollablePanel {
    public static final String PROXY_POLICY = "proxy.policy";
    public static final String PROXY_HTTP_HOST = "proxy.http.host";
    public static final String PROXY_HTTP_PORT = "proxy.http.port";
    public static final String PROXY_SOCKS_HOST = "proxy.socks.host";
    public static final String PROXY_SOCKS_PORT = "proxy.socks.port";
    public static final String PROXY_USER = "proxy.user";
    public static final String PROXY_PASS = "proxy.pass";
    public static final String PROXY_EXCEPTIONS = "proxy.exceptions";
    private Map<ProxyPolicy, JRadioButton> rbProxyPolicy;
    private JosmTextField tfProxyHttpHost;
    private JosmTextField tfProxyHttpPort;
    private JosmTextField tfProxySocksHost;
    private JosmTextField tfProxySocksPort;
    private JosmTextField tfProxyHttpUser;
    private JosmPasswordField tfProxyHttpPassword;
    private JPanel pnlHttpProxyConfigurationPanel;
    private JPanel pnlSocksProxyConfigurationPanel;

    protected final JPanel buildHttpProxyConfigurationPanel() {
        JPanel pnl = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.insets = new Insets(5, 5, 0, 0);
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Host:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxyHttpHost = new JosmTextField();
        pnl.add((Component)this.tfProxyHttpHost, gc);
        gc.gridy = 1;
        gc.gridx = 0;
        gc.fill = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.trc("server", "Port:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxyHttpPort = new JosmTextField(5);
        pnl.add((Component)this.tfProxyHttpPort, gc);
        this.tfProxyHttpPort.setMinimumSize(this.tfProxyHttpPort.getPreferredSize());
        gc.gridy = 2;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 2;
        gc.weightx = 1.0;
        pnl.add((Component)new JMultilineLabel(I18n.tr("Please enter a username and a password if your proxy requires authentication.", new Object[0])), gc);
        gc.gridy = 3;
        gc.gridx = 0;
        gc.gridwidth = 1;
        gc.fill = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("User:", new Object[0])), gc);
        gc.gridy = 3;
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxyHttpUser = new JosmTextField(20);
        pnl.add((Component)this.tfProxyHttpUser, gc);
        this.tfProxyHttpUser.setMinimumSize(this.tfProxyHttpUser.getPreferredSize());
        gc.gridy = 4;
        gc.gridx = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Password:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxyHttpPassword = new JosmPasswordField(20);
        pnl.add((Component)this.tfProxyHttpPassword, gc);
        this.tfProxyHttpPassword.setMinimumSize(this.tfProxyHttpPassword.getPreferredSize());
        gc.gridy = 5;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected final JPanel buildSocksProxyConfigurationPanel() {
        JPanel pnl = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.insets = new Insets(5, 5, 0, 0);
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Host:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxySocksHost = new JosmTextField(20);
        pnl.add((Component)this.tfProxySocksHost, gc);
        gc.gridy = 1;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.fill = 0;
        pnl.add((Component)new JLabel(I18n.trc("server", "Port:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxySocksPort = new JosmTextField(5);
        pnl.add((Component)this.tfProxySocksPort, gc);
        this.tfProxySocksPort.setMinimumSize(this.tfProxySocksPort.getPreferredSize());
        gc.gridy = 2;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected final JPanel buildProxySettingsPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        ButtonGroup bgProxyPolicy = new ButtonGroup();
        this.rbProxyPolicy = new HashMap<ProxyPolicy, JRadioButton>();
        ProxyPolicyChangeListener policyChangeListener = new ProxyPolicyChangeListener();
        for (ProxyPolicy pp : ProxyPolicy.values()) {
            this.rbProxyPolicy.put(pp, new JRadioButton());
            bgProxyPolicy.add(this.rbProxyPolicy.get((Object)pp));
            this.rbProxyPolicy.get((Object)pp).addItemListener(policyChangeListener);
        }
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 0.0;
        pnl.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.NO_PROXY), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)new JLabel(I18n.tr("No proxy", new Object[0])), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        pnl.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SYSTEM_SETTINGS), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        String msg = DefaultProxySelector.willJvmRetrieveSystemProxies() ? I18n.tr("Use standard system settings", new Object[0]) : I18n.tr("Use standard system settings (disabled. Start JOSM with <tt>-Djava.net.useSystemProxies=true</tt> to enable)", new Object[0]);
        pnl.add((Component)new JMultilineLabel("<html>" + msg + "</html>"), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 0.0;
        pnl.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.USE_HTTP_PROXY), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)new JLabel(I18n.tr("Manually configure a HTTP proxy", new Object[0])), gc);
        gc.gridx = 1;
        gc.gridy = 3;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.pnlHttpProxyConfigurationPanel = this.buildHttpProxyConfigurationPanel();
        pnl.add((Component)this.pnlHttpProxyConfigurationPanel, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.weightx = 0.0;
        pnl.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SOCKS_PROXY), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)new JLabel(I18n.tr("Use a SOCKS proxy", new Object[0])), gc);
        gc.gridx = 1;
        gc.gridy = 5;
        gc.fill = 1;
        gc.anchor = 17;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.pnlSocksProxyConfigurationPanel = this.buildSocksProxyConfigurationPanel();
        pnl.add((Component)this.pnlSocksProxyConfigurationPanel, gc);
        return pnl;
    }

    public final void initFromPreferences() {
        String policy = Main.pref.get(PROXY_POLICY, null);
        ProxyPolicy pp = ProxyPolicy.fromName(policy);
        if (pp == null) {
            pp = ProxyPolicy.NO_PROXY;
        }
        this.rbProxyPolicy.get((Object)pp).setSelected(true);
        String value = Main.pref.get("proxy.host", null);
        if (value != null) {
            this.tfProxyHttpHost.setText(value);
            Main.pref.put("proxy.host", null);
        } else {
            this.tfProxyHttpHost.setText(Main.pref.get(PROXY_HTTP_HOST, ""));
        }
        value = Main.pref.get("proxy.port", null);
        if (value != null) {
            this.tfProxyHttpPort.setText(value);
            Main.pref.put("proxy.port", null);
        } else {
            this.tfProxyHttpPort.setText(Main.pref.get(PROXY_HTTP_PORT, ""));
        }
        this.tfProxySocksHost.setText(Main.pref.get(PROXY_SOCKS_HOST, ""));
        this.tfProxySocksPort.setText(Main.pref.get(PROXY_SOCKS_PORT, ""));
        if (pp.equals((Object)ProxyPolicy.USE_SYSTEM_SETTINGS) && !DefaultProxySelector.willJvmRetrieveSystemProxies()) {
            Main.warn(I18n.tr("JOSM is configured to use proxies from the system setting, but the JVM is not configured to retrieve them. Resetting preferences to ''No proxy''", new Object[0]));
            pp = ProxyPolicy.NO_PROXY;
            this.rbProxyPolicy.get((Object)pp).setSelected(true);
        }
        CredentialsManager cm = CredentialsManager.getInstance();
        try {
            PasswordAuthentication pa = cm.lookup(Authenticator.RequestorType.PROXY, this.tfProxyHttpHost.getText());
            if (pa == null) {
                this.tfProxyHttpUser.setText("");
                this.tfProxyHttpPassword.setText("");
            } else {
                this.tfProxyHttpUser.setText(pa.getUserName() == null ? "" : pa.getUserName());
                this.tfProxyHttpPassword.setText(pa.getPassword() == null ? "" : String.valueOf(pa.getPassword()));
            }
        }
        catch (CredentialsAgentException e) {
            Main.error(e);
            this.tfProxyHttpUser.setText("");
            this.tfProxyHttpPassword.setText("");
        }
    }

    protected final void updateEnabledState() {
        boolean isHttpProxy = this.rbProxyPolicy.get((Object)ProxyPolicy.USE_HTTP_PROXY).isSelected();
        for (Component c : this.pnlHttpProxyConfigurationPanel.getComponents()) {
            c.setEnabled(isHttpProxy);
        }
        boolean isSocksProxy = this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SOCKS_PROXY).isSelected();
        for (Component c : this.pnlSocksProxyConfigurationPanel.getComponents()) {
            c.setEnabled(isSocksProxy);
        }
        this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SYSTEM_SETTINGS).setEnabled(DefaultProxySelector.willJvmRetrieveSystemProxies());
    }

    public ProxyPreferencesPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.buildProxySettingsPanel(), GBC.eop().anchor(18).fill(1));
        this.initFromPreferences();
        this.updateEnabledState();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#ProxySettings"));
    }

    public void saveToPreferences() {
        ProxyPolicy policy = null;
        for (ProxyPolicy pp : ProxyPolicy.values()) {
            if (!this.rbProxyPolicy.get((Object)pp).isSelected()) continue;
            policy = pp;
            break;
        }
        if (policy == null) {
            policy = ProxyPolicy.NO_PROXY;
        }
        Main.pref.put(PROXY_POLICY, policy.getName());
        Main.pref.put(PROXY_HTTP_HOST, this.tfProxyHttpHost.getText());
        Main.pref.put(PROXY_HTTP_PORT, this.tfProxyHttpPort.getText());
        Main.pref.put(PROXY_SOCKS_HOST, this.tfProxySocksHost.getText());
        Main.pref.put(PROXY_SOCKS_PORT, this.tfProxySocksPort.getText());
        ProxySelector selector = ProxySelector.getDefault();
        if (selector instanceof DefaultProxySelector) {
            ((DefaultProxySelector)selector).initFromPreferences();
        }
        CredentialsManager cm = CredentialsManager.getInstance();
        try {
            PasswordAuthentication pa = new PasswordAuthentication(this.tfProxyHttpUser.getText().trim(), this.tfProxyHttpPassword.getPassword());
            cm.store(Authenticator.RequestorType.PROXY, this.tfProxyHttpHost.getText(), pa);
        }
        catch (CredentialsAgentException e) {
            Main.error(e);
        }
    }

    class ProxyPolicyChangeListener
    implements ItemListener {
        ProxyPolicyChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            ProxyPreferencesPanel.this.updateEnabledState();
        }
    }

    public static enum ProxyPolicy {
        NO_PROXY("no-proxy"),
        USE_SYSTEM_SETTINGS("use-system-settings"),
        USE_HTTP_PROXY("use-http-proxy"),
        USE_SOCKS_PROXY("use-socks-proxy");

        private String policyName;

        private ProxyPolicy(String policyName) {
            this.policyName = policyName;
        }

        public String getName() {
            return this.policyName;
        }

        public static ProxyPolicy fromName(String policyName) {
            if (policyName == null) {
                return null;
            }
            policyName = policyName.trim().toLowerCase();
            for (ProxyPolicy pp : ProxyPolicy.values()) {
                if (!pp.getName().equals(policyName)) continue;
                return pp;
            }
            return null;
        }
    }
}

