/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.server.ApiUrlTestTask;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class OsmApiUrlInputPanel
extends JPanel {
    public static final String API_URL_PROP = OsmApiUrlInputPanel.class.getName() + ".apiUrl";
    private JLabel lblValid;
    private JLabel lblApiUrl;
    private JosmTextField tfOsmServerUrl;
    private ApiUrlValidator valOsmServerUrl;
    private SideButton btnTest;
    private JCheckBox cbUseDefaultServerUrl;
    private ApiUrlPropagator propagator;

    protected JComponent buildDefaultServerUrlPanel() {
        this.cbUseDefaultServerUrl = new JCheckBox(I18n.tr("<html>Use the default OSM server URL (<strong>{0}</strong>)</html>", "https://api.openstreetmap.org/api"));
        this.cbUseDefaultServerUrl.addItemListener(new UseDefaultServerUrlChangeHandler());
        this.cbUseDefaultServerUrl.setFont(this.cbUseDefaultServerUrl.getFont().deriveFont(0));
        return this.cbUseDefaultServerUrl;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 0, 0, 0);
        gc.gridwidth = 4;
        this.add((Component)this.buildDefaultServerUrlPanel(), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        this.lblApiUrl = new JLabel(I18n.tr("OSM Server URL:", new Object[0]));
        this.add((Component)this.lblApiUrl, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfOsmServerUrl = new JosmTextField();
        this.add((Component)this.tfOsmServerUrl, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmServerUrl);
        this.valOsmServerUrl = new ApiUrlValidator(this.tfOsmServerUrl);
        this.valOsmServerUrl.validate();
        this.propagator = new ApiUrlPropagator();
        this.tfOsmServerUrl.addActionListener(this.propagator);
        this.tfOsmServerUrl.addFocusListener(this.propagator);
        gc.gridx = 2;
        gc.weightx = 0.0;
        this.lblValid = new JLabel();
        this.add((Component)this.lblValid, gc);
        gc.gridx = 3;
        gc.weightx = 0.0;
        ValidateApiUrlAction actTest = new ValidateApiUrlAction();
        this.tfOsmServerUrl.getDocument().addDocumentListener(actTest);
        this.btnTest = new SideButton(actTest);
        this.add((Component)this.btnTest, gc);
    }

    public OsmApiUrlInputPanel() {
        this.build();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#ApiUrl"));
    }

    public void initFromPreferences() {
        String url = Main.pref.get("osm-server.url", "https://api.openstreetmap.org/api");
        if (url.trim().equals("https://api.openstreetmap.org/api")) {
            this.cbUseDefaultServerUrl.setSelected(true);
            this.propagator.propagate("https://api.openstreetmap.org/api");
        } else {
            this.cbUseDefaultServerUrl.setSelected(false);
            this.tfOsmServerUrl.setText(url);
            this.propagator.propagate(url);
        }
    }

    public void saveToPreferences() {
        String oldUrl = Main.pref.get("osm-server.url", "https://api.openstreetmap.org/api");
        String hmiUrl = this.getStrippedApiUrl();
        if (this.cbUseDefaultServerUrl.isSelected()) {
            Main.pref.put("osm-server.url", null);
        } else if (hmiUrl.equals("https://api.openstreetmap.org/api")) {
            Main.pref.put("osm-server.url", null);
        } else {
            Main.pref.put("osm-server.url", hmiUrl);
        }
        String newUrl = Main.pref.get("osm-server.url", "https://api.openstreetmap.org/api");
        if (!oldUrl.equals(newUrl)) {
            try {
                OsmApi.getOsmApi().initialize(null);
            }
            catch (Exception x) {
                Main.warn(x);
            }
        }
    }

    public final String getStrippedApiUrl() {
        return Utils.strip(this.tfOsmServerUrl.getText());
    }

    public void setApiUrlInputEnabled(boolean enabled) {
        this.lblApiUrl.setEnabled(enabled);
        this.tfOsmServerUrl.setEnabled(enabled);
        this.lblValid.setEnabled(enabled);
        this.btnTest.setEnabled(enabled);
    }

    class ApiUrlPropagator
    extends FocusAdapter
    implements ActionListener {
        ApiUrlPropagator() {
        }

        public void propagate() {
            this.propagate(OsmApiUrlInputPanel.this.getStrippedApiUrl());
        }

        public void propagate(String url) {
            OsmApiUrlInputPanel.this.firePropertyChange(API_URL_PROP, null, url);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.propagate();
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            this.propagate();
        }
    }

    class UseDefaultServerUrlChangeHandler
    implements ItemListener {
        UseDefaultServerUrlChangeHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    OsmApiUrlInputPanel.this.setApiUrlInputEnabled(false);
                    OsmApiUrlInputPanel.this.propagator.propagate("https://api.openstreetmap.org/api");
                    break;
                }
                case 2: {
                    OsmApiUrlInputPanel.this.setApiUrlInputEnabled(true);
                    OsmApiUrlInputPanel.this.valOsmServerUrl.validate();
                    OsmApiUrlInputPanel.this.tfOsmServerUrl.requestFocusInWindow();
                    OsmApiUrlInputPanel.this.propagator.propagate();
                }
            }
        }
    }

    private static class ApiUrlValidator
    extends AbstractTextComponentValidator {
        public ApiUrlValidator(JTextComponent tc) throws IllegalArgumentException {
            super(tc);
        }

        @Override
        public boolean isValid() {
            if (this.getComponent().getText().trim().isEmpty()) {
                return false;
            }
            try {
                new URL(this.getComponent().getText().trim());
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }

        @Override
        public void validate() {
            if (this.getComponent().getText().trim().isEmpty()) {
                this.feedbackInvalid(I18n.tr("OSM API URL must not be empty. Please enter the OSM API URL.", new Object[0]));
                return;
            }
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid URL", new Object[0]));
            } else {
                this.feedbackValid(I18n.tr("Please enter the OSM API URL.", new Object[0]));
            }
        }
    }

    class ValidateApiUrlAction
    extends AbstractAction
    implements DocumentListener {
        private String lastTestedUrl = null;

        public ValidateApiUrlAction() {
            this.putValue("Name", I18n.tr("Validate", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Test the API URL", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            final String url = OsmApiUrlInputPanel.this.getStrippedApiUrl();
            final ApiUrlTestTask task = new ApiUrlTestTask(OsmApiUrlInputPanel.this, url);
            Main.worker.submit(task);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (task.isCanceled()) {
                        return;
                    }
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            if (task.isSuccess()) {
                                OsmApiUrlInputPanel.this.lblValid.setIcon(ImageProvider.get("dialogs", "valid"));
                                OsmApiUrlInputPanel.this.lblValid.setToolTipText(I18n.tr("The API URL is valid.", new Object[0]));
                                ValidateApiUrlAction.this.lastTestedUrl = url;
                                ValidateApiUrlAction.this.updateEnabledState();
                            } else {
                                OsmApiUrlInputPanel.this.lblValid.setIcon(ImageProvider.get("warning-small"));
                                OsmApiUrlInputPanel.this.lblValid.setToolTipText(I18n.tr("Validation failed. The API URL seems to be invalid.", new Object[0]));
                            }
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
            };
            Main.worker.submit(r);
        }

        protected final void updateEnabledState() {
            boolean enabled;
            String url = OsmApiUrlInputPanel.this.getStrippedApiUrl();
            boolean bl = enabled = !url.isEmpty() && !url.equals(this.lastTestedUrl);
            if (enabled) {
                OsmApiUrlInputPanel.this.lblValid.setIcon(null);
            }
            this.setEnabled(enabled);
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }
    }
}

