/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.MessageNotifier;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class MessagesNotifierPanel
extends JPanel {
    private JCheckBox notifier;
    private JLabel intervalLabel;
    private final JosmTextField notifierInterval = new JosmTextField(4);

    public MessagesNotifierPanel() {
        this.build();
        this.initFromPreferences();
        this.updateEnabledState();
    }

    private void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.notifier = new JCheckBox(I18n.tr("Periodically check for new messages", new Object[0]));
        this.add((Component)this.notifier, GBC.eol());
        this.notifier.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MessagesNotifierPanel.this.updateEnabledState();
            }
        });
        this.intervalLabel = new JLabel(I18n.tr("Check interval (minutes):", new Object[0]));
        this.add((Component)this.intervalLabel, GBC.std().insets(25, 0, 0, 0));
        this.notifierInterval.setToolTipText(I18n.tr("Default value: {0}", MessageNotifier.PROP_INTERVAL.getDefaultValue()));
        this.notifierInterval.setMinimumSize(this.notifierInterval.getPreferredSize());
        this.add((Component)this.notifierInterval, GBC.eol().insets(5, 0, 0, 0));
    }

    private void updateEnabledState() {
        boolean enabled = this.notifier.isSelected();
        this.intervalLabel.setEnabled(enabled);
        this.notifierInterval.setEnabled(enabled);
        this.notifierInterval.setEditable(enabled);
    }

    public final void initFromPreferences() {
        this.notifier.setSelected(MessageNotifier.PROP_NOTIFIER_ENABLED.get());
        this.notifierInterval.setText(Integer.toString(MessageNotifier.PROP_INTERVAL.get()));
    }

    public void saveToPreferences() {
        boolean enabled = this.notifier.isSelected();
        boolean changed = MessageNotifier.PROP_NOTIFIER_ENABLED.put(enabled);
        if (changed |= MessageNotifier.PROP_INTERVAL.parseAndPut(this.notifierInterval.getText())) {
            MessageNotifier.stop();
            if (enabled) {
                MessageNotifier.start();
            }
        } else if (!MessageNotifier.isUserEnoughIdentified()) {
            MessageNotifier.stop();
        } else if (enabled && !MessageNotifier.isRunning()) {
            MessageNotifier.start();
        }
    }
}

