/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.remotecontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.io.remotecontrol.RemoteControlHttpsServer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookWindows;

public final class RemoteControlPreference
extends DefaultTabPreferenceSetting {
    private final Map<PermissionPrefWithDefault, JCheckBox> prefs = new LinkedHashMap<PermissionPrefWithDefault, JCheckBox>();
    private JCheckBox enableRemoteControl;
    private JCheckBox enableHttpsSupport;
    private JButton installCertificate;
    private JButton uninstallCertificate;
    private final JCheckBox loadInNewLayer = new JCheckBox(I18n.tr("Download objects to new layer", new Object[0]));
    private final JCheckBox alwaysAskUserConfirm = new JCheckBox(I18n.tr("Confirm all Remote Control actions manually", new Object[0]));

    private RemoteControlPreference() {
        super("remotecontrol", I18n.tr("Remote Control", new Object[0]), I18n.tr("Settings for the remote control feature.", new Object[0]));
        for (PermissionPrefWithDefault p : PermissionPrefWithDefault.getPermissionPrefs()) {
            JCheckBox cb = new JCheckBox(p.preferenceText);
            cb.setSelected(p.isAllowed());
            this.prefs.put(p, cb);
        }
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        JPanel remote = new JPanel(new GridBagLayout());
        JLabel descLabel = new JLabel("<html>" + I18n.tr("Allows JOSM to be controlled from other applications, e.g. from a web browser.", new Object[0]) + "</html>");
        descLabel.setFont(descLabel.getFont().deriveFont(0));
        remote.add((Component)descLabel, GBC.eol().insets(5, 5, 0, 10).fill(2));
        JLabel portLabel = new JLabel("<html>" + I18n.tr("JOSM will always listen at <b>port {0}</b> (http) and <b>port {1}</b> (https) on localhost.<br>These ports are not configurable because they are referenced by external applications talking to JOSM.", Main.pref.get("remote.control.port", "8111"), Main.pref.get("remote.control.https.port", "8112")) + "</html>");
        portLabel.setFont(portLabel.getFont().deriveFont(0));
        remote.add((Component)portLabel, GBC.eol().insets(5, 5, 0, 10).fill(2));
        this.enableRemoteControl = new JCheckBox(I18n.tr("Enable remote control", new Object[0]), (boolean)RemoteControl.PROP_REMOTECONTROL_ENABLED.get());
        remote.add((Component)this.enableRemoteControl, GBC.eol());
        final JPanel wrapper = new JPanel();
        wrapper.setLayout(new GridBagLayout());
        wrapper.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray)));
        remote.add((Component)wrapper, GBC.eol().fill(2).insets(5, 5, 5, 5));
        boolean https = RemoteControl.PROP_REMOTECONTROL_HTTPS_ENABLED.get();
        this.enableHttpsSupport = new JCheckBox(I18n.tr("Enable HTTPS support", new Object[0]), https);
        wrapper.add((Component)this.enableHttpsSupport, GBC.eol().fill(2));
        if (Main.isPlatformWindows()) {
            this.installCertificate = new JButton(I18n.tr("Install...", new Object[0]));
            this.uninstallCertificate = new JButton(I18n.tr("Uninstall...", new Object[0]));
            this.installCertificate.setToolTipText(I18n.tr("Install JOSM localhost certificate to system/browser root keystores", new Object[0]));
            this.uninstallCertificate.setToolTipText(I18n.tr("Uninstall JOSM localhost certificate from system/browser root keystores", new Object[0]));
            wrapper.add((Component)new JLabel(I18n.tr("Certificate:", new Object[0])), GBC.std().insets(15, 5, 0, 0));
            wrapper.add((Component)this.installCertificate, GBC.std().insets(5, 5, 0, 0));
            wrapper.add((Component)this.uninstallCertificate, GBC.eol().insets(5, 5, 0, 0));
            this.enableHttpsSupport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemoteControlPreference.this.installCertificate.setEnabled(RemoteControlPreference.this.enableHttpsSupport.isSelected());
                }
            });
            this.installCertificate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        boolean changed = RemoteControlHttpsServer.setupPlatform(RemoteControlHttpsServer.loadJosmKeystore());
                        String msg = changed ? I18n.tr("Certificate has been successfully installed.", new Object[0]) : I18n.tr("Certificate is already installed. Nothing to do.", new Object[0]);
                        Main.info(msg);
                        JOptionPane.showMessageDialog(wrapper, msg);
                    }
                    catch (IOException | GeneralSecurityException ex) {
                        Main.error(ex);
                    }
                }
            });
            this.uninstallCertificate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String msg;
                        KeyStore ks = PlatformHookWindows.getRootKeystore();
                        if (ks.containsAlias("josm_localhost")) {
                            Main.info(I18n.tr("Removing certificate {0} from root keystore.", "josm_localhost"));
                            ks.deleteEntry("josm_localhost");
                            msg = I18n.tr("Certificate has been successfully uninstalled.", new Object[0]);
                        } else {
                            msg = I18n.tr("Certificate is not installed. Nothing to do.", new Object[0]);
                        }
                        Main.info(msg);
                        JOptionPane.showMessageDialog(wrapper, msg);
                    }
                    catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                        Main.error(ex);
                    }
                }
            });
            this.installCertificate.setEnabled(https);
        }
        wrapper.add((Component)new JSeparator(), GBC.eop().fill(2).insets(15, 5, 15, 5));
        wrapper.add((Component)new JLabel(I18n.tr("Permitted actions:", new Object[0])), GBC.eol().insets(5, 0, 0, 0));
        for (JCheckBox p : this.prefs.values()) {
            wrapper.add((Component)p, GBC.eol().insets(15, 5, 0, 0).fill(2));
        }
        wrapper.add((Component)new JSeparator(), GBC.eop().fill(2).insets(15, 5, 15, 5));
        wrapper.add((Component)this.loadInNewLayer, GBC.eol().fill(2));
        wrapper.add((Component)this.alwaysAskUserConfirm, GBC.eol().fill(2));
        remote.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.loadInNewLayer.setSelected(Main.pref.getBoolean("remotecontrol.new-layer", false));
        this.alwaysAskUserConfirm.setSelected(Main.pref.getBoolean("remotecontrol.always-confirm", false));
        ActionListener remoteControlEnabled = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiHelper.setEnabledRec(wrapper, RemoteControlPreference.this.enableRemoteControl.isSelected());
                if (RemoteControlPreference.this.installCertificate != null && RemoteControlPreference.this.uninstallCertificate != null) {
                    RemoteControlPreference.this.installCertificate.setEnabled(RemoteControlPreference.this.enableRemoteControl.isSelected() && RemoteControlPreference.this.enableHttpsSupport.isSelected());
                    RemoteControlPreference.this.uninstallCertificate.setEnabled(true);
                }
            }
        };
        this.enableRemoteControl.addActionListener(remoteControlEnabled);
        remoteControlEnabled.actionPerformed(null);
        this.createPreferenceTabWithScrollPane(gui, remote);
    }

    @Override
    public boolean ok() {
        boolean enabled = this.enableRemoteControl.isSelected();
        boolean httpsEnabled = this.enableHttpsSupport.isSelected();
        boolean changed = RemoteControl.PROP_REMOTECONTROL_ENABLED.put(enabled);
        boolean httpsChanged = RemoteControl.PROP_REMOTECONTROL_HTTPS_ENABLED.put(httpsEnabled);
        if (enabled) {
            for (Map.Entry<PermissionPrefWithDefault, JCheckBox> p : this.prefs.entrySet()) {
                Main.pref.put(p.getKey().pref, p.getValue().isSelected());
            }
            Main.pref.put("remotecontrol.new-layer", this.loadInNewLayer.isSelected());
            Main.pref.put("remotecontrol.always-confirm", this.alwaysAskUserConfirm.isSelected());
        }
        if (changed) {
            if (enabled) {
                RemoteControl.start();
            } else {
                RemoteControl.stop();
            }
        } else if (httpsChanged) {
            if (httpsEnabled) {
                RemoteControlHttpsServer.restartRemoteControlHttpsServer();
            } else {
                RemoteControlHttpsServer.stopRemoteControlHttpsServer();
            }
        }
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new RemoteControlPreference();
        }
    }
}

