/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.I18n;

public class UTMFranceDOMProjectionChoice
extends ListProjectionChoice {
    private static final String FortMarigotName = I18n.tr("Guadeloupe Fort-Marigot 1949", new Object[0]);
    private static final String SainteAnneName = I18n.tr("Guadeloupe Ste-Anne 1948", new Object[0]);
    private static final String MartiniqueName = I18n.tr("Martinique Fort Desaix 1952", new Object[0]);
    private static final String Reunion92Name = I18n.tr("Reunion RGR92", new Object[0]);
    private static final String Guyane92Name = I18n.tr("Guyane RGFG95", new Object[0]);
    private static final String[] utmGeodesicsNames = new String[]{FortMarigotName, SainteAnneName, MartiniqueName, Reunion92Name, Guyane92Name};
    private static final Integer FortMarigotEPSG = 2969;
    private static final Integer SainteAnneEPSG = 2970;
    private static final Integer MartiniqueEPSG = 2973;
    private static final Integer ReunionEPSG = 2975;
    private static final Integer GuyaneEPSG = 2972;
    private static final Integer[] utmEPSGs = new Integer[]{FortMarigotEPSG, SainteAnneEPSG, MartiniqueEPSG, ReunionEPSG, GuyaneEPSG};

    public UTMFranceDOMProjectionChoice() {
        super(I18n.tr("UTM France (DOM)", new Object[0]), "core:utmfrancedom", utmGeodesicsNames, I18n.tr("UTM Geodesic system", new Object[0]));
    }

    @Override
    protected String indexToZone(int index) {
        return Integer.toString(index + 1);
    }

    @Override
    protected int zoneToIndex(String zone) {
        try {
            return Integer.parseInt(zone) - 1;
        }
        catch (NumberFormatException e) {
            Main.warn(e);
            return this.defaultIndex;
        }
    }

    @Override
    public String getProjectionName() {
        return utmGeodesicsNames[this.index];
    }

    @Override
    public String getCurrentCode() {
        return "EPSG:" + utmEPSGs[this.index];
    }

    @Override
    public String[] allCodes() {
        String[] res = new String[utmEPSGs.length];
        for (int i = 0; i < utmEPSGs.length; ++i) {
            res[i] = "EPSG:" + utmEPSGs[i];
        }
        return res;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        for (int i = 0; i < utmEPSGs.length; ++i) {
            if (!("EPSG:" + utmEPSGs[i]).equals(code)) continue;
            return Collections.singleton(Integer.toString(i + 1));
        }
        return null;
    }
}

