/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.projection.CodeProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.CustomProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.GaussKruegerProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.LambertCC9ZonesProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.LambertProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.PuwgProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SingleProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SubPrefsOptions;
import org.openstreetmap.josm.gui.preferences.projection.SwissGridProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.UTMFranceDOMProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.UTMProjectionChoice;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ProjectionPreference
implements SubPreferenceSetting {
    private static List<ProjectionChoice> projectionChoices = new ArrayList<ProjectionChoice>();
    private static Map<String, ProjectionChoice> projectionChoicesById = new HashMap<String, ProjectionChoice>();
    public static final ProjectionChoice wgs84 = ProjectionPreference.registerProjectionChoice(I18n.tr("WGS84 Geographic", new Object[0]), "core:wgs84", 4326, "epsg4326");
    public static final ProjectionChoice mercator = ProjectionPreference.registerProjectionChoice(I18n.tr("Mercator", new Object[0]), "core:mercator", 3857);
    public static final ProjectionChoice lambert;
    public static final ProjectionChoice utm_france_dom;
    public static final ProjectionChoice lambert_cc9;
    private static final StringProperty PROP_PROJECTION;
    private static final StringProperty PROP_COORDINATES;
    private static final CollectionProperty PROP_SUB_PROJECTION;
    public static final StringProperty PROP_SYSTEM_OF_MEASUREMENT;
    private static final String[] unitsValues;
    private static final String[] unitsValuesTr;
    private final JosmComboBox<ProjectionChoice> projectionCombo = new JosmComboBox<ProjectionChoice>(projectionChoices.toArray(new ProjectionChoice[0]));
    private final JosmComboBox<CoordinateFormat> coordinatesCombo = new JosmComboBox<CoordinateFormat>(CoordinateFormat.values());
    private final JosmComboBox<String> unitsCombo = new JosmComboBox<String>(unitsValuesTr);
    private JPanel projSubPrefPanel;
    private JPanel projSubPrefPanelWrapper = new JPanel(new GridBagLayout());
    private JLabel projectionCodeLabel;
    private Component projectionCodeGlue;
    private JLabel projectionCode = new JLabel();
    private JLabel projectionNameLabel;
    private Component projectionNameGlue;
    private JLabel projectionName = new JLabel();
    private JLabel bounds = new JLabel();
    private final JPanel projPanel = new JPanel(new GridBagLayout());
    private static final GBC projSubPrefPanelGBC;

    public static void registerProjectionChoice(ProjectionChoice c) {
        projectionChoices.add(c);
        projectionChoicesById.put(c.getId(), c);
    }

    public static ProjectionChoice registerProjectionChoice(String name, String id, Integer epsg, String cacheDir) {
        SingleProjectionChoice pc = new SingleProjectionChoice(name, id, "EPSG:" + epsg, cacheDir);
        ProjectionPreference.registerProjectionChoice(pc);
        return pc;
    }

    private static ProjectionChoice registerProjectionChoice(String name, String id, Integer epsg) {
        SingleProjectionChoice pc = new SingleProjectionChoice(name, id, "EPSG:" + epsg);
        ProjectionPreference.registerProjectionChoice(pc);
        return pc;
    }

    public static List<ProjectionChoice> getProjectionChoices() {
        return Collections.unmodifiableList(projectionChoices);
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        int i;
        ProjectionChoice pc = this.setupProjectionCombo();
        for (i = 0; i < this.coordinatesCombo.getItemCount(); ++i) {
            if (!((CoordinateFormat)((Object)this.coordinatesCombo.getItemAt(i))).name().equals(PROP_COORDINATES.get())) continue;
            this.coordinatesCombo.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < unitsValues.length; ++i) {
            if (!unitsValues[i].equals(PROP_SYSTEM_OF_MEASUREMENT.get())) continue;
            this.unitsCombo.setSelectedIndex(i);
            break;
        }
        this.projPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projPanel.setLayout(new GridBagLayout());
        this.projPanel.add((Component)new JLabel(I18n.tr("Projection method", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add(this.projectionCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projectionCodeLabel = new JLabel(I18n.tr("Projection code", new Object[0]));
        this.projPanel.add((Component)this.projectionCodeLabel, GBC.std().insets(25, 5, 0, 5));
        this.projectionCodeGlue = GBC.glue(5, 0);
        this.projPanel.add(this.projectionCodeGlue, GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCode, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projectionNameLabel = new JLabel(I18n.tr("Projection name", new Object[0]));
        this.projPanel.add((Component)this.projectionNameLabel, GBC.std().insets(25, 5, 0, 5));
        this.projectionNameGlue = GBC.glue(5, 0);
        this.projPanel.add(this.projectionNameGlue, GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionName, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Bounds", new Object[0])), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.bounds, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projSubPrefPanelWrapper, GBC.eol().fill(2).insets(20, 5, 5, 5));
        this.projPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 10));
        this.projPanel.add((Component)new JLabel(I18n.tr("Display coordinates as", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add(this.coordinatesCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("System of measurement", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add(this.unitsCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add(GBC.glue(1, 1), GBC.std().fill(2).weight(1.0, 1.0));
        JScrollPane scrollpane = new JScrollPane(this.projPanel);
        gui.getMapPreference().addSubTab(this, I18n.tr("Map Projection", new Object[0]), scrollpane);
        this.selectedProjectionChanged(pc);
    }

    private void updateMeta(ProjectionChoice pc) {
        pc.setPreferences(pc.getPreferences(this.projSubPrefPanel));
        Projection proj = pc.getProjection();
        this.projectionCode.setText(proj.toCode());
        this.projectionName.setText(proj.toString());
        Bounds b = proj.getWorldBoundsLatLon();
        CoordinateFormat cf = CoordinateFormat.getDefaultFormat();
        this.bounds.setText(b.getMin().lonToString(cf) + ", " + b.getMin().latToString(cf) + " : " + b.getMax().lonToString(cf) + ", " + b.getMax().latToString(cf));
        boolean showCode = true;
        boolean showName = false;
        if (pc instanceof SubPrefsOptions) {
            showCode = ((SubPrefsOptions)((Object)pc)).showProjectionCode();
            showName = ((SubPrefsOptions)((Object)pc)).showProjectionName();
        }
        this.projectionCodeLabel.setVisible(showCode);
        this.projectionCodeGlue.setVisible(showCode);
        this.projectionCode.setVisible(showCode);
        this.projectionNameLabel.setVisible(showName);
        this.projectionNameGlue.setVisible(showName);
        this.projectionName.setVisible(showName);
    }

    @Override
    public boolean ok() {
        ProjectionChoice pc = (ProjectionChoice)this.projectionCombo.getSelectedItem();
        String id = pc.getId();
        Collection<String> prefs = pc.getPreferences(this.projSubPrefPanel);
        ProjectionPreference.setProjection(id, prefs);
        if (PROP_COORDINATES.put(((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem())).name())) {
            CoordinateFormat.setCoordinateFormat((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem()));
        }
        int i = this.unitsCombo.getSelectedIndex();
        NavigatableComponent.setSystemOfMeasurement(unitsValues[i]);
        return false;
    }

    public static void setProjection() {
        ProjectionPreference.setProjection(PROP_PROJECTION.get(), (Collection<String>)PROP_SUB_PROJECTION.get());
    }

    public static void setProjection(String id, Collection<String> pref2) {
        ProjectionChoice pc = projectionChoicesById.get(id);
        if (pc == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The projection {0} could not be activated. Using Mercator", id), I18n.tr("Error", new Object[0]), 0);
            pref2 = null;
            pc = mercator;
        }
        id = pc.getId();
        PROP_PROJECTION.put(id);
        PROP_SUB_PROJECTION.put(pref2);
        Main.pref.putCollection("projection.sub." + id, pref2);
        pc.setPreferences(pref2);
        Projection proj = pc.getProjection();
        Main.setProjection(proj);
    }

    private void selectedProjectionChanged(final ProjectionChoice pc) {
        int size = this.projPanel.getComponentCount();
        if (size < 1) {
            return;
        }
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectionPreference.this.updateMeta(pc);
            }
        };
        this.projSubPrefPanelWrapper.removeAll();
        this.projSubPrefPanel = pc.getPreferencePanel(listener);
        this.projSubPrefPanelWrapper.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        this.projPanel.revalidate();
        this.projSubPrefPanel.repaint();
        this.updateMeta(pc);
    }

    private ProjectionChoice setupProjectionCombo() {
        ProjectionChoice pc = null;
        for (int i = 0; i < this.projectionCombo.getItemCount(); ++i) {
            ProjectionChoice pc1 = (ProjectionChoice)this.projectionCombo.getItemAt(i);
            pc1.setPreferences(this.getSubprojectionPreference(pc1));
            if (!pc1.getId().equals(PROP_PROJECTION.get())) continue;
            this.projectionCombo.setSelectedIndex(i);
            this.selectedProjectionChanged(pc1);
            pc = pc1;
        }
        if (pc == null) {
            throw new RuntimeException("Couldn't find the current projection in the list of available projections!");
        }
        this.projectionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectionChoice pc = (ProjectionChoice)ProjectionPreference.this.projectionCombo.getSelectedItem();
                ProjectionPreference.this.selectedProjectionChanged(pc);
            }
        });
        return pc;
    }

    private Collection<String> getSubprojectionPreference(ProjectionChoice pc) {
        return Main.pref.getCollection("projection.sub." + pc.getId(), null);
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getMapPreference();
    }

    public void selectProjection(ProjectionChoice projection) {
        if (this.projectionCombo != null && projection != null) {
            this.projectionCombo.setSelectedItem(projection);
        }
    }

    static {
        ProjectionPreference.registerProjectionChoice(new UTMProjectionChoice());
        ProjectionPreference.registerProjectionChoice(I18n.tr("Belgian Lambert 1972", new Object[0]), "core:belgianLambert1972", 31370);
        ProjectionPreference.registerProjectionChoice(I18n.tr("Belgian Lambert 2008", new Object[0]), "core:belgianLambert2008", 3812);
        ProjectionPreference.registerProjectionChoice(new SwissGridProjectionChoice());
        ProjectionPreference.registerProjectionChoice(new GaussKruegerProjectionChoice());
        ProjectionPreference.registerProjectionChoice(I18n.tr("Lambert Zone (Estonia)", new Object[0]), "core:lambertest", 3301);
        lambert = new LambertProjectionChoice();
        ProjectionPreference.registerProjectionChoice(lambert);
        ProjectionPreference.registerProjectionChoice(I18n.tr("Lambert 93 (France)", new Object[0]), "core:lambert93", 2154);
        lambert_cc9 = new LambertCC9ZonesProjectionChoice();
        ProjectionPreference.registerProjectionChoice(lambert_cc9);
        utm_france_dom = new UTMFranceDOMProjectionChoice();
        ProjectionPreference.registerProjectionChoice(utm_france_dom);
        ProjectionPreference.registerProjectionChoice(I18n.tr("LKS-92 (Latvia TM)", new Object[0]), "core:tmerclv", 3059);
        ProjectionPreference.registerProjectionChoice(new PuwgProjectionChoice());
        ProjectionPreference.registerProjectionChoice(I18n.tr("SWEREF99 13 30 / EPSG:3008 (Sweden)", new Object[0]), "core:sweref99", 3008);
        ProjectionPreference.registerProjectionChoice(new CodeProjectionChoice());
        ProjectionPreference.registerProjectionChoice(new CustomProjectionChoice());
        PROP_PROJECTION = new StringProperty("projection", mercator.getId());
        PROP_COORDINATES = new StringProperty("coordinates", null);
        PROP_SUB_PROJECTION = new CollectionProperty("projection.sub", null);
        PROP_SYSTEM_OF_MEASUREMENT = new StringProperty("system_of_measurement", "Metric");
        unitsValues = new ArrayList<String>(SystemOfMeasurement.ALL_SYSTEMS.keySet()).toArray(new String[0]);
        unitsValuesTr = new String[unitsValues.length];
        for (int i = 0; i < unitsValues.length; ++i) {
            ProjectionPreference.unitsValuesTr[i] = I18n.tr(unitsValues[i], new Object[0]);
        }
        projSubPrefPanelGBC = GBC.std().fill(1).weight(1.0, 1.0);
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ProjectionPreference();
        }
    }
}

