/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.preferences.projection.AbstractProjectionChoice;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.Utils;

public abstract class ListProjectionChoice
extends AbstractProjectionChoice {
    protected int index;
    protected int defaultIndex;
    protected String[] entries;
    protected String label;

    public ListProjectionChoice(String name, String id, String[] entries, String label, int defaultIndex) {
        super(name, id);
        this.entries = Utils.copyArray(entries);
        this.label = label;
        this.defaultIndex = defaultIndex;
    }

    public ListProjectionChoice(String name, String id, String[] entries, String label) {
        this(name, id, entries, label, 0);
    }

    protected abstract String indexToZone(int var1);

    protected abstract int zoneToIndex(String var1);

    @Override
    public void setPreferences(Collection<String> args) {
        int idx;
        String zone = null;
        if (args != null && args.size() >= 1) {
            zone = args.iterator().next();
        }
        if (zone == null) {
            idx = this.defaultIndex;
        } else {
            idx = this.zoneToIndex(zone);
            if (idx < 0 || idx >= this.entries.length) {
                idx = this.defaultIndex;
            }
        }
        this.index = idx;
    }

    @Override
    public JPanel getPreferencePanel(ActionListener listener) {
        return new CBPanel(this.entries, this.index, this.label, listener);
    }

    @Override
    public Collection<String> getPreferences(JPanel panel) {
        if (!(panel instanceof CBPanel)) {
            throw new IllegalArgumentException("Unsupported panel: " + panel);
        }
        CBPanel p = (CBPanel)panel;
        int idx = p.prefcb.getSelectedIndex();
        return Collections.singleton(this.indexToZone(idx));
    }

    protected class CBPanel
    extends JPanel {
        public JosmComboBox<String> prefcb;

        public CBPanel(String[] entries, int initialIndex, String label, ActionListener listener) {
            this.prefcb = new JosmComboBox<String>(entries);
            this.prefcb.setSelectedIndex(initialIndex);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(label), GBC.std().insets(5, 5, 0, 5));
            this.add(GBC.glue(1, 0), GBC.std().fill(2));
            this.add(this.prefcb, GBC.eop().fill(2));
            this.add(GBC.glue(1, 1), GBC.eol().fill(1));
            if (listener != null) {
                this.prefcb.addActionListener(listener);
            }
        }
    }
}

