/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class LambertProjectionChoice
extends ListProjectionChoice {
    private static final String[] lambert4zones = new String[]{I18n.tr("{0} ({1} to {2} degrees)", 1, "51.30", "48.15"), I18n.tr("{0} ({1} to {2} degrees)", 2, "48.15", "45.45"), I18n.tr("{0} ({1} to {2} degrees)", 3, "45.45", "42.76"), I18n.tr("{0} (Corsica)", 4)};

    public LambertProjectionChoice() {
        super(I18n.tr("Lambert 4 Zones (France)", new Object[0]), "core:lambert", lambert4zones, I18n.tr("Lambert CC Zone", new Object[0]));
    }

    @Override
    public JPanel getPreferencePanel(ActionListener listener) {
        return new LambertCBPanel(this.entries, this.index, this.label, listener);
    }

    @Override
    public String getCurrentCode() {
        return "EPSG:" + Integer.toString(27561 + this.index);
    }

    @Override
    public String getProjectionName() {
        return I18n.tr("Lambert 4 Zones (France)", new Object[0]);
    }

    @Override
    public String[] allCodes() {
        String[] codes = new String[4];
        for (int zone = 0; zone < 4; ++zone) {
            codes[zone] = "EPSG:" + (27561 + zone);
        }
        return codes;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        if (code.startsWith("EPSG:2756") && code.length() == 10) {
            try {
                String zonestring = code.substring(9);
                int zoneval = Integer.parseInt(zonestring);
                if (zoneval >= 1 && zoneval <= 4) {
                    return Collections.singleton(zonestring);
                }
            }
            catch (NumberFormatException e) {
                Main.warn(e);
            }
        }
        return null;
    }

    @Override
    protected String indexToZone(int idx) {
        return Integer.toString(idx + 1);
    }

    @Override
    protected int zoneToIndex(String zone) {
        try {
            return Integer.parseInt(zone) - 1;
        }
        catch (NumberFormatException e) {
            Main.warn(e);
            return this.defaultIndex;
        }
    }

    private class LambertCBPanel
    extends ListProjectionChoice.CBPanel {
        public LambertCBPanel(String[] entries, int initialIndex, String label, ActionListener listener) {
            super(LambertProjectionChoice.this, entries, initialIndex, label, listener);
            this.add((Component)new JLabel(ImageProvider.get("data/projection", "Departements_Lambert4Zones.png")), GBC.eol().fill(2));
            this.add(GBC.glue(1, 1), GBC.eol().fill(1));
        }
    }
}

