/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.I18n;

public class GaussKruegerProjectionChoice
extends ListProjectionChoice {
    private static String[] zones = new String[]{"2", "3", "4", "5"};

    public GaussKruegerProjectionChoice() {
        super(I18n.tr("Gau\u00df-Kr\u00fcger", new Object[0]), "core:gauss-krueger", zones, I18n.tr("GK Zone", new Object[0]));
    }

    @Override
    public String getCurrentCode() {
        return "EPSG:" + Integer.toString(31466 + this.index);
    }

    @Override
    protected String indexToZone(int index) {
        return Integer.toString(index + 2);
    }

    @Override
    protected int zoneToIndex(String zone) {
        try {
            return Integer.parseInt(zone) - 2;
        }
        catch (NumberFormatException e) {
            Main.warn(e);
            return this.defaultIndex;
        }
    }

    @Override
    public String[] allCodes() {
        String[] codes = new String[4];
        for (int zone = 2; zone <= 5; ++zone) {
            codes[zone - 2] = "EPSG:" + (31464 + zone);
        }
        return codes;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        for (int zone = 2; zone <= 5; ++zone) {
            String epsg = "EPSG:" + (31464 + zone);
            if (!epsg.equals(code)) continue;
            return Collections.singleton(String.valueOf(zone));
        }
        return null;
    }

    @Override
    public String getProjectionName() {
        return I18n.tr("Gau\u00df-Kr\u00fcger Zone {0}", this.index + 2);
    }
}

