/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.projection.AbstractProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SubPrefsOptions;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class CustomProjectionChoice
extends AbstractProjectionChoice
implements SubPrefsOptions {
    private String pref;

    public CustomProjectionChoice() {
        super(I18n.tr("Custom Projection", new Object[0]), "core:custom");
    }

    @Override
    public void setPreferences(Collection<String> args) {
        if (args != null && !args.isEmpty()) {
            this.pref = args.iterator().next();
        }
    }

    @Override
    public Projection getProjection() {
        return new CustomProjection(this.pref);
    }

    @Override
    public String getCurrentCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProjectionName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JPanel getPreferencePanel(ActionListener listener) {
        return new PreferencePanel(this.pref, listener);
    }

    @Override
    public Collection<String> getPreferences(JPanel panel) {
        if (!(panel instanceof PreferencePanel)) {
            throw new IllegalArgumentException("Unsupported panel: " + panel);
        }
        PreferencePanel prefPanel = (PreferencePanel)panel;
        String pref2 = prefPanel.input.getText();
        prefPanel.rememberHistory();
        return Collections.singleton(pref2);
    }

    @Override
    public String[] allCodes() {
        return new String[0];
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        return null;
    }

    @Override
    public boolean showProjectionCode() {
        return false;
    }

    @Override
    public boolean showProjectionName() {
        return false;
    }

    public static class ParameterInfoDialog
    extends ExtendedDialog {
        public ParameterInfoDialog() {
            super(null, I18n.tr("Parameter information", new Object[0]), new String[]{I18n.tr("Close", new Object[0])}, false);
            this.setContent(this.build());
        }

        private JComponent build() {
            StringBuilder s = new StringBuilder();
            s.append("<b>+proj=...</b> - <i>" + I18n.tr("Projection name", new Object[0]) + "</i><br>");
            s.append("&nbsp;&nbsp;&nbsp;&nbsp;" + I18n.tr("Supported values:", new Object[0]) + " ");
            s.append(this.listKeys(Projections.projs) + "<br>");
            s.append("<b>+lat_0=..., +lat_1=..., +lat_2=...</b> - <i>" + I18n.tr("Projection parameters", new Object[0]) + "</i><br>");
            s.append("<b>+x_0=..., +y_0=...</b> - <i>" + I18n.tr("False easting and false northing", new Object[0]) + "</i><br>");
            s.append("<b>+lon_0=...</b> - <i>" + I18n.tr("Central meridian", new Object[0]) + "</i><br>");
            s.append("<b>+k_0=...</b> - <i>" + I18n.tr("Scaling factor", new Object[0]) + "</i><br>");
            s.append("<b>+ellps=...</b> - <i>" + I18n.tr("Ellipsoid name", new Object[0]) + "</i><br>");
            s.append("&nbsp;&nbsp;&nbsp;&nbsp;" + I18n.tr("Supported values:", new Object[0]) + " ");
            s.append(this.listKeys(Projections.ellipsoids) + "<br>");
            s.append("<b>+a=..., +b=..., +rf=..., +f=..., +es=...</b> - <i>" + I18n.tr("Ellipsoid parameters", new Object[0]) + "</i><br>");
            s.append("<b>+datum=...</b> - <i>" + I18n.tr("Datum name", new Object[0]) + "</i><br>");
            s.append("&nbsp;&nbsp;&nbsp;&nbsp;" + I18n.tr("Supported values:", new Object[0]) + " ");
            s.append(this.listKeys(Projections.datums) + "<br>");
            s.append("<b>+towgs84=...</b> - <i>" + I18n.tr("3 or 7 term datum transform parameters", new Object[0]) + "</i><br>");
            s.append("<b>+nadgrids=...</b> - <i>" + I18n.tr("NTv2 grid file", new Object[0]) + "</i><br>");
            s.append("&nbsp;&nbsp;&nbsp;&nbsp;" + I18n.tr("Built-in:", new Object[0]) + " ");
            s.append(this.listKeys(Projections.nadgrids) + "<br>");
            s.append("<b>+bounds=</b>minlon,minlat,maxlon,maxlat - <i>" + I18n.tr("Projection bounds (in degrees)", new Object[0]) + "</i><br>");
            s.append("<b>+wmssrs=</b>EPSG:123456 - <i>" + I18n.tr("Sets the SRS=... parameter in the WMS request", new Object[0]) + "</i><br>");
            return new HtmlPanel(s.toString());
        }

        private String listKeys(Map<String, ?> map) {
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            Collections.sort(keys);
            return Utils.join(", ", keys);
        }
    }

    private static class PreferencePanel
    extends JPanel {
        public JosmTextField input;
        private HistoryComboBox cbInput;

        public PreferencePanel(String initialText, ActionListener listener) {
            this.build(initialText, listener);
        }

        private final void build(String initialText, final ActionListener listener) {
            this.input = new JosmTextField(30);
            this.cbInput = new HistoryComboBox();
            this.cbInput.setPrototypeDisplayValue(new AutoCompletionListItem("xxxx"));
            this.cbInput.setEditor(new BasicComboBoxEditor(){

                @Override
                protected JosmTextField createEditorComponent() {
                    return PreferencePanel.this.input;
                }
            });
            List<String> samples = Arrays.asList("+proj=lonlat +ellps=WGS84 +datum=WGS84 +bounds=-180,-90,180,90", "+proj=tmerc +lat_0=0 +lon_0=9 +k_0=1 +x_0=3500000 +y_0=0 +ellps=bessel +nadgrids=BETA2007.gsb");
            LinkedList<String> inputHistory = new LinkedList<String>(Main.pref.getCollection("projection.custom.value.history", samples));
            Collections.reverse(inputHistory);
            this.cbInput.setPossibleItems(inputHistory);
            this.cbInput.setText(initialText == null ? "" : initialText);
            final HtmlPanel errorsPanel = new HtmlPanel();
            errorsPanel.setVisible(false);
            final JLabel valStatus = new JLabel();
            valStatus.setVisible(false);
            final AbstractTextComponentValidator val = new AbstractTextComponentValidator(this.input, false, false, false){
                private String error;

                @Override
                public void validate() {
                    if (!this.isValid()) {
                        this.feedbackInvalid(I18n.tr("Invalid projection configuration: {0}", this.error));
                    } else {
                        this.feedbackValid(I18n.tr("Projection configuration is valid.", new Object[0]));
                    }
                    listener.actionPerformed(null);
                }

                @Override
                public final boolean isValid() {
                    try {
                        CustomProjection test = new CustomProjection();
                        test.update(PreferencePanel.this.input.getText());
                    }
                    catch (ProjectionConfigurationException ex) {
                        this.error = ex.getMessage();
                        valStatus.setIcon(ImageProvider.get("data", "error"));
                        valStatus.setVisible(true);
                        errorsPanel.setText(this.error);
                        errorsPanel.setVisible(true);
                        return false;
                    }
                    errorsPanel.setVisible(false);
                    valStatus.setIcon(ImageProvider.get("misc", "green_check"));
                    valStatus.setVisible(true);
                    return true;
                }
            };
            JButton btnCheck = new JButton(I18n.tr("Validate", new Object[0]));
            btnCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    val.validate();
                }
            });
            btnCheck.setLayout(new BorderLayout());
            btnCheck.setMargin(new Insets(-1, 0, -1, 0));
            JButton btnInfo = new JButton(I18n.tr("Parameter information...", new Object[0]));
            btnInfo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParameterInfoDialog dlg = new ParameterInfoDialog();
                    dlg.showDialog();
                    dlg.toFront();
                }
            });
            this.setLayout(new GridBagLayout());
            JPanel p2 = new JPanel(new GridBagLayout());
            p2.add((Component)this.cbInput, GBC.std().fill(2).insets(0, 20, 5, 5));
            p2.add((Component)btnCheck, GBC.eol().insets(0, 20, 0, 5));
            this.add((Component)p2, GBC.eol().fill(2));
            p2 = new JPanel(new GridBagLayout());
            p2.add((Component)valStatus, GBC.std().anchor(17).weight(1.0E-4, 0.0));
            p2.add((Component)errorsPanel, GBC.eol().fill(2));
            this.add((Component)p2, GBC.eol().fill(2));
            p2 = new JPanel(new GridBagLayout());
            p2.add((Component)btnInfo, GBC.std().insets(0, 20, 0, 0));
            p2.add(GBC.glue(1, 0), GBC.eol().fill(2));
            this.add((Component)p2, GBC.eol().fill(2));
        }

        public void rememberHistory() {
            this.cbInput.addCurrentItemToHistory();
            Main.pref.putCollection("projection.custom.value.history", this.cbInput.getHistory());
        }
    }
}

