/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.plugin.PluginListPanel;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.gui.preferences.plugin.PluginUpdatePolicyPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.plugins.ReadRemotePluginInformationTask;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class PluginPreference
extends DefaultTabPreferenceSetting {
    private JosmTextField tfFilter;
    private PluginListPanel pnlPluginPreferences;
    private PluginPreferencesModel model;
    private JScrollPane spPluginPreferences;
    private PluginUpdatePolicyPanel pnlPluginUpdatePolicy;
    private boolean pluginPreferencesActivated = false;

    private PluginPreference() {
        super("plugin", I18n.tr("Plugins", new Object[0]), I18n.tr("Configure available plugins.", new Object[0]), false, new JTabbedPane());
    }

    public static String buildDownloadSummary(PluginDownloadTask task) {
        Collection<PluginInformation> downloaded = task.getDownloadedPlugins();
        Collection<PluginInformation> failed = task.getFailedPlugins();
        StringBuilder sb = new StringBuilder();
        if (!downloaded.isEmpty()) {
            sb.append(I18n.trn("The following plugin has been downloaded <strong>successfully</strong>:", "The following {0} plugins have been downloaded <strong>successfully</strong>:", downloaded.size(), downloaded.size()));
            sb.append("<ul>");
            for (PluginInformation pi : downloaded) {
                sb.append("<li>").append(pi.name).append(" (").append(pi.version).append(")").append("</li>");
            }
            sb.append("</ul>");
        }
        if (!failed.isEmpty()) {
            sb.append(I18n.trn("Downloading the following plugin has <strong>failed</strong>:", "Downloading the following {0} plugins has <strong>failed</strong>:", failed.size(), failed.size()));
            sb.append("<ul>");
            for (PluginInformation pi : failed) {
                sb.append("<li>").append(pi.name).append("</li>");
            }
            sb.append("</ul>");
        }
        return sb.toString();
    }

    public static void notifyDownloadResults(final Component parent, PluginDownloadTask task, boolean restartRequired) {
        Collection<PluginInformation> downloaded = task.getDownloadedPlugins();
        final Collection<PluginInformation> failed = task.getFailedPlugins();
        final StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(PluginPreference.buildDownloadSummary(task));
        if (restartRequired) {
            sb.append(I18n.tr("Please restart JOSM to activate the downloaded plugins.", new Object[0]));
        }
        sb.append("</html>");
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                HelpAwareOptionPane.showOptionDialog(parent, sb.toString(), I18n.tr("Update plugins", new Object[0]), !failed.isEmpty() ? 2 : 1, HelpUtil.ht("/Preferences/Plugins"));
            }
        });
    }

    protected JPanel buildSearchFieldPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        pnl.add((Component)new JLabel(I18n.tr("Search:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfFilter = new JosmTextField();
        pnl.add((Component)this.tfFilter, gc);
        this.tfFilter.setToolTipText(I18n.tr("Enter a search expression", new Object[0]));
        SelectAllOnFocusGainedDecorator.decorate(this.tfFilter);
        this.tfFilter.getDocument().addDocumentListener(new SearchFieldAdapter());
        return pnl;
    }

    protected JPanel buildActionPanel() {
        JPanel pnl = new JPanel(new GridLayout(1, 3));
        pnl.add(new JButton(new DownloadAvailablePluginsAction()));
        pnl.add(new JButton(new UpdateSelectedPluginsAction()));
        pnl.add(new JButton(new ConfigureSitesAction()));
        return pnl;
    }

    protected JPanel buildPluginListPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.buildSearchFieldPanel(), "North");
        this.model = new PluginPreferencesModel();
        this.pnlPluginPreferences = new PluginListPanel(this.model);
        this.spPluginPreferences = GuiHelper.embedInVerticalScrollPane(this.pnlPluginPreferences);
        this.spPluginPreferences.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                PluginPreference.this.spPluginPreferences.setBorder(UIManager.getBorder("ScrollPane.border"));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                PluginPreference.this.spPluginPreferences.setBorder(null);
            }
        });
        pnl.add((Component)this.spPluginPreferences, "Center");
        pnl.add((Component)this.buildActionPanel(), "South");
        return pnl;
    }

    protected JTabbedPane buildContentPane() {
        JTabbedPane pane = this.getTabPane();
        this.pnlPluginUpdatePolicy = new PluginUpdatePolicyPanel();
        pane.addTab(I18n.tr("Plugins", new Object[0]), this.buildPluginListPanel());
        pane.addTab(I18n.tr("Plugin update policy", new Object[0]), this.pnlPluginUpdatePolicy);
        return pane;
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 18;
        gc.fill = 1;
        PreferenceTabbedPane.PreferencePanel plugins = gui.createPreferenceTab(this);
        plugins.add((Component)this.buildContentPane(), gc);
        this.readLocalPluginInformation();
        this.pluginPreferencesActivated = true;
    }

    private void configureSites() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("OK", new Object[0]), ImageProvider.get("ok"), I18n.tr("Accept the new plugin sites and close the dialog", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Close the dialog", new Object[0]), null)};
        PluginConfigurationSitesPanel pnl = new PluginConfigurationSitesPanel();
        int answer = HelpAwareOptionPane.showOptionDialog(this.pnlPluginPreferences, pnl, I18n.tr("Configure Plugin Sites", new Object[0]), 3, null, options, options[0], null);
        if (answer != 0) {
            return;
        }
        List<String> sites = pnl.getUpdateSites();
        Main.pref.setPluginSites(sites);
    }

    public List<PluginInformation> getPluginsScheduledForUpdateOrDownload() {
        return this.model != null ? this.model.getPluginsScheduledForUpdateOrDownload() : null;
    }

    public List<PluginInformation> getNewlyActivatedPlugins() {
        return this.model != null ? this.model.getNewlyActivatedPlugins() : null;
    }

    @Override
    public boolean ok() {
        if (!this.pluginPreferencesActivated) {
            return false;
        }
        this.pnlPluginUpdatePolicy.rememberInPreferences();
        if (this.model.isActivePluginsChanged()) {
            LinkedList<String> l = new LinkedList<String>(this.model.getSelectedPluginNames());
            Collections.sort(l);
            Main.pref.putCollection("plugins", l);
            if (!this.model.getNewlyDeactivatedPlugins().isEmpty()) {
                return true;
            }
            for (PluginInformation pi : this.model.getNewlyActivatedPlugins()) {
                if (pi.canloadatruntime) continue;
                return true;
            }
        }
        return false;
    }

    public void readLocalPluginInformation() {
        final ReadLocalPluginInformationTask task = new ReadLocalPluginInformationTask();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (task.isCanceled()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PluginPreference.this.model.setAvailablePlugins(task.getAvailablePlugins());
                        PluginPreference.this.pnlPluginPreferences.refreshView();
                    }
                });
            }
        };
        Main.worker.submit(task);
        Main.worker.submit(r);
    }

    private static Collection<String> getOnlinePluginSites() {
        ArrayList<String> pluginSites = new ArrayList<String>(Main.pref.getPluginSites());
        Iterator it = pluginSites.iterator();
        while (it.hasNext()) {
            try {
                OnlineResource.JOSM_WEBSITE.checkOfflineAccess((String)it.next(), Main.getJOSMWebsite());
            }
            catch (OfflineAccessException ex) {
                Main.warn(ex.getMessage());
                it.remove();
            }
        }
        return pluginSites;
    }

    private static class PluginConfigurationSitesPanel
    extends JPanel {
        private DefaultListModel<String> model;

        protected final void build() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(I18n.tr("Add JOSM Plugin description URL.", new Object[0])), GBC.eol());
            this.model = new DefaultListModel();
            for (String s : Main.pref.getPluginSites()) {
                this.model.addElement(s);
            }
            final JList<String> list = new JList<String>(this.model);
            this.add((Component)new JScrollPane(list), GBC.std().fill());
            JPanel buttons = new JPanel(new GridBagLayout());
            buttons.add((Component)new JButton(new AbstractAction(I18n.tr("Add", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = JOptionPane.showInputDialog(JOptionPane.getFrameForComponent(PluginConfigurationSitesPanel.this), I18n.tr("Add JOSM Plugin description URL.", new Object[0]), I18n.tr("Enter URL", new Object[0]), 3);
                    if (s != null) {
                        PluginConfigurationSitesPanel.this.model.addElement(s);
                    }
                }
            }), GBC.eol().fill(2));
            buttons.add((Component)new JButton(new AbstractAction(I18n.tr("Edit", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (list.getSelectedValue() == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(PluginConfigurationSitesPanel.this), I18n.tr("Please select an entry.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                        return;
                    }
                    String s = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr("Edit JOSM Plugin description URL.", new Object[0]), I18n.tr("JOSM Plugin description URL", new Object[0]), 3, null, null, list.getSelectedValue());
                    if (s != null) {
                        PluginConfigurationSitesPanel.this.model.setElementAt(s, list.getSelectedIndex());
                    }
                }
            }), GBC.eol().fill(2));
            buttons.add((Component)new JButton(new AbstractAction(I18n.tr("Delete", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (list.getSelectedValue() == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(PluginConfigurationSitesPanel.this), I18n.tr("Please select an entry.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                        return;
                    }
                    PluginConfigurationSitesPanel.this.model.removeElement(list.getSelectedValue());
                }
            }), GBC.eol().fill(2));
            this.add((Component)buttons, GBC.eol());
        }

        public PluginConfigurationSitesPanel() {
            this.build();
        }

        public List<String> getUpdateSites() {
            if (this.model.getSize() == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> ret = new ArrayList<String>(this.model.getSize());
            for (int i = 0; i < this.model.getSize(); ++i) {
                ret.add(this.model.get(i));
            }
            return ret;
        }
    }

    class SearchFieldAdapter
    implements DocumentListener {
        SearchFieldAdapter() {
        }

        public void filter() {
            String expr = PluginPreference.this.tfFilter.getText().trim();
            if (expr.isEmpty()) {
                expr = null;
            }
            PluginPreference.this.model.filterDisplayedPlugins(expr);
            PluginPreference.this.pnlPluginPreferences.refreshView();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.filter();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.filter();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.filter();
        }
    }

    class ConfigureSitesAction
    extends AbstractAction {
        public ConfigureSitesAction() {
            this.putValue("Name", I18n.tr("Configure sites...", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Configure the list of sites where plugins are downloaded from", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "settings"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PluginPreference.this.configureSites();
        }
    }

    class UpdateSelectedPluginsAction
    extends AbstractAction {
        public UpdateSelectedPluginsAction() {
            this.putValue("Name", I18n.tr("Update plugins", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Update the selected plugins", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
        }

        protected void alertNothingToUpdate() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        HelpAwareOptionPane.showOptionDialog(PluginPreference.this.pnlPluginPreferences, I18n.tr("All installed plugins are up to date. JOSM does not have to download newer versions.", new Object[0]), I18n.tr("Plugins up to date", new Object[0]), 1, null);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                Main.error(e);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final List<PluginInformation> toUpdate = PluginPreference.this.model.getSelectedPlugins();
            final PluginDownloadTask pluginDownloadTask = new PluginDownloadTask((Component)PluginPreference.this.pnlPluginPreferences, toUpdate, I18n.tr("Update plugins", new Object[0]));
            final ReadRemotePluginInformationTask pluginInfoDownloadTask = new ReadRemotePluginInformationTask(PluginPreference.getOnlinePluginSites());
            final Runnable pluginDownloadContinuation = new Runnable(){

                @Override
                public void run() {
                    if (pluginDownloadTask.isCanceled()) {
                        return;
                    }
                    boolean restartRequired = false;
                    for (PluginInformation pi : pluginDownloadTask.getDownloadedPlugins()) {
                        if (PluginPreference.this.model.getNewlyActivatedPlugins().contains(pi) && pi.canloadatruntime) continue;
                        restartRequired = true;
                        break;
                    }
                    PluginPreference.notifyDownloadResults(PluginPreference.this.pnlPluginPreferences, pluginDownloadTask, restartRequired);
                    PluginPreference.this.model.refreshLocalPluginVersion(pluginDownloadTask.getDownloadedPlugins());
                    PluginPreference.this.model.clearPendingPlugins(pluginDownloadTask.getDownloadedPlugins());
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            PluginPreference.this.pnlPluginPreferences.refreshView();
                        }
                    });
                }
            };
            Runnable pluginInfoDownloadContinuation = new Runnable(){

                @Override
                public void run() {
                    if (pluginInfoDownloadTask.isCanceled()) {
                        return;
                    }
                    PluginPreference.this.model.updateAvailablePlugins(pluginInfoDownloadTask.getAvailablePlugins());
                    Iterator it = toUpdate.iterator();
                    while (it.hasNext()) {
                        PluginInformation pi = (PluginInformation)it.next();
                        if (pi.isUpdateRequired()) continue;
                        it.remove();
                    }
                    if (toUpdate.isEmpty()) {
                        UpdateSelectedPluginsAction.this.alertNothingToUpdate();
                        return;
                    }
                    pluginDownloadTask.setPluginsToDownload(toUpdate);
                    Main.worker.submit(pluginDownloadTask);
                    Main.worker.submit(pluginDownloadContinuation);
                }
            };
            Main.worker.submit(pluginInfoDownloadTask);
            Main.worker.submit(pluginInfoDownloadContinuation);
        }
    }

    class DownloadAvailablePluginsAction
    extends AbstractAction {
        public DownloadAvailablePluginsAction() {
            this.putValue("Name", I18n.tr("Download list", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Download the list of available plugins", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("download"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection pluginSites = PluginPreference.getOnlinePluginSites();
            if (pluginSites.isEmpty()) {
                return;
            }
            final ReadRemotePluginInformationTask task = new ReadRemotePluginInformationTask(pluginSites);
            Runnable continuation = new Runnable(){

                @Override
                public void run() {
                    if (task.isCanceled()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PluginPreference.this.model.updateAvailablePlugins(task.getAvailablePlugins());
                            PluginPreference.this.pnlPluginPreferences.refreshView();
                            Main.pref.putInteger("pluginmanager.version", Version.getInstance().getVersion());
                        }
                    });
                }
            };
            Main.worker.submit(task);
            Main.worker.submit(continuation);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new PluginPreference();
        }
    }
}

