/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class PluginListPanel
extends VerticallyScrollablePanel {
    private PluginPreferencesModel model;

    public PluginListPanel() {
        this(new PluginPreferencesModel());
    }

    public PluginListPanel(PluginPreferencesModel model) {
        this.model = model;
        this.setLayout(new GridBagLayout());
    }

    protected String formatPluginRemoteVersion(PluginInformation pi) {
        StringBuilder sb = new StringBuilder();
        if (pi.version == null || pi.version.trim().isEmpty()) {
            sb.append(I18n.tr("unknown", new Object[0]));
        } else {
            sb.append(pi.version);
            if (pi.oldmode) {
                sb.append("*");
            }
        }
        return sb.toString();
    }

    protected String formatPluginLocalVersion(PluginInformation pi) {
        if (pi == null) {
            return I18n.tr("unknown", new Object[0]);
        }
        if (pi.localversion == null || pi.localversion.trim().isEmpty()) {
            return I18n.tr("unknown", new Object[0]);
        }
        return pi.localversion;
    }

    protected String formatCheckboxTooltipText(PluginInformation pi) {
        if (pi == null) {
            return "";
        }
        if (pi.downloadlink == null) {
            return I18n.tr("Plugin bundled with JOSM", new Object[0]);
        }
        return pi.downloadlink;
    }

    public void displayEmptyPluginListInformation() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(40, 0, 40, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        HtmlPanel hint = new HtmlPanel();
        hint.setText("<html>" + I18n.tr("Please click on <strong>Download list</strong> to download and display a list of available plugins.", new Object[0]) + "</html>");
        this.add((Component)hint, gbc);
    }

    private static void alertPluginStillRequired(Component parent, String plugin, Set<String> otherPlugins) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(I18n.trn("Plugin {0} is still required by this plugin:", "Plugin {0} is still required by these {1} plugins:", otherPlugins.size(), plugin, otherPlugins.size()));
        sb.append(Utils.joinAsHtmlUnorderedList(otherPlugins));
        sb.append("</html>");
        JOptionPane.showMessageDialog(parent, sb.toString(), I18n.tr("Warning", new Object[0]), 2);
    }

    public void refreshView() {
        final Rectangle visibleRect = this.getVisibleRect();
        List<PluginInformation> displayedPlugins = this.model.getDisplayedPlugins();
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        if (displayedPlugins.isEmpty()) {
            this.displayEmptyPluginListInformation();
            return;
        }
        int row = -1;
        for (PluginInformation pi : displayedPlugins) {
            boolean selected = this.model.isSelectedPlugin(pi.getName());
            String remoteversion = this.formatPluginRemoteVersion(pi);
            String localversion = this.formatPluginLocalVersion(this.model.getPluginInformation(pi.getName()));
            final JPluginCheckBox cbPlugin = new JPluginCheckBox(pi, selected);
            String pluginText = I18n.tr("{0}: Version {1} (local: {2})", pi.getName(), remoteversion, localversion);
            if (pi.requires != null && !pi.requires.isEmpty()) {
                pluginText = pluginText + I18n.tr(" (requires: {0})", pi.requires);
            }
            JLabel lblPlugin = new JLabel(pluginText, pi.getScaledIcon(), 2);
            lblPlugin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    cbPlugin.doClick();
                }
            });
            gbc.gridx = 0;
            gbc.gridy = ++row;
            gbc.insets = new Insets(5, 5, 0, 5);
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            this.add((Component)cbPlugin, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            this.add((Component)lblPlugin, gbc);
            HtmlPanel description = new HtmlPanel();
            description.setText(pi.getDescriptionAsHtml());
            description.getEditorPane().addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.displayUrl(e.getURL().toString());
                    }
                }
            });
            gbc.gridx = 1;
            gbc.gridy = ++row;
            gbc.insets = new Insets(3, 25, 5, 5);
            gbc.weighty = 1.0;
            this.add((Component)description, gbc);
        }
        this.revalidate();
        this.repaint();
        if (visibleRect != null && visibleRect.width > 0 && visibleRect.height > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginListPanel.this.scrollRectToVisible(visibleRect);
                }
            });
        }
    }

    private class PluginCbActionListener
    implements ActionListener {
        private final JPluginCheckBox cb;

        public PluginCbActionListener(JPluginCheckBox cb) {
            this.cb = cb;
        }

        protected void selectRequiredPlugins(PluginInformation info) {
            if (info != null && info.requires != null) {
                for (String s : info.getRequiredPlugins()) {
                    if (PluginListPanel.this.model.isSelectedPlugin(s)) continue;
                    PluginListPanel.this.model.setPluginSelected(s, true);
                    this.selectRequiredPlugins(PluginListPanel.this.model.getPluginInformation(s));
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PluginListPanel.this.model.setPluginSelected(this.cb.pi.getName(), this.cb.isSelected());
            if (this.cb.isSelected() && this.cb.pi.requires != null) {
                this.selectRequiredPlugins(this.cb.pi);
                PluginHandler.checkRequiredPluginsPreconditions(PluginListPanel.this, PluginListPanel.this.model.getAvailablePlugins(), this.cb.pi, false);
            } else if (!this.cb.isSelected()) {
                HashSet<String> otherPlugins = new HashSet<String>();
                block0: for (PluginInformation pi : PluginListPanel.this.model.getAvailablePlugins()) {
                    if (pi.equals(this.cb.pi) || pi.requires == null || !PluginListPanel.this.model.isSelectedPlugin(pi.getName())) continue;
                    for (String s : pi.getRequiredPlugins()) {
                        if (!s.equals(this.cb.pi.getName())) continue;
                        otherPlugins.add(pi.getName());
                        continue block0;
                    }
                }
                if (!otherPlugins.isEmpty()) {
                    PluginListPanel.alertPluginStillRequired(PluginListPanel.this, this.cb.pi.getName(), otherPlugins);
                }
            }
        }
    }

    private class JPluginCheckBox
    extends JCheckBox {
        public final PluginInformation pi;

        public JPluginCheckBox(PluginInformation pi, boolean selected) {
            this.pi = pi;
            this.setSelected(selected);
            this.setToolTipText(PluginListPanel.this.formatCheckboxTooltipText(pi));
            this.addActionListener(new PluginCbActionListener(this));
        }
    }
}

