/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.map;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.SourceProvider;
import org.openstreetmap.josm.gui.preferences.SourceType;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.map.MapPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPresetReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class TaggingPresetPreference
implements SubPreferenceSetting {
    private static final List<SourceProvider> presetSourceProviders = new ArrayList<SourceProvider>();
    private SourceEditor sources;
    private JCheckBox sortMenu;
    private PreferenceTabbedPane.ValidationListener validationListener = new PreferenceTabbedPane.ValidationListener(){

        @Override
        public boolean validatePreferences() {
            if (TaggingPresetPreference.this.sources.hasActiveSourcesChanged()) {
                ArrayList<Integer> sourcesToRemove = new ArrayList<Integer>();
                int i = -1;
                block15: for (SourceEntry source : TaggingPresetPreference.this.sources.getActiveSources()) {
                    ++i;
                    boolean canLoad = false;
                    try {
                        TaggingPresetReader.readAll(source.url, false);
                        canLoad = true;
                    }
                    catch (IOException e) {
                        Main.warn(I18n.tr("Could not read tagging preset source: {0}", source));
                        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Error", new Object[0]), new String[]{I18n.tr("Yes", new Object[0]), I18n.tr("No", new Object[0]), I18n.tr("Cancel", new Object[0])});
                        ed.setContent(I18n.tr("Could not read tagging preset source: {0}\nDo you want to keep it?", source));
                        switch (ed.showDialog().getValue()) {
                            case 1: {
                                continue block15;
                            }
                            case 2: {
                                sourcesToRemove.add(i);
                                continue block15;
                            }
                        }
                        return false;
                    }
                    catch (SAXException e) {
                        // empty catch block
                    }
                    String errorMessage = null;
                    try {
                        TaggingPresetReader.readAll(source.url, true);
                    }
                    catch (IOException e) {
                        String msg = I18n.tr("Could not read tagging preset source {0}", source);
                        Main.error(msg);
                        JOptionPane.showMessageDialog(Main.parent, msg);
                        return false;
                    }
                    catch (SAXParseException e) {
                        errorMessage = canLoad ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: [{1}:{2}] {3}</table></html>", source, e.getLineNumber(), e.getColumnNumber(), e.getMessage()) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=400>Error is: [{1}:{2}] {3}</table></html>", source, e.getLineNumber(), e.getColumnNumber(), e.getMessage());
                    }
                    catch (SAXException e) {
                        errorMessage = canLoad ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", source, e.getMessage()) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", source, e.getMessage());
                    }
                    if (errorMessage == null) continue;
                    Main.error(errorMessage);
                    int result = JOptionPane.showConfirmDialog(Main.parent, new JLabel(errorMessage), I18n.tr("Error", new Object[0]), 1, 0);
                    switch (result) {
                        case 0: {
                            continue block15;
                        }
                        case 1: {
                            sourcesToRemove.add(i);
                            continue block15;
                        }
                    }
                    return false;
                }
                TaggingPresetPreference.this.sources.removeSources(sourcesToRemove);
                return true;
            }
            return true;
        }
    };

    private TaggingPresetPreference() {
    }

    public static final boolean registerSourceProvider(SourceProvider provider) {
        if (provider != null) {
            return presetSourceProviders.add(provider);
        }
        return false;
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        this.sortMenu = new JCheckBox(I18n.tr("Sort presets menu", new Object[0]), Main.pref.getBoolean("taggingpreset.sortmenu", false));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.add((Component)this.sortMenu, GBC.eol().insets(5, 5, 5, 0));
        this.sources = new TaggingPresetSourceEditor();
        panel.add((Component)this.sources, GBC.eol().fill(1));
        MapPreference mapPref = gui.getMapPreference();
        mapPref.addSubTab(this, I18n.tr("Tagging Presets", new Object[0]), panel);
        this.sources.deferLoading(mapPref, panel);
        gui.addValidationListener(this.validationListener);
    }

    @Override
    public boolean ok() {
        boolean restart = Main.pref.put("taggingpreset.sortmenu", this.sortMenu.getSelectedObjects() != null);
        return restart |= this.sources.finish();
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getMapPreference();
    }

    public static class PresetPrefHelper
    extends SourceEditor.SourcePrefHelper {
        public static final PresetPrefHelper INSTANCE = new PresetPrefHelper();

        public PresetPrefHelper() {
            super("taggingpreset.entries");
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            SourceEditor.ExtendedSourceEntry i = new SourceEditor.ExtendedSourceEntry("defaultpresets.xml", "resource://data/defaultpresets.xml");
            i.title = I18n.tr("Internal Preset", new Object[0]);
            i.description = I18n.tr("The default preset for JOSM", new Object[0]);
            return Collections.singletonList(i);
        }

        @Override
        public Map<String, String> serialize(SourceEntry entry) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("url", entry.url);
            res.put("title", entry.title == null ? "" : entry.title);
            return res;
        }

        @Override
        public SourceEntry deserialize(Map<String, String> s) {
            return new SourceEntry(s.get("url"), null, s.get("title"), true);
        }
    }

    static class TaggingPresetSourceEditor
    extends SourceEditor {
        public TaggingPresetSourceEditor() {
            super(SourceType.TAGGING_PRESET, Main.getJOSMWebsite() + "/presets", presetSourceProviders, true);
        }

        @Override
        public Collection<? extends SourceEntry> getInitialSourcesList() {
            return PresetPrefHelper.INSTANCE.get();
        }

        @Override
        public boolean finish() {
            List<SourceEntry> activeStyles = this.activeSourcesModel.getSources();
            boolean changed = PresetPrefHelper.INSTANCE.put(activeStyles);
            if (this.tblIconPaths != null) {
                List<String> iconPaths = this.iconPathsModel.getIconPaths();
                if (!iconPaths.isEmpty()) {
                    if (Main.pref.putCollection("taggingpreset.icon.sources", iconPaths)) {
                        changed = true;
                    }
                } else if (Main.pref.putCollection("taggingpreset.icon.sources", null)) {
                    changed = true;
                }
            }
            return changed;
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            return PresetPrefHelper.INSTANCE.getDefault();
        }

        @Override
        public Collection<String> getInitialIconPathsList() {
            return Main.pref.getCollection("taggingpreset.icon.sources", null);
        }

        @Override
        public String getStr(SourceEditor.I18nString ident) {
            switch (ident) {
                case AVAILABLE_SOURCES: {
                    return I18n.tr("Available presets:", new Object[0]);
                }
                case ACTIVE_SOURCES: {
                    return I18n.tr("Active presets:", new Object[0]);
                }
                case NEW_SOURCE_ENTRY_TOOLTIP: {
                    return I18n.tr("Add a new preset by entering filename or URL", new Object[0]);
                }
                case NEW_SOURCE_ENTRY: {
                    return I18n.tr("New preset entry:", new Object[0]);
                }
                case REMOVE_SOURCE_TOOLTIP: {
                    return I18n.tr("Remove the selected presets from the list of active presets", new Object[0]);
                }
                case EDIT_SOURCE_TOOLTIP: {
                    return I18n.tr("Edit the filename or URL for the selected active preset", new Object[0]);
                }
                case ACTIVATE_TOOLTIP: {
                    return I18n.tr("Add the selected available presets to the list of active presets", new Object[0]);
                }
                case RELOAD_ALL_AVAILABLE: {
                    return I18n.marktr("Reloads the list of available presets from ''{0}''");
                }
                case LOADING_SOURCES_FROM: {
                    return I18n.marktr("Loading preset sources from ''{0}''");
                }
                case FAILED_TO_LOAD_SOURCES_FROM: {
                    return I18n.marktr("<html>Failed to load the list of preset sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>");
                }
                case FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC: {
                    return "/Preferences/Presets#FailedToLoadPresetSources";
                }
                case ILLEGAL_FORMAT_OF_ENTRY: {
                    return I18n.marktr("Warning: illegal format of entry in preset list ''{0}''. Got ''{1}''");
                }
            }
            throw new AssertionError();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new TaggingPresetPreference();
        }
    }
}

