/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.map;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.SourceProvider;
import org.openstreetmap.josm.gui.preferences.SourceType;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.map.MapPreference;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class MapPaintPreference
implements SubPreferenceSetting {
    private SourceEditor sources;
    private JCheckBox enableIconDefault;
    private static final List<SourceProvider> styleSourceProviders = new ArrayList<SourceProvider>();

    public static boolean registerSourceProvider(SourceProvider provider) {
        if (provider != null) {
            return styleSourceProviders.add(provider);
        }
        return false;
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        this.enableIconDefault = new JCheckBox(I18n.tr("Enable built-in icon defaults", new Object[0]), Main.pref.getBoolean("mappaint.icon.enable-defaults", true));
        this.sources = new MapPaintSourceEditor();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.add((Component)this.sources, GBC.eol().fill(1));
        panel.add((Component)this.enableIconDefault, GBC.eol().insets(11, 2, 5, 0));
        MapPreference mapPref = gui.getMapPreference();
        mapPref.addSubTab(this, I18n.tr("Map Paint Styles", new Object[0]), panel);
        this.sources.deferLoading(mapPref, panel);
    }

    @Override
    public boolean ok() {
        boolean reload = Main.pref.put("mappaint.icon.enable-defaults", this.enableIconDefault.isSelected());
        if (reload |= this.sources.finish()) {
            MapPaintStyles.readFromPreferences();
        }
        if (Main.isDisplayingMapView()) {
            MapPaintStyles.getStyles().clearCached();
        }
        return false;
    }

    public static void initialize() {
        MapPaintStyles.readFromPreferences();
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getMapPreference();
    }

    public static class MapPaintPrefHelper
    extends SourceEditor.SourcePrefHelper {
        public static final MapPaintPrefHelper INSTANCE = new MapPaintPrefHelper();

        public MapPaintPrefHelper() {
            super("mappaint.style.entries");
        }

        @Override
        public List<SourceEntry> get() {
            List<SourceEntry> ls = super.get();
            if (this.insertNewDefaults(ls)) {
                this.put(ls);
            }
            return ls;
        }

        private boolean insertNewDefaults(List<SourceEntry> list) {
            SourceEntry josmXml;
            boolean changed = false;
            boolean addedMapcssStyle = false;
            TreeSet<String> knownDefaults = new TreeSet<String>(Main.pref.getCollection("mappaint.style.known-defaults"));
            Collection<SourceEditor.ExtendedSourceEntry> defaults = this.getDefault();
            int insertionIdx = 0;
            for (final SourceEntry sourceEntry : defaults) {
                int i = Utils.indexOf(list, new Predicate<SourceEntry>(){

                    @Override
                    public boolean evaluate(SourceEntry se) {
                        return Objects.equals(sourceEntry.url, se.url);
                    }
                });
                if (i == -1 && !knownDefaults.contains(sourceEntry.url)) {
                    sourceEntry.active = false;
                    list.add(insertionIdx, sourceEntry);
                    ++insertionIdx;
                    changed = true;
                    if (!"resource://styles/standard/elemstyles.mapcss".equals(sourceEntry.url)) continue;
                    addedMapcssStyle = true;
                    continue;
                }
                if (i < insertionIdx) continue;
                insertionIdx = i + 1;
            }
            for (SourceEntry sourceEntry : defaults) {
                knownDefaults.add(sourceEntry.url);
            }
            knownDefaults.remove("resource://styles/standard/elemstyles.xml");
            Main.pref.putCollection("mappaint.style.known-defaults", knownDefaults);
            if (addedMapcssStyle && !Main.pref.getBoolean("mappaint.style.migration.changedXmlName", false)) {
                josmXml = Utils.find(list, new Predicate<SourceEntry>(){

                    @Override
                    public boolean evaluate(SourceEntry se) {
                        return "resource://styles/standard/elemstyles.xml".equals(se.url);
                    }
                });
                if (josmXml != null) {
                    josmXml.title = I18n.tr("JOSM default (XML; old version)", new Object[0]);
                    changed = true;
                }
                Main.pref.put("mappaint.style.migration.changedXmlName", true);
            }
            if (!Main.pref.getBoolean("mappaint.style.migration.switchedToMapCSS", false)) {
                josmXml = Utils.find(list, new Predicate<SourceEntry>(){

                    @Override
                    public boolean evaluate(SourceEntry se) {
                        return "resource://styles/standard/elemstyles.xml".equals(se.url);
                    }
                });
                SourceEntry sourceEntry = Utils.find(list, new Predicate<SourceEntry>(){

                    @Override
                    public boolean evaluate(SourceEntry se) {
                        return "resource://styles/standard/elemstyles.mapcss".equals(se.url);
                    }
                });
                if (josmXml != null && sourceEntry != null && josmXml.active) {
                    sourceEntry.active = true;
                    josmXml.active = false;
                    Main.info("Switched mappaint style from XML format to MapCSS (one time migration).");
                    changed = true;
                }
                Main.pref.put("mappaint.style.migration.switchedToMapCSS", true);
            }
            list.remove(Utils.find(list, new Predicate<SourceEntry>(){

                @Override
                public boolean evaluate(SourceEntry se) {
                    return "resource://styles/standard/elemstyles.xml".equals(se.url);
                }
            }));
            return changed;
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            SourceEditor.ExtendedSourceEntry defJosmMapcss = new SourceEditor.ExtendedSourceEntry("elemstyles.mapcss", "resource://styles/standard/elemstyles.mapcss");
            defJosmMapcss.active = true;
            defJosmMapcss.name = "standard";
            defJosmMapcss.title = I18n.tr("JOSM default (MapCSS)", new Object[0]);
            defJosmMapcss.description = I18n.tr("Internal style to be used as base for runtime switchable overlay styles", new Object[0]);
            SourceEditor.ExtendedSourceEntry defPL2 = new SourceEditor.ExtendedSourceEntry("potlatch2.mapcss", "resource://styles/standard/potlatch2.mapcss");
            defPL2.active = false;
            defPL2.name = "standard";
            defPL2.title = I18n.tr("Potlatch 2", new Object[0]);
            defPL2.description = I18n.tr("the main Potlatch 2 style", new Object[0]);
            return Arrays.asList(defJosmMapcss, defPL2);
        }

        @Override
        public Map<String, String> serialize(SourceEntry entry) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("url", entry.url);
            res.put("title", entry.title == null ? "" : entry.title);
            res.put("active", Boolean.toString(entry.active));
            if (entry.name != null) {
                res.put("ptoken", entry.name);
            }
            return res;
        }

        @Override
        public SourceEntry deserialize(Map<String, String> s) {
            return new SourceEntry(s.get("url"), s.get("ptoken"), s.get("title"), Boolean.parseBoolean(s.get("active")));
        }
    }

    static class MapPaintSourceEditor
    extends SourceEditor {
        public MapPaintSourceEditor() {
            super(SourceType.MAP_PAINT_STYLE, Main.getJOSMWebsite() + "/styles", styleSourceProviders, true);
        }

        @Override
        public Collection<? extends SourceEntry> getInitialSourcesList() {
            return MapPaintPrefHelper.INSTANCE.get();
        }

        @Override
        public boolean finish() {
            List<SourceEntry> activeStyles = this.activeSourcesModel.getSources();
            boolean changed = MapPaintPrefHelper.INSTANCE.put(activeStyles);
            if (this.tblIconPaths != null) {
                List<String> iconPaths = this.iconPathsModel.getIconPaths();
                if (!iconPaths.isEmpty()) {
                    if (Main.pref.putCollection("mappaint.icon.sources", iconPaths)) {
                        changed = true;
                    }
                } else if (Main.pref.putCollection("mappaint.icon.sources", null)) {
                    changed = true;
                }
            }
            return changed;
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            return MapPaintPrefHelper.INSTANCE.getDefault();
        }

        @Override
        public Collection<String> getInitialIconPathsList() {
            return Main.pref.getCollection("mappaint.icon.sources", null);
        }

        @Override
        public String getStr(SourceEditor.I18nString ident) {
            switch (ident) {
                case AVAILABLE_SOURCES: {
                    return I18n.tr("Available styles:", new Object[0]);
                }
                case ACTIVE_SOURCES: {
                    return I18n.tr("Active styles:", new Object[0]);
                }
                case NEW_SOURCE_ENTRY_TOOLTIP: {
                    return I18n.tr("Add a new style by entering filename or URL", new Object[0]);
                }
                case NEW_SOURCE_ENTRY: {
                    return I18n.tr("New style entry:", new Object[0]);
                }
                case REMOVE_SOURCE_TOOLTIP: {
                    return I18n.tr("Remove the selected styles from the list of active styles", new Object[0]);
                }
                case EDIT_SOURCE_TOOLTIP: {
                    return I18n.tr("Edit the filename or URL for the selected active style", new Object[0]);
                }
                case ACTIVATE_TOOLTIP: {
                    return I18n.tr("Add the selected available styles to the list of active styles", new Object[0]);
                }
                case RELOAD_ALL_AVAILABLE: {
                    return I18n.marktr("Reloads the list of available styles from ''{0}''");
                }
                case LOADING_SOURCES_FROM: {
                    return I18n.marktr("Loading style sources from ''{0}''");
                }
                case FAILED_TO_LOAD_SOURCES_FROM: {
                    return I18n.marktr("<html>Failed to load the list of style sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>");
                }
                case FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC: {
                    return "/Preferences/Styles#FailedToLoadStyleSources";
                }
                case ILLEGAL_FORMAT_OF_ENTRY: {
                    return I18n.marktr("Warning: illegal format of entry in style list ''{0}''. Got ''{1}''");
                }
            }
            throw new AssertionError();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new MapPaintPreference();
        }
    }
}

