/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class WMSSettingsPanel
extends JPanel {
    private final JCheckBox autozoomActive = new JCheckBox();
    private final JCheckBox overlapCheckBox;
    private final JSpinner spinEast;
    private final JSpinner spinNorth;
    private final JSpinner spinSimConn;

    public WMSSettingsPanel() {
        super(new GridBagLayout());
        this.add((Component)new JLabel(I18n.tr("Auto zoom by default: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.autozoomActive, GBC.eol().fill(2));
        this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        JLabel labelSimConn = new JLabel(I18n.tr("Simultaneous connections:", new Object[0]));
        this.spinSimConn = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.get(), 1, 30, 1));
        this.add((Component)labelSimConn, GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.spinSimConn, GBC.eol());
        this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        this.overlapCheckBox = new JCheckBox(I18n.tr("Overlap tiles", new Object[0]));
        JLabel labelEast = new JLabel(I18n.tr("% of east:", new Object[0]));
        JLabel labelNorth = new JLabel(I18n.tr("% of north:", new Object[0]));
        this.spinEast = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_OVERLAP_EAST.get(), 1, 50, 1));
        this.spinNorth = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_OVERLAP_NORTH.get(), 1, 50, 1));
        JPanel overlapPanel = new JPanel(new FlowLayout());
        overlapPanel.add(this.overlapCheckBox);
        overlapPanel.add(labelEast);
        overlapPanel.add(this.spinEast);
        overlapPanel.add(labelNorth);
        overlapPanel.add(this.spinNorth);
        this.add((Component)overlapPanel, GBC.eop());
    }

    public void loadSettings() {
        this.autozoomActive.setSelected(WMSLayer.PROP_DEFAULT_AUTOZOOM.get());
        this.overlapCheckBox.setSelected(WMSLayer.PROP_OVERLAP.get());
        this.spinEast.setValue(WMSLayer.PROP_OVERLAP_EAST.get());
        this.spinNorth.setValue(WMSLayer.PROP_OVERLAP_NORTH.get());
        this.spinSimConn.setValue(WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.get());
    }

    public boolean saveSettings() {
        WMSLayer.PROP_DEFAULT_AUTOZOOM.put(this.autozoomActive.isSelected());
        WMSLayer.PROP_OVERLAP.put(this.overlapCheckBox.getModel().isSelected());
        WMSLayer.PROP_OVERLAP_EAST.put((Integer)this.spinEast.getModel().getValue());
        WMSLayer.PROP_OVERLAP_NORTH.put((Integer)this.spinNorth.getModel().getValue());
        WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.put((Integer)this.spinSimConn.getModel().getValue());
        return false;
    }
}

