/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.I18n;

public class WMSLayerTree {
    private final MutableTreeNode treeRootNode = new DefaultMutableTreeNode();
    private final DefaultTreeModel treeData = new DefaultTreeModel(this.treeRootNode);
    private final JTree layerTree = new JTree(this.treeData);
    private final List<WMSImagery.LayerDetails> selectedLayers = new LinkedList<WMSImagery.LayerDetails>();
    private boolean previouslyShownUnsupportedCrsError = false;

    public MutableTreeNode getTreeRootNode() {
        return this.treeRootNode;
    }

    public JTree getLayerTree() {
        return this.layerTree;
    }

    public List<WMSImagery.LayerDetails> getSelectedLayers() {
        return this.selectedLayers;
    }

    public WMSLayerTree() {
        this.layerTree.setCellRenderer(new LayerTreeCellRenderer());
        this.layerTree.addTreeSelectionListener(new WMSTreeSelectionListener());
    }

    void addLayersToTreeData(MutableTreeNode parent, List<WMSImagery.LayerDetails> layers) {
        for (WMSImagery.LayerDetails layerDetails : layers) {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(layerDetails);
            this.addLayersToTreeData(treeNode, layerDetails.children);
            this.treeData.insertNodeInto(treeNode, parent, 0);
        }
    }

    public void updateTree(WMSImagery wms) {
        this.treeRootNode.setUserObject(wms.getServiceUrl().getHost());
        this.updateTreeList(wms.getLayers());
    }

    public void updateTreeList(List<WMSImagery.LayerDetails> layers) {
        this.addLayersToTreeData(this.getTreeRootNode(), layers);
        this.getLayerTree().expandRow(0);
        this.getLayerTree().expandRow(1);
    }

    private class WMSTreeSelectionListener
    implements TreeSelectionListener {
        private WMSTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] selectionRows = WMSLayerTree.this.layerTree.getSelectionPaths();
            if (selectionRows == null) {
                return;
            }
            WMSLayerTree.this.selectedLayers.clear();
            for (TreePath i : selectionRows) {
                Object userObject = ((DefaultMutableTreeNode)i.getLastPathComponent()).getUserObject();
                if (!(userObject instanceof WMSImagery.LayerDetails)) continue;
                WMSImagery.LayerDetails detail = (WMSImagery.LayerDetails)userObject;
                if (!detail.isSupported()) {
                    WMSLayerTree.this.layerTree.removeSelectionPath(i);
                    if (WMSLayerTree.this.previouslyShownUnsupportedCrsError) continue;
                    JOptionPane.showMessageDialog(null, I18n.tr("That layer does not support any of JOSM''s projections,\nso you can not use it. This message will not show again.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
                    WMSLayerTree.this.previouslyShownUnsupportedCrsError = true;
                    continue;
                }
                if (detail.ident == null) continue;
                WMSLayerTree.this.selectedLayers.add(detail);
            }
            WMSLayerTree.this.layerTree.firePropertyChange("selectedLayers", false, true);
        }
    }

    private static class LayerTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private LayerTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof WMSImagery.LayerDetails) {
                WMSImagery.LayerDetails layer = (WMSImagery.LayerDetails)userObject;
                this.setEnabled(layer.isSupported());
            }
            return this;
        }
    }
}

