/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;

public class GPXSettingsPanel
extends JPanel
implements PreferenceTabbedPane.ValidationListener {
    private static final String[] LABEL_PATTERN_TEMPLATE = new String[]{"?{ '{name} - {desc}' | '{name}' | '{desc}' }", "{name}", "{desc}", "{special:everything}", "?{ '{name}' | '{desc}' | '{formattedWaypointOffset}' }", ""};
    private static final String[] LABEL_PATTERN_DESC = new String[]{I18n.tr("Auto", new Object[0]), I18n.trc("gpx_field", "Name"), I18n.trc("gpx_field", "Desc(ription)"), I18n.tr("Everything", new Object[0]), I18n.tr("Name or offset", new Object[0]), I18n.tr("None", new Object[0]), I18n.tr("Custom", new Object[0])};
    private JRadioButton drawRawGpsLinesGlobal = new JRadioButton(I18n.tr("Use global settings", new Object[0]));
    private JRadioButton drawRawGpsLinesAll = new JRadioButton(I18n.tr("All", new Object[0]));
    private JRadioButton drawRawGpsLinesLocal = new JRadioButton(I18n.tr("Local files", new Object[0]));
    private JRadioButton drawRawGpsLinesNone = new JRadioButton(I18n.tr("None", new Object[0]));
    private ActionListener drawRawGpsLinesActionListener;
    private JosmTextField drawRawGpsMaxLineLength = new JosmTextField(8);
    private JosmTextField drawRawGpsMaxLineLengthLocal = new JosmTextField(8);
    private JosmTextField drawLineWidth = new JosmTextField(2);
    private JCheckBox forceRawGpsLines = new JCheckBox(I18n.tr("Force lines if no segments imported", new Object[0]));
    private JCheckBox largeGpsPoints = new JCheckBox(I18n.tr("Draw large GPS points", new Object[0]));
    private JCheckBox hdopCircleGpsPoints = new JCheckBox(I18n.tr("Draw a circle from HDOP value", new Object[0]));
    private JRadioButton colorTypeVelocity = new JRadioButton(I18n.tr("Velocity (red = slow, green = fast)", new Object[0]));
    private JRadioButton colorTypeDirection = new JRadioButton(I18n.tr("Direction (red = west, yellow = north, green = east, blue = south)", new Object[0]));
    private JRadioButton colorTypeDilution = new JRadioButton(I18n.tr("Dilution of Position (red = high, green = low, if available)", new Object[0]));
    private JRadioButton colorTypeTime = new JRadioButton(I18n.tr("Track date", new Object[0]));
    private JRadioButton colorTypeNone = new JRadioButton(I18n.tr("Single Color (can be customized for named layers)", new Object[0]));
    private JRadioButton colorTypeGlobal = new JRadioButton(I18n.tr("Use global settings", new Object[0]));
    private JosmComboBox<String> colorTypeVelocityTune = new JosmComboBox<String>(new String[]{I18n.tr("Car", new Object[0]), I18n.tr("Bicycle", new Object[0]), I18n.tr("Foot", new Object[0])});
    private JCheckBox makeAutoMarkers = new JCheckBox(I18n.tr("Create markers when reading GPX", new Object[0]));
    private JCheckBox drawGpsArrows = new JCheckBox(I18n.tr("Draw Direction Arrows", new Object[0]));
    private JCheckBox drawGpsArrowsFast = new JCheckBox(I18n.tr("Fast drawing (looks uglier)", new Object[0]));
    private JosmTextField drawGpsArrowsMinDist = new JosmTextField(8);
    private JCheckBox colorDynamic = new JCheckBox(I18n.tr("Dynamic color range based on data limits", new Object[0]));
    private JosmComboBox<String> waypointLabel = new JosmComboBox<String>(LABEL_PATTERN_DESC);
    private JosmTextField waypointLabelPattern = new JosmTextField();
    private JosmComboBox<String> audioWaypointLabel = new JosmComboBox<String>(LABEL_PATTERN_DESC);
    private JosmTextField audioWaypointLabelPattern = new JosmTextField();
    private JCheckBox useGpsAntialiasing = new JCheckBox(I18n.tr("Smooth GPX graphics (antialiasing)", new Object[0]));
    private String layerName;
    private final boolean local;
    private final boolean nonlocal;

    public GPXSettingsPanel(String layerName, boolean local, boolean nonlocal) {
        super(new GridBagLayout());
        this.local = local;
        this.nonlocal = nonlocal;
        this.layerName = "layer " + layerName;
        this.initComponents();
        this.loadPreferences();
    }

    public GPXSettingsPanel() {
        super(new GridBagLayout());
        this.initComponents();
        this.local = false;
        this.nonlocal = false;
        this.loadPreferences();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.makeAutoMarkers.setToolTipText(I18n.tr("Automatically make a marker layer from any waypoints when opening a GPX layer.", new Object[0]));
        ExpertToggleAction.addVisibilitySwitcher(this.makeAutoMarkers);
        this.add((Component)this.makeAutoMarkers, GBC.eol().insets(20, 0, 0, 5));
        ButtonGroup gpsLinesGroup = new ButtonGroup();
        if (this.layerName != null) {
            gpsLinesGroup.add(this.drawRawGpsLinesGlobal);
        }
        gpsLinesGroup.add(this.drawRawGpsLinesNone);
        gpsLinesGroup.add(this.drawRawGpsLinesLocal);
        gpsLinesGroup.add(this.drawRawGpsLinesAll);
        JLabel label = new JLabel(I18n.tr("Draw lines between raw GPS points", new Object[0]));
        this.add((Component)label, GBC.eol().insets(20, 0, 0, 0));
        if (this.layerName != null) {
            this.add((Component)this.drawRawGpsLinesGlobal, GBC.eol().insets(40, 0, 0, 0));
        }
        this.add((Component)this.drawRawGpsLinesNone, GBC.eol().insets(40, 0, 0, 0));
        if (this.layerName == null || this.local) {
            this.add((Component)this.drawRawGpsLinesLocal, GBC.eol().insets(40, 0, 0, 0));
        }
        if (this.layerName == null || this.nonlocal) {
            this.add((Component)this.drawRawGpsLinesAll, GBC.eol().insets(40, 0, 0, 0));
        }
        ExpertToggleAction.addVisibilitySwitcher(label);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesGlobal);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesNone);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesLocal);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesAll);
        this.drawRawGpsLinesActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean f = GPXSettingsPanel.this.drawRawGpsLinesNone.isSelected() || GPXSettingsPanel.this.drawRawGpsLinesGlobal.isSelected();
                GPXSettingsPanel.this.forceRawGpsLines.setEnabled(!f);
                GPXSettingsPanel.this.drawRawGpsMaxLineLength.setEnabled(!f && !GPXSettingsPanel.this.drawRawGpsLinesLocal.isSelected());
                GPXSettingsPanel.this.drawRawGpsMaxLineLengthLocal.setEnabled(!f);
                GPXSettingsPanel.this.drawGpsArrows.setEnabled(!f);
                GPXSettingsPanel.this.drawGpsArrowsFast.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
                GPXSettingsPanel.this.drawGpsArrowsMinDist.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
            }
        };
        this.drawRawGpsLinesGlobal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesNone.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesLocal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesAll.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsMaxLineLengthLocal.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines for local files. Set to ''-1'' to draw all lines.", new Object[0]));
        label = new JLabel(I18n.tr("Maximum length for local files (meters)", new Object[0]));
        this.add((Component)label, GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawRawGpsMaxLineLengthLocal, GBC.eol().fill(2).insets(5, 0, 0, 5));
        ExpertToggleAction.addVisibilitySwitcher(label);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsMaxLineLengthLocal);
        this.drawRawGpsMaxLineLength.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines. Set to ''-1'' to draw all lines.", new Object[0]));
        label = new JLabel(I18n.tr("Maximum length (meters)", new Object[0]));
        this.add((Component)label, GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawRawGpsMaxLineLength, GBC.eol().fill(2).insets(5, 0, 0, 5));
        ExpertToggleAction.addVisibilitySwitcher(label);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsMaxLineLength);
        this.forceRawGpsLines.setToolTipText(I18n.tr("Force drawing of lines if the imported data contain no line information.", new Object[0]));
        this.add((Component)this.forceRawGpsLines, GBC.eop().insets(40, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.forceRawGpsLines);
        this.drawGpsArrows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPXSettingsPanel.this.drawGpsArrowsFast.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
                GPXSettingsPanel.this.drawGpsArrowsMinDist.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
            }
        });
        this.drawGpsArrows.setToolTipText(I18n.tr("Draw direction arrows for lines, connecting GPS points.", new Object[0]));
        this.add((Component)this.drawGpsArrows, GBC.eop().insets(40, 0, 0, 0));
        this.drawGpsArrowsFast.setToolTipText(I18n.tr("Draw the direction arrows using table lookups instead of complex math.", new Object[0]));
        this.add((Component)this.drawGpsArrowsFast, GBC.eop().insets(60, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.drawGpsArrowsFast);
        this.drawGpsArrowsMinDist.setToolTipText(I18n.tr("Do not draw arrows if they are not at least this distance away from the last one.", new Object[0]));
        this.add((Component)new JLabel(I18n.tr("Minimum distance (pixels)", new Object[0])), GBC.std().insets(60, 0, 0, 0));
        this.add((Component)this.drawGpsArrowsMinDist, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.hdopCircleGpsPoints.setToolTipText(I18n.tr("Draw a circle from HDOP value.", new Object[0]));
        this.add((Component)this.hdopCircleGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.hdopCircleGpsPoints);
        this.largeGpsPoints.setToolTipText(I18n.tr("Draw larger dots for the GPS points.", new Object[0]));
        this.add((Component)this.largeGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        this.drawLineWidth.setToolTipText(I18n.tr("Width of drawn GPX line (0 for default)", new Object[0]));
        this.add((Component)new JLabel(I18n.tr("Drawing width of GPX lines", new Object[0])), GBC.std().insets(20, 0, 0, 0));
        this.add((Component)this.drawLineWidth, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.useGpsAntialiasing.setToolTipText(I18n.tr("Apply antialiasing to the GPX lines resulting in a smoother appearance.", new Object[0]));
        this.add((Component)this.useGpsAntialiasing, GBC.eop().insets(20, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.useGpsAntialiasing);
        ButtonGroup colorGroup = new ButtonGroup();
        if (this.layerName != null) {
            colorGroup.add(this.colorTypeGlobal);
        }
        colorGroup.add(this.colorTypeNone);
        colorGroup.add(this.colorTypeVelocity);
        colorGroup.add(this.colorTypeDirection);
        colorGroup.add(this.colorTypeDilution);
        colorGroup.add(this.colorTypeTime);
        this.colorTypeVelocity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GPXSettingsPanel.this.colorTypeVelocityTune.setEnabled(GPXSettingsPanel.this.colorTypeVelocity.isSelected());
                GPXSettingsPanel.this.colorDynamic.setEnabled(GPXSettingsPanel.this.colorTypeVelocity.isSelected() || GPXSettingsPanel.this.colorTypeDilution.isSelected());
            }
        });
        this.colorTypeDilution.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GPXSettingsPanel.this.colorDynamic.setEnabled(GPXSettingsPanel.this.colorTypeVelocity.isSelected() || GPXSettingsPanel.this.colorTypeDilution.isSelected());
            }
        });
        this.colorTypeNone.setToolTipText(I18n.tr("All points and track segments will have the same color. Can be customized in Layer Manager.", new Object[0]));
        this.colorTypeVelocity.setToolTipText(I18n.tr("Colors points and track segments by velocity.", new Object[0]));
        this.colorTypeDirection.setToolTipText(I18n.tr("Colors points and track segments by direction.", new Object[0]));
        this.colorTypeDilution.setToolTipText(I18n.tr("Colors points and track segments by dilution of position (HDOP). Your capture device needs to log that information.", new Object[0]));
        this.colorTypeTime.setToolTipText(I18n.tr("Colors points and track segments by its timestamp.", new Object[0]));
        this.colorTypeVelocityTune.setToolTipText(I18n.tr("Allows to tune the track coloring for different average speeds.", new Object[0]));
        this.add(Box.createVerticalGlue(), GBC.eol().insets(0, 20, 0, 0));
        this.add((Component)new JLabel(I18n.tr("Track and Point Coloring", new Object[0])), GBC.eol().insets(20, 0, 0, 0));
        if (this.layerName != null) {
            this.add((Component)this.colorTypeGlobal, GBC.eol().insets(40, 0, 0, 0));
        }
        this.add((Component)this.colorTypeNone, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeVelocity, GBC.std().insets(40, 0, 0, 0));
        this.add(this.colorTypeVelocityTune, GBC.eop().insets(5, 0, 0, 5));
        this.add((Component)this.colorTypeDirection, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeDilution, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeTime, GBC.eol().insets(40, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.colorTypeDirection);
        ExpertToggleAction.addVisibilitySwitcher(this.colorTypeDilution);
        this.colorDynamic.setToolTipText(I18n.tr("Colors points and track segments by data limits.", new Object[0]));
        this.add((Component)this.colorDynamic, GBC.eop().insets(40, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.colorDynamic);
        if (this.layerName == null) {
            label = new JLabel(I18n.tr("Waypoint labelling", new Object[0]));
            this.add((Component)label, GBC.std().insets(20, 0, 0, 0));
            this.add(this.waypointLabel, GBC.eol().fill(2).insets(5, 0, 0, 5));
            this.waypointLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GPXSettingsPanel.this.updateWaypointPattern(GPXSettingsPanel.this.waypointLabel, GPXSettingsPanel.this.waypointLabelPattern);
                }
            });
            this.updateWaypointLabelCombobox(this.waypointLabel, this.waypointLabelPattern, Marker.TemplateEntryProperty.forMarker(this.layerName));
            this.add((Component)this.waypointLabelPattern, GBC.eol().fill(2).insets(20, 0, 0, 5));
            ExpertToggleAction.addVisibilitySwitcher(label);
            ExpertToggleAction.addVisibilitySwitcher(this.waypointLabel);
            ExpertToggleAction.addVisibilitySwitcher(this.waypointLabelPattern);
            Component glue = Box.createVerticalGlue();
            this.add(glue, GBC.eol().insets(0, 20, 0, 0));
            ExpertToggleAction.addVisibilitySwitcher(glue);
            label = new JLabel(I18n.tr("Audio waypoint labelling", new Object[0]));
            this.add((Component)label, GBC.std().insets(20, 0, 0, 0));
            this.add(this.audioWaypointLabel, GBC.eol().fill(2).insets(5, 0, 0, 5));
            this.audioWaypointLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GPXSettingsPanel.this.updateWaypointPattern(GPXSettingsPanel.this.audioWaypointLabel, GPXSettingsPanel.this.audioWaypointLabelPattern);
                }
            });
            this.updateWaypointLabelCombobox(this.audioWaypointLabel, this.audioWaypointLabelPattern, Marker.TemplateEntryProperty.forAudioMarker(this.layerName));
            this.add((Component)this.audioWaypointLabelPattern, GBC.eol().fill(2).insets(20, 0, 0, 5));
            ExpertToggleAction.addVisibilitySwitcher(label);
            ExpertToggleAction.addVisibilitySwitcher(this.audioWaypointLabel);
            ExpertToggleAction.addVisibilitySwitcher(this.audioWaypointLabelPattern);
        }
        this.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    public final void loadPreferences() {
        this.makeAutoMarkers.setSelected(Main.pref.getBoolean("marker.makeautomarkers", true));
        if (this.layerName != null && Main.pref.get("draw.rawgps.lines." + this.layerName).isEmpty() && Main.pref.get("draw.rawgps.lines.local." + this.layerName).isEmpty()) {
            this.drawRawGpsLinesGlobal.setSelected(true);
        } else {
            Boolean lf = Main.pref.getBoolean("draw.rawgps.lines.local", this.layerName, true);
            if (Main.pref.getBoolean("draw.rawgps.lines", this.layerName, true)) {
                this.drawRawGpsLinesAll.setSelected(true);
            } else if (lf.booleanValue()) {
                this.drawRawGpsLinesLocal.setSelected(true);
            } else {
                this.drawRawGpsLinesNone.setSelected(true);
            }
        }
        this.drawRawGpsMaxLineLengthLocal.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.max-line-length.local", this.layerName, -1)));
        this.drawRawGpsMaxLineLength.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.max-line-length", this.layerName, 200)));
        this.drawLineWidth.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.linewidth", this.layerName, 0)));
        this.forceRawGpsLines.setSelected(Main.pref.getBoolean("draw.rawgps.lines.force", this.layerName, false));
        this.drawGpsArrows.setSelected(Main.pref.getBoolean("draw.rawgps.direction", this.layerName, false));
        this.drawGpsArrowsFast.setSelected(Main.pref.getBoolean("draw.rawgps.alternatedirection", this.layerName, false));
        this.drawGpsArrowsMinDist.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.min-arrow-distance", this.layerName, 40)));
        this.hdopCircleGpsPoints.setSelected(Main.pref.getBoolean("draw.rawgps.hdopcircle", this.layerName, false));
        this.largeGpsPoints.setSelected(Main.pref.getBoolean("draw.rawgps.large", this.layerName, false));
        this.useGpsAntialiasing.setSelected(Main.pref.getBoolean("mappaint.gpx.use-antialiasing", false));
        this.drawRawGpsLinesActionListener.actionPerformed(null);
        if (this.layerName != null && Main.pref.get("draw.rawgps.colors." + this.layerName).isEmpty()) {
            this.colorTypeGlobal.setSelected(true);
            this.colorDynamic.setSelected(false);
            this.colorDynamic.setEnabled(false);
        } else {
            switch (Main.pref.getInteger("draw.rawgps.colors", this.layerName, 0)) {
                case 0: {
                    this.colorTypeNone.setSelected(true);
                    break;
                }
                case 1: {
                    this.colorTypeVelocity.setSelected(true);
                    break;
                }
                case 2: {
                    this.colorTypeDilution.setSelected(true);
                    break;
                }
                case 3: {
                    this.colorTypeDirection.setSelected(true);
                    break;
                }
                case 4: {
                    this.colorTypeTime.setSelected(true);
                }
            }
            int ccts = Main.pref.getInteger("draw.rawgps.colorTracksTune", this.layerName, 45);
            this.colorTypeVelocityTune.setSelectedIndex(ccts == 10 ? 2 : (ccts == 20 ? 1 : 0));
            this.colorTypeVelocityTune.setEnabled(this.colorTypeVelocity.isSelected() && this.colorTypeVelocity.isEnabled());
            this.colorDynamic.setSelected(Main.pref.getBoolean("draw.rawgps.colors.dynamic", this.layerName, false));
            this.colorDynamic.setEnabled(this.colorTypeVelocity.isSelected() || this.colorTypeDilution.isSelected());
        }
    }

    public boolean savePreferences(String layerName, boolean locLayer) {
        String layerNameDot = ".layer " + layerName;
        if (layerName == null) {
            layerNameDot = "";
        }
        Main.pref.put("marker.makeautomarkers" + layerNameDot, this.makeAutoMarkers.isSelected());
        if (this.drawRawGpsLinesGlobal.isSelected()) {
            Main.pref.put("draw.rawgps.lines" + layerNameDot, null);
            Main.pref.put("draw.rawgps.max-line-length" + layerNameDot, null);
            Main.pref.put("draw.rawgps.lines.local" + layerNameDot, null);
            Main.pref.put("draw.rawgps.max-line-length.local" + layerNameDot, null);
            Main.pref.put("draw.rawgps.lines.force" + layerNameDot, null);
            Main.pref.put("draw.rawgps.direction" + layerNameDot, null);
            Main.pref.put("draw.rawgps.alternatedirection" + layerNameDot, null);
            Main.pref.put("draw.rawgps.min-arrow-distance" + layerNameDot, null);
        } else {
            if (layerName == null || !locLayer) {
                Main.pref.put("draw.rawgps.lines" + layerNameDot, this.drawRawGpsLinesAll.isSelected());
                Main.pref.put("draw.rawgps.max-line-length" + layerNameDot, this.drawRawGpsMaxLineLength.getText());
            }
            if (layerName == null || locLayer) {
                Main.pref.put("draw.rawgps.lines.local" + layerNameDot, this.drawRawGpsLinesAll.isSelected() || this.drawRawGpsLinesLocal.isSelected());
                Main.pref.put("draw.rawgps.max-line-length.local" + layerNameDot, this.drawRawGpsMaxLineLengthLocal.getText());
            }
            Main.pref.put("draw.rawgps.lines.force" + layerNameDot, this.forceRawGpsLines.isSelected());
            Main.pref.put("draw.rawgps.direction" + layerNameDot, this.drawGpsArrows.isSelected());
            Main.pref.put("draw.rawgps.alternatedirection" + layerNameDot, this.drawGpsArrowsFast.isSelected());
            Main.pref.put("draw.rawgps.min-arrow-distance" + layerNameDot, this.drawGpsArrowsMinDist.getText());
        }
        Main.pref.put("draw.rawgps.hdopcircle" + layerNameDot, this.hdopCircleGpsPoints.isSelected());
        Main.pref.put("draw.rawgps.large" + layerNameDot, this.largeGpsPoints.isSelected());
        Main.pref.put("draw.rawgps.linewidth" + layerNameDot, this.drawLineWidth.getText());
        Main.pref.put("mappaint.gpx.use-antialiasing", this.useGpsAntialiasing.isSelected());
        Marker.TemplateEntryProperty.forMarker(layerName).put(this.waypointLabelPattern.getText());
        Marker.TemplateEntryProperty.forAudioMarker(layerName).put(this.audioWaypointLabelPattern.getText());
        if (this.colorTypeGlobal.isSelected()) {
            Main.pref.put("draw.rawgps.colors" + layerNameDot, null);
            Main.pref.put("draw.rawgps.colors.dynamic" + layerNameDot, null);
            Main.pref.put("draw.rawgps.colorTracksTunec" + layerNameDot, null);
            return false;
        }
        if (this.colorTypeVelocity.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + layerNameDot, 1);
        } else if (this.colorTypeDilution.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + layerNameDot, 2);
        } else if (this.colorTypeDirection.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + layerNameDot, 3);
        } else if (this.colorTypeTime.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + layerNameDot, 4);
        } else {
            Main.pref.putInteger("draw.rawgps.colors" + layerNameDot, 0);
        }
        Main.pref.put("draw.rawgps.colors.dynamic" + layerNameDot, this.colorDynamic.isSelected());
        int ccti = this.colorTypeVelocityTune.getSelectedIndex();
        Main.pref.putInteger("draw.rawgps.colorTracksTune" + layerNameDot, ccti == 2 ? 10 : (ccti == 1 ? 20 : 45));
        return false;
    }

    public boolean savePreferences() {
        return this.savePreferences(null, false);
    }

    private void updateWaypointLabelCombobox(JosmComboBox<String> cb, JosmTextField tf, Marker.TemplateEntryProperty property) {
        String labelPattern = property.getAsString();
        boolean found = false;
        for (int i = 0; i < LABEL_PATTERN_TEMPLATE.length; ++i) {
            if (!LABEL_PATTERN_TEMPLATE[i].equals(labelPattern)) continue;
            cb.setSelectedIndex(i);
            found = true;
            break;
        }
        if (!found) {
            cb.setSelectedIndex(6);
            tf.setEnabled(true);
            tf.setText(labelPattern);
        }
    }

    private void updateWaypointPattern(JosmComboBox<String> cb, JosmTextField tf) {
        if (cb.getSelectedIndex() == 6) {
            tf.setEnabled(true);
        } else {
            tf.setEnabled(false);
            tf.setText(LABEL_PATTERN_TEMPLATE[cb.getSelectedIndex()]);
        }
    }

    @Override
    public boolean validatePreferences() {
        TemplateParser parser = new TemplateParser(this.waypointLabelPattern.getText());
        try {
            parser.parse();
        }
        catch (ParseError e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Incorrect waypoint label pattern: {0}", e.getMessage()), I18n.tr("Incorrect pattern", new Object[0]), 0);
            this.waypointLabelPattern.requestFocus();
            return false;
        }
        parser = new TemplateParser(this.audioWaypointLabelPattern.getText());
        try {
            parser.parse();
        }
        catch (ParseError e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Incorrect audio waypoint label pattern: {0}", e.getMessage()), I18n.tr("Incorrect pattern", new Object[0]), 0);
            this.audioWaypointLabelPattern.requestFocus();
            return false;
        }
        return true;
    }
}

