/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.advanced.ListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.ListListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.MapListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.preferences.advanced.StringEditor;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PreferencesTable
extends JTable {
    private AllSettingsTableModel model;
    private final List<PrefEntry> displayData;

    public PreferencesTable(List<PrefEntry> displayData) {
        this.displayData = displayData;
        this.model = new AllSettingsTableModel();
        this.setModel(this.model);
        this.putClientProperty("terminateEditOnFocusLost", true);
        this.getColumnModel().getColumn(1).setCellRenderer(new SettingCellRenderer());
        this.getColumnModel().getColumn(1).setCellEditor(new SettingCellEditor());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PreferencesTable.this.editPreference(PreferencesTable.this);
                }
            }
        });
    }

    public void fireDataChanged() {
        this.model.fireTableDataChanged();
    }

    public List<PrefEntry> getSelectedItems() {
        ArrayList<PrefEntry> entries = new ArrayList<PrefEntry>();
        for (int row : this.getSelectedRows()) {
            PrefEntry p = (PrefEntry)this.model.getValueAt(row, -1);
            entries.add(p);
        }
        return entries;
    }

    public boolean editPreference(JComponent gui) {
        if (this.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(gui, I18n.tr("Please select the row to edit.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return false;
        }
        PrefEntry e = (PrefEntry)this.model.getValueAt(this.getSelectedRow(), 1);
        Preferences.Setting<?> stg = e.getValue();
        if (stg instanceof Preferences.StringSetting) {
            this.editCellAt(this.getSelectedRow(), 1);
            Component editor = this.getEditorComponent();
            if (editor != null) {
                editor.requestFocus();
            }
        } else if (stg instanceof Preferences.ListSetting) {
            List<String> data;
            Preferences.ListSetting lSetting = (Preferences.ListSetting)stg;
            ListEditor lEditor = new ListEditor(gui, e, lSetting);
            lEditor.showDialog();
            if (lEditor.getValue() == 1 && !lSetting.equalVal(data = lEditor.getData())) {
                e.setValue(new Preferences.ListSetting(data));
                return true;
            }
        } else if (stg instanceof Preferences.ListListSetting) {
            List<List<String>> data;
            Preferences.ListListSetting llSetting = (Preferences.ListListSetting)stg;
            ListListEditor llEditor = new ListListEditor(gui, e, llSetting);
            llEditor.showDialog();
            if (llEditor.getValue() == 1 && !llSetting.equalVal(data = llEditor.getData())) {
                e.setValue(new Preferences.ListListSetting(data));
                return true;
            }
        } else if (stg instanceof Preferences.MapListSetting) {
            List<Map<String, String>> data;
            Preferences.MapListSetting mlSetting = (Preferences.MapListSetting)stg;
            MapListEditor mlEditor = new MapListEditor(gui, e, mlSetting);
            mlEditor.showDialog();
            if (mlEditor.getValue() == 1 && !mlSetting.equalVal(data = mlEditor.getData())) {
                e.setValue(new Preferences.MapListSetting(data));
                return true;
            }
        }
        return false;
    }

    public PrefEntry addPreference(JComponent gui) {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std().insets(0, 0, 5, 0));
        JosmTextField tkey = new JosmTextField("", 50);
        p.add((Component)tkey, GBC.eop().insets(5, 0, 0, 0).fill(2));
        p.add((Component)new JLabel(I18n.tr("Select Setting Type:", new Object[0])), GBC.eol().insets(5, 15, 5, 0));
        JRadioButton rbString = new JRadioButton(I18n.tr("Simple", new Object[0]));
        JRadioButton rbList = new JRadioButton(I18n.tr("List", new Object[0]));
        JRadioButton rbListList = new JRadioButton(I18n.tr("List of lists", new Object[0]));
        JRadioButton rbMapList = new JRadioButton(I18n.tr("List of maps", new Object[0]));
        ButtonGroup group = new ButtonGroup();
        group.add(rbString);
        group.add(rbList);
        group.add(rbListList);
        group.add(rbMapList);
        p.add((Component)rbString, GBC.eol());
        p.add((Component)rbList, GBC.eol());
        p.add((Component)rbListList, GBC.eol());
        p.add((Component)rbMapList, GBC.eol());
        rbString.setSelected(true);
        ExtendedDialog dlg = new ExtendedDialog(gui, I18n.tr("Add setting", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
        dlg.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        dlg.setContent(p);
        dlg.showDialog();
        PrefEntry pe = null;
        boolean ok = false;
        if (dlg.getValue() == 1) {
            if (rbString.isSelected()) {
                Preferences.StringSetting sSetting = new Preferences.StringSetting(null);
                pe = new PrefEntry(tkey.getText(), sSetting, sSetting, false);
                StringEditor sEditor = new StringEditor(gui, pe, sSetting);
                sEditor.showDialog();
                if (sEditor.getValue() == 1) {
                    String data = sEditor.getData();
                    if (!Objects.equals(sSetting.getValue(), data)) {
                        pe.setValue(new Preferences.StringSetting(data));
                        ok = true;
                    }
                }
            } else if (rbList.isSelected()) {
                List<String> data;
                Preferences.ListSetting lSetting = new Preferences.ListSetting(null);
                pe = new PrefEntry(tkey.getText(), lSetting, lSetting, false);
                ListEditor lEditor = new ListEditor(gui, pe, lSetting);
                lEditor.showDialog();
                if (lEditor.getValue() == 1 && !lSetting.equalVal(data = lEditor.getData())) {
                    pe.setValue(new Preferences.ListSetting(data));
                    ok = true;
                }
            } else if (rbListList.isSelected()) {
                List<List<String>> data;
                Preferences.ListListSetting llSetting = new Preferences.ListListSetting(null);
                pe = new PrefEntry(tkey.getText(), llSetting, llSetting, false);
                ListListEditor llEditor = new ListListEditor(gui, pe, llSetting);
                llEditor.showDialog();
                if (llEditor.getValue() == 1 && !llSetting.equalVal(data = llEditor.getData())) {
                    pe.setValue(new Preferences.ListListSetting(data));
                    ok = true;
                }
            } else if (rbMapList.isSelected()) {
                List<Map<String, String>> data;
                Preferences.MapListSetting mlSetting = new Preferences.MapListSetting(null);
                pe = new PrefEntry(tkey.getText(), mlSetting, mlSetting, false);
                MapListEditor mlEditor = new MapListEditor(gui, pe, mlSetting);
                mlEditor.showDialog();
                if (mlEditor.getValue() == 1 && !mlSetting.equalVal(data = mlEditor.getData())) {
                    pe.setValue(new Preferences.MapListSetting(data));
                    ok = true;
                }
            }
        }
        if (ok) {
            return pe;
        }
        return null;
    }

    public void resetPreferences(JComponent gui) {
        if (this.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(gui, I18n.tr("Please select the row to delete.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        for (int row : this.getSelectedRows()) {
            PrefEntry e = this.displayData.get(row);
            e.reset();
        }
        this.fireDataChanged();
    }

    private static class SettingCellEditor
    extends DefaultCellEditor {
        public SettingCellEditor() {
            super(new JosmTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            PrefEntry pe = (PrefEntry)value;
            Preferences.StringSetting stg = (Preferences.StringSetting)pe.getValue();
            String s = stg.getValue() == null ? "" : (String)stg.getValue();
            return super.getTableCellEditorComponent(table, s, isSelected, row, column);
        }
    }

    private static class SettingCellRenderer
    extends DefaultTableCellRenderer {
        private Color backgroundColor = Main.pref.getUIColor("Table.background");
        private Color changedColor = Main.pref.getColor(I18n.marktr("Advanced Background: Changed"), new Color(200, 255, 200));
        private Color foregroundColor = Main.pref.getUIColor("Table.foreground");
        private Color nonDefaultColor = Main.pref.getColor(I18n.marktr("Advanced Background: NonDefault"), new Color(255, 255, 200));

        private SettingCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            PrefEntry pe = (PrefEntry)value;
            Preferences.Setting<?> setting = pe.getValue();
            Object val = setting.getValue();
            String display = val != null ? val.toString() : "<html><i>&lt;" + I18n.tr("unset", new Object[0]) + "&gt;</i></html>";
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, display, isSelected, hasFocus, row, column);
            label.setBackground(this.backgroundColor);
            if (isSelected) {
                label.setForeground(this.foregroundColor);
            }
            if (pe.isChanged()) {
                label.setBackground(this.changedColor);
            } else if (!pe.isDefault()) {
                label.setBackground(this.nonDefaultColor);
            }
            if (!pe.isDefault()) {
                label.setFont(label.getFont().deriveFont(1));
            }
            if ((val = pe.getDefaultValue().getValue()) != null) {
                if (pe.isDefault()) {
                    label.setToolTipText(I18n.tr("Current value is default.", new Object[0]));
                } else {
                    label.setToolTipText(I18n.tr("Default value is ''{0}''.", val));
                }
            } else {
                label.setToolTipText(I18n.tr("Default value currently unknown (setting has not been used yet).", new Object[0]));
            }
            return label;
        }
    }

    private class AllSettingsTableModel
    extends DefaultTableModel {
        public AllSettingsTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1 && ((PrefEntry)PreferencesTable.this.displayData.get(row)).getValue() instanceof Preferences.StringSetting;
        }

        @Override
        public int getRowCount() {
            return PreferencesTable.this.displayData.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return ((PrefEntry)PreferencesTable.this.displayData.get(row)).getKey();
            }
            return PreferencesTable.this.displayData.get(row);
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            String s = (String)o;
            PrefEntry pe = (PrefEntry)PreferencesTable.this.displayData.get(row);
            if (!s.equals(pe.getValue().getValue())) {
                pe.setValue(new Preferences.StringSetting(s));
                this.fireTableCellUpdated(row, column);
            }
        }
    }
}

