/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class PrefEntry
implements Comparable<PrefEntry> {
    private String key;
    private Preferences.Setting<?> value;
    private Preferences.Setting<?> defaultValue;
    private boolean isDefault;
    private boolean changed;

    public PrefEntry(String key, Preferences.Setting<?> value, Preferences.Setting<?> defaultValue, boolean isDefault) {
        CheckParameterUtil.ensureParameterNotNull(key);
        CheckParameterUtil.ensureParameterNotNull(value);
        CheckParameterUtil.ensureParameterNotNull(defaultValue);
        this.key = key;
        this.value = value;
        this.defaultValue = defaultValue;
        this.isDefault = isDefault;
    }

    public String getKey() {
        return this.key;
    }

    public Preferences.Setting<?> getValue() {
        return this.value;
    }

    public Preferences.Setting<?> getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(Preferences.Setting<?> value) {
        this.value = value;
        this.changed = true;
        this.isDefault = false;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void markAsChanged() {
        this.changed = true;
    }

    public void reset() {
        this.value = this.defaultValue;
        this.changed = true;
        this.isDefault = true;
    }

    @Override
    public int compareTo(PrefEntry other) {
        return this.key.compareTo(other.key);
    }

    public String toString() {
        return this.value.toString();
    }
}

