/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class MapListEditor
extends ExtendedDialog {
    EntryListModel entryModel;
    PrefEntry entry;
    JList<String> entryList;
    JTable table;
    MapTableModel tableModel;
    List<List<String>> dataKeys;
    List<List<String>> dataValues;
    Integer entryIdx;

    public MapListEditor(JComponent gui, PrefEntry entry, Preferences.MapListSetting setting) {
        super(gui, I18n.tr("Change list of maps setting", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.entry = entry;
        List orig = (List)setting.getValue();
        this.dataKeys = new ArrayList<List<String>>();
        this.dataValues = new ArrayList<List<String>>();
        if (orig != null) {
            for (Map m : orig) {
                ArrayList keys = new ArrayList();
                ArrayList values = new ArrayList();
                for (Map.Entry e : m.entrySet()) {
                    keys.add(e.getKey());
                    values.add(e.getValue());
                }
                this.dataKeys.add(keys);
                this.dataValues.add(values);
            }
        }
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(gui, new Dimension(500, 350)));
        this.setContent(this.build(), false);
    }

    public List<Map<String, String>> getData() {
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        for (int i = 0; i < this.dataKeys.size(); ++i) {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            for (int j = 0; j < this.dataKeys.get(i).size(); ++j) {
                m.put(this.dataKeys.get(i).get(j), this.dataValues.get(i).get(j));
            }
            data.add(m);
        }
        return data;
    }

    protected final JPanel build() {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Key: {0}", this.entry.getKey())), GBC.std(0, 0).span(2).weight(1.0, 0.0).insets(0, 0, 5, 10));
        JPanel left = new JPanel(new GridBagLayout());
        this.entryModel = new EntryListModel();
        this.entryList = new JList<String>(this.entryModel);
        this.entryList.getSelectionModel().addListSelectionListener(new EntryListener());
        JScrollPane scroll = new JScrollPane(this.entryList);
        left.add((Component)scroll, GBC.eol().fill());
        JToolBar sideButtonTB = new JToolBar(0);
        sideButtonTB.setBorderPainted(false);
        sideButtonTB.setOpaque(false);
        sideButtonTB.add(new NewEntryAction());
        RemoveEntryAction removeEntryAction = new RemoveEntryAction();
        this.entryList.getSelectionModel().addListSelectionListener(removeEntryAction);
        sideButtonTB.add(removeEntryAction);
        left.add((Component)sideButtonTB, GBC.eol());
        left.setPreferredSize(new Dimension(80, 0));
        p.add((Component)left, GBC.std(0, 1).fill().weight(0.3, 1.0));
        this.tableModel = new MapTableModel();
        this.table = new JTable(this.tableModel);
        this.table.putClientProperty("terminateEditOnFocusLost", true);
        this.table.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(I18n.tr("Key", new Object[0]));
        this.table.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(I18n.tr("Value", new Object[0]));
        DefaultCellEditor editor = new DefaultCellEditor(new JosmTextField());
        editor.setClickCountToStart(1);
        this.table.setDefaultEditor(this.table.getColumnClass(0), editor);
        JScrollPane pane = new JScrollPane(this.table);
        pane.setPreferredSize(new Dimension(140, 0));
        p.add((Component)pane, GBC.std(1, 1).insets(5, 0, 0, 0).fill().weight(0.7, 1.0));
        return p;
    }

    class MapTableModel
    extends AbstractTableModel {
        MapTableModel() {
        }

        private List<List<String>> data() {
            if (MapListEditor.this.entryIdx == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(MapListEditor.this.dataKeys.get(MapListEditor.this.entryIdx), MapListEditor.this.dataValues.get(MapListEditor.this.entryIdx));
        }

        private int size() {
            if (MapListEditor.this.entryIdx == null) {
                return 0;
            }
            return MapListEditor.this.dataKeys.get(MapListEditor.this.entryIdx).size();
        }

        @Override
        public int getRowCount() {
            return MapListEditor.this.entryIdx == null ? 0 : this.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? I18n.tr("Key", new Object[0]) : I18n.tr("Value", new Object[0]);
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.size() == row ? "" : this.data().get(column).get(row);
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            String s = (String)o;
            if (row == this.size()) {
                this.data().get(0).add("");
                this.data().get(1).add("");
                this.data().get(column).set(row, s);
                this.fireTableRowsInserted(row + 1, row + 1);
            } else {
                this.data().get(column).set(row, s);
                this.fireTableCellUpdated(row, column);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }

    class EntryListener
    implements ListSelectionListener {
        EntryListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            TableCellEditor editor = MapListEditor.this.table.getCellEditor();
            if (editor != null) {
                ((DefaultCellEditor)editor).stopCellEditing();
            }
            if (MapListEditor.this.entryList.getSelectedIndices().length != 1) {
                MapListEditor.this.entryIdx = null;
                MapListEditor.this.table.setEnabled(false);
            } else {
                MapListEditor.this.entryIdx = MapListEditor.this.entryList.getSelectedIndices()[0];
                MapListEditor.this.table.setEnabled(true);
            }
            MapListEditor.this.tableModel.fireTableDataChanged();
        }
    }

    class RemoveEntryAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveEntryAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Remove the selected entry", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(MapListEditor.this.entryList.getSelectedIndices().length == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int idx = MapListEditor.this.entryList.getSelectedIndices()[0];
            MapListEditor.this.entryModel.remove(idx);
        }
    }

    class NewEntryAction
    extends AbstractAction {
        public NewEntryAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("add entry", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MapListEditor.this.entryModel.add();
        }
    }

    class EntryListModel
    extends AbstractListModel<String> {
        EntryListModel() {
        }

        @Override
        public String getElementAt(int index) {
            return I18n.tr("Entry {0}", index + 1);
        }

        @Override
        public int getSize() {
            return MapListEditor.this.dataKeys.size();
        }

        public void add() {
            MapListEditor.this.dataKeys.add(new ArrayList());
            MapListEditor.this.dataValues.add(new ArrayList());
            this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        }

        public void remove(int idx) {
            MapListEditor.this.dataKeys.remove(idx);
            MapListEditor.this.dataValues.remove(idx);
            this.fireIntervalRemoved(this, idx, idx);
        }
    }
}

