/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ListEditor
extends ExtendedDialog {
    List<String> data;
    PrefEntry entry;

    public ListEditor(JComponent gui, PrefEntry entry, Preferences.ListSetting setting) {
        super(gui, I18n.tr("Change list setting", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.entry = entry;
        List orig = (List)setting.getValue();
        this.data = orig != null ? new ArrayList<String>(orig) : new ArrayList<String>();
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(gui, new Dimension(300, 350)));
        this.setContent(this.build(), false);
    }

    public List<String> getData() {
        return new ArrayList<String>(Utils.filter(this.data, new Predicate<String>(){

            @Override
            public boolean evaluate(String object) {
                return object != null && !object.isEmpty();
            }
        }));
    }

    protected final JPanel build() {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Key: {0}", this.entry.getKey())), GBC.eol().insets(0, 0, 5, 0));
        ListSettingTableModel listModel = new ListSettingTableModel();
        JTable table = new JTable(listModel);
        table.putClientProperty("terminateEditOnFocusLost", true);
        table.setTableHeader(null);
        DefaultCellEditor editor = new DefaultCellEditor(new JosmTextField());
        editor.setClickCountToStart(1);
        table.setDefaultEditor(table.getColumnClass(0), editor);
        JScrollPane pane = new JScrollPane(table);
        p.add((Component)pane, GBC.eol().insets(5, 10, 0, 0).fill());
        return p;
    }

    class ListSettingTableModel
    extends AbstractTableModel {
        ListSettingTableModel() {
        }

        public List<String> getData() {
            return ListEditor.this.data;
        }

        @Override
        public int getRowCount() {
            return ListEditor.this.data.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return ListEditor.this.data.size() == row ? "" : ListEditor.this.data.get(row);
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            String s = (String)o;
            if (row == ListEditor.this.data.size()) {
                ListEditor.this.data.add(s);
                this.fireTableRowsInserted(row + 1, row + 1);
            } else {
                ListEditor.this.data.set(row, s);
            }
            this.fireTableCellUpdated(row, column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

