/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.io.File;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.Utils;

public class SourceEntry {
    public String url;
    public boolean isZip;
    public String zipEntryPath;
    public String name;
    public String title;
    public boolean active;

    public SourceEntry(String url, boolean isZip, String zipEntryPath, String name, String title, boolean active) {
        this.url = url;
        this.isZip = isZip;
        this.zipEntryPath = "".equals(zipEntryPath) ? null : zipEntryPath;
        this.name = "".equals(name) ? null : name;
        this.title = "".equals(title) ? null : title;
        this.active = active;
    }

    public SourceEntry(String url, String name, String title, Boolean active) {
        this(url, false, null, name, title, active);
    }

    public SourceEntry(SourceEntry e) {
        this.url = e.url;
        this.isZip = e.isZip;
        this.zipEntryPath = e.zipEntryPath;
        this.name = e.name;
        this.title = e.title;
        this.active = e.active;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceEntry other = (SourceEntry)obj;
        return Objects.equals(other.url, this.url) && other.isZip == this.isZip && Objects.equals(other.zipEntryPath, this.zipEntryPath) && Objects.equals(other.name, this.name) && Objects.equals(other.title, this.title) && other.active == this.active;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.url != null ? this.url.hashCode() : 0);
        hash = 89 * hash + (this.isZip ? 1 : 0);
        hash = 89 * hash + (this.zipEntryPath != null ? this.zipEntryPath.hashCode() : 0);
        hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 89 * hash + (this.title != null ? this.title.hashCode() : 0);
        hash = 89 * hash + (this.active ? 1 : 0);
        return hash;
    }

    public String toString() {
        return this.title != null ? this.title : this.url;
    }

    public String getDisplayString() {
        if (this.title != null) {
            return this.title;
        }
        return this.getFileNamePart();
    }

    public String getFileNamePart() {
        Pattern p = Pattern.compile("([^/\\\\]*?)([?].*)?$");
        Matcher m = p.matcher(this.url);
        if (m.find()) {
            return m.group(1);
        }
        Main.warn("Unexpected URL format: " + this.url);
        return this.url;
    }

    public String getPrefName() {
        return this.name == null ? "standard" : this.name;
    }

    public boolean isLocal() {
        return Utils.isLocalUrl(this.url);
    }

    public File getLocalSourceDir() {
        if (!this.isLocal()) {
            return null;
        }
        return new File(this.url).getParentFile();
    }

    public String getZipEntryDirName() {
        if (this.zipEntryPath == null) {
            return null;
        }
        File file = new File(this.zipEntryPath);
        File dir = file.getParentFile();
        if (dir == null) {
            return ".";
        }
        String path = dir.getPath();
        if (!"/".equals(File.separator)) {
            path = path.replace(File.separator, "/");
        }
        return path;
    }
}

