/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.SourceProvider;
import org.openstreetmap.josm.gui.preferences.SourceType;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public abstract class SourceEditor
extends JPanel {
    protected final SourceType sourceType;
    protected final boolean canEnable;
    protected final JTable tblActiveSources;
    protected final ActiveSourcesModel activeSourcesModel;
    protected final JList<ExtendedSourceEntry> lstAvailableSources;
    protected final AvailableSourcesListModel availableSourcesModel;
    protected final String availableSourcesUrl;
    protected final List<SourceProvider> sourceProviders;
    protected JTable tblIconPaths;
    protected IconPathTableModel iconPathsModel;
    protected boolean sourcesInitiallyLoaded;

    public SourceEditor(SourceType sourceType, String availableSourcesUrl, List<SourceProvider> sourceProviders, boolean handleIcons) {
        this.sourceType = sourceType;
        this.canEnable = sourceType.equals((Object)SourceType.MAP_PAINT_STYLE) || sourceType.equals((Object)SourceType.TAGCHECKER_RULE);
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.availableSourcesModel = new AvailableSourcesListModel(selectionModel);
        this.lstAvailableSources = new JList<ExtendedSourceEntry>(this.availableSourcesModel);
        this.lstAvailableSources.setSelectionModel(selectionModel);
        this.lstAvailableSources.setCellRenderer(new SourceEntryListCellRenderer());
        this.availableSourcesUrl = availableSourcesUrl;
        this.sourceProviders = sourceProviders;
        selectionModel = new DefaultListSelectionModel();
        this.activeSourcesModel = new ActiveSourcesModel(selectionModel);
        this.tblActiveSources = new JTable(this.activeSourcesModel){

            @Override
            public void scrollRectToVisible(Rectangle aRect) {
                super.scrollRectToVisible(new Rectangle(0, aRect.y, aRect.width, aRect.height));
            }
        };
        this.tblActiveSources.putClientProperty("terminateEditOnFocusLost", true);
        this.tblActiveSources.setSelectionModel(selectionModel);
        this.tblActiveSources.setSelectionMode(2);
        this.tblActiveSources.setShowGrid(false);
        this.tblActiveSources.setIntercellSpacing(new Dimension(0, 0));
        this.tblActiveSources.setTableHeader(null);
        this.tblActiveSources.setAutoResizeMode(0);
        SourceEntryTableCellRenderer sourceEntryRenderer = new SourceEntryTableCellRenderer();
        if (this.canEnable) {
            this.tblActiveSources.getColumnModel().getColumn(0).setMaxWidth(1);
            this.tblActiveSources.getColumnModel().getColumn(0).setResizable(false);
            this.tblActiveSources.getColumnModel().getColumn(1).setCellRenderer(sourceEntryRenderer);
        } else {
            this.tblActiveSources.getColumnModel().getColumn(0).setCellRenderer(sourceEntryRenderer);
        }
        this.activeSourcesModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableHelper.adjustColumnWidth(SourceEditor.this.tblActiveSources, SourceEditor.this.canEnable ? 1 : 0, 800);
            }
        });
        this.activeSourcesModel.setActiveSources(this.getInitialSourcesList());
        final EditActiveSourceAction editActiveSourceAction = new EditActiveSourceAction();
        this.tblActiveSources.getSelectionModel().addListSelectionListener(editActiveSourceAction);
        this.tblActiveSources.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = SourceEditor.this.tblActiveSources.rowAtPoint(e.getPoint());
                    int col = SourceEditor.this.tblActiveSources.columnAtPoint(e.getPoint());
                    if (row < 0 || row >= SourceEditor.this.tblActiveSources.getRowCount()) {
                        return;
                    }
                    if (SourceEditor.this.canEnable && col != 1) {
                        return;
                    }
                    editActiveSourceAction.actionPerformed(null);
                }
            }
        });
        RemoveActiveSourcesAction removeActiveSourcesAction = new RemoveActiveSourcesAction();
        this.tblActiveSources.getSelectionModel().addListSelectionListener(removeActiveSourcesAction);
        this.tblActiveSources.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.tblActiveSources.getActionMap().put("delete", removeActiveSourcesAction);
        MoveUpDownAction moveUp = null;
        MoveUpDownAction moveDown = null;
        if (sourceType.equals((Object)SourceType.MAP_PAINT_STYLE)) {
            moveUp = new MoveUpDownAction(false);
            moveDown = new MoveUpDownAction(true);
            this.tblActiveSources.getSelectionModel().addListSelectionListener(moveUp);
            this.tblActiveSources.getSelectionModel().addListSelectionListener(moveDown);
            this.activeSourcesModel.addTableModelListener(moveUp);
            this.activeSourcesModel.addTableModelListener(moveDown);
        }
        ActivateSourcesAction activateSourcesAction = new ActivateSourcesAction();
        this.lstAvailableSources.addListSelectionListener(activateSourcesAction);
        JButton activate = new JButton(activateSourcesAction);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 11, 0, 0);
        this.add((Component)new JLabel(this.getStr(I18nString.AVAILABLE_SOURCES)), gbc);
        gbc.gridx = 2;
        gbc.insets = new Insets(5, 0, 0, 6);
        this.add((Component)new JLabel(this.getStr(I18nString.ACTIVE_SOURCES)), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 0.8;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 11, 0, 0);
        JScrollPane sp1 = new JScrollPane(this.lstAvailableSources);
        this.add((Component)sp1, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        JToolBar middleTB = new JToolBar();
        middleTB.setFloatable(false);
        middleTB.setBorderPainted(false);
        middleTB.setOpaque(false);
        middleTB.add(Box.createHorizontalGlue());
        middleTB.add(activate);
        middleTB.add(Box.createHorizontalGlue());
        this.add((Component)middleTB, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.5;
        gbc.fill = 1;
        JScrollPane sp = new JScrollPane(this.tblActiveSources);
        this.add((Component)sp, gbc);
        sp.setColumnHeaderView(null);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 6);
        JToolBar sideButtonTB = new JToolBar(1);
        sideButtonTB.setFloatable(false);
        sideButtonTB.setBorderPainted(false);
        sideButtonTB.setOpaque(false);
        sideButtonTB.add(new NewActiveSourceAction());
        sideButtonTB.add(editActiveSourceAction);
        sideButtonTB.add(removeActiveSourcesAction);
        sideButtonTB.addSeparator(new Dimension(12, 30));
        if (sourceType.equals((Object)SourceType.MAP_PAINT_STYLE)) {
            sideButtonTB.add(moveUp);
            sideButtonTB.add(moveDown);
        }
        this.add((Component)sideButtonTB, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 11, 0, 0);
        JToolBar bottomLeftTB = new JToolBar();
        bottomLeftTB.setFloatable(false);
        bottomLeftTB.setBorderPainted(false);
        bottomLeftTB.setOpaque(false);
        bottomLeftTB.add(new ReloadSourcesAction(availableSourcesUrl, sourceProviders));
        bottomLeftTB.add(Box.createHorizontalGlue());
        this.add((Component)bottomLeftTB, gbc);
        gbc.gridx = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 0);
        JToolBar bottomRightTB = new JToolBar();
        bottomRightTB.setFloatable(false);
        bottomRightTB.setBorderPainted(false);
        bottomRightTB.setOpaque(false);
        bottomRightTB.add(Box.createHorizontalGlue());
        bottomRightTB.add(new JButton(new ResetAction()));
        this.add((Component)bottomRightTB, gbc);
        if (handleIcons) {
            this.buildIcons(gbc);
        }
    }

    private void buildIcons(GridBagConstraints gbc) {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.iconPathsModel = new IconPathTableModel(selectionModel);
        this.tblIconPaths = new JTable(this.iconPathsModel);
        this.tblIconPaths.setSelectionModel(selectionModel);
        this.tblIconPaths.setSelectionMode(2);
        this.tblIconPaths.setTableHeader(null);
        this.tblIconPaths.getColumnModel().getColumn(0).setCellEditor(new FileOrUrlCellEditor(false));
        this.tblIconPaths.setRowHeight(20);
        this.tblIconPaths.putClientProperty("terminateEditOnFocusLost", true);
        this.iconPathsModel.setIconPaths(this.getInitialIconPathsList());
        EditIconPathAction editIconPathAction = new EditIconPathAction();
        this.tblIconPaths.getSelectionModel().addListSelectionListener(editIconPathAction);
        RemoveIconPathAction removeIconPathAction = new RemoveIconPathAction();
        this.tblIconPaths.getSelectionModel().addListSelectionListener(removeIconPathAction);
        this.tblIconPaths.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.tblIconPaths.getActionMap().put("delete", removeIconPathAction);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(8, 11, 8, 6);
        this.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 11, 0, 6);
        this.add((Component)new JLabel(I18n.tr("Icon paths:", new Object[0])), gbc);
        ++gbc.gridy;
        gbc.weighty = 0.2;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 11, 0, 0);
        JScrollPane sp = new JScrollPane(this.tblIconPaths);
        this.add((Component)sp, gbc);
        sp.setColumnHeaderView(null);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 6);
        JToolBar sideButtonTBIcons = new JToolBar(1);
        sideButtonTBIcons.setFloatable(false);
        sideButtonTBIcons.setBorderPainted(false);
        sideButtonTBIcons.setOpaque(false);
        sideButtonTBIcons.add(new NewIconPathAction());
        sideButtonTBIcons.add(editIconPathAction);
        sideButtonTBIcons.add(removeIconPathAction);
        this.add((Component)sideButtonTBIcons, gbc);
    }

    public abstract Collection<? extends SourceEntry> getInitialSourcesList();

    public abstract Collection<String> getInitialIconPathsList();

    public abstract Collection<ExtendedSourceEntry> getDefault();

    public abstract boolean finish();

    protected abstract String getStr(I18nString var1);

    public boolean hasActiveSourcesChanged() {
        Collection<? extends SourceEntry> prev = this.getInitialSourcesList();
        List<SourceEntry> cur = this.activeSourcesModel.getSources();
        if (prev.size() != cur.size()) {
            return true;
        }
        Iterator<? extends SourceEntry> p = prev.iterator();
        Iterator<SourceEntry> c = cur.iterator();
        while (p.hasNext()) {
            SourceEntry pe = p.next();
            SourceEntry ce = c.next();
            if (Objects.equals(pe.url, ce.url) && Objects.equals(pe.name, ce.name) && pe.active == ce.active) continue;
            return true;
        }
        return false;
    }

    public Collection<SourceEntry> getActiveSources() {
        return this.activeSourcesModel.getSources();
    }

    public void removeSources(Collection<Integer> idxs) {
        this.activeSourcesModel.removeIdxs(idxs);
    }

    protected void reloadAvailableSources(String url, List<SourceProvider> sourceProviders) {
        Main.worker.submit(new SourceLoader(url, sourceProviders));
    }

    public void initiallyLoadAvailableSources() {
        if (!this.sourcesInitiallyLoaded) {
            this.reloadAvailableSources(this.availableSourcesUrl, this.sourceProviders);
        }
        this.sourcesInitiallyLoaded = true;
    }

    private static void prepareFileChooser(String url, AbstractFileChooser fc) {
        if (url == null || url.trim().length() == 0) {
            return;
        }
        URL sourceUrl = null;
        try {
            sourceUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            File f = new File(url);
            if (f.isFile()) {
                f = f.getParentFile();
            }
            if (f != null) {
                fc.setCurrentDirectory(f);
            }
            return;
        }
        if (sourceUrl.getProtocol().startsWith("file")) {
            File f = new File(sourceUrl.getPath());
            if (f.isFile()) {
                f = f.getParentFile();
            }
            if (f != null) {
                fc.setCurrentDirectory(f);
            }
        }
    }

    public final void deferLoading(final DefaultTabPreferenceSetting tab, final Component component) {
        tab.getTabPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (tab.getTabPane().getSelectedComponent() == component) {
                    SourceEditor.this.initiallyLoadAvailableSources();
                }
            }
        });
    }

    public static abstract class SourcePrefHelper {
        private final String pref;

        public SourcePrefHelper(String pref2) {
            this.pref = pref2;
        }

        public abstract Collection<ExtendedSourceEntry> getDefault();

        public abstract Map<String, String> serialize(SourceEntry var1);

        public abstract SourceEntry deserialize(Map<String, String> var1);

        public List<SourceEntry> get() {
            Collection<Map<String, String>> src = Main.pref.getListOfStructs(this.pref, (Collection<Map<String, String>>)null);
            if (src == null) {
                return new ArrayList<SourceEntry>(this.getDefault());
            }
            ArrayList<SourceEntry> entries = new ArrayList<SourceEntry>();
            for (Map<String, String> sourcePref : src) {
                SourceEntry e = this.deserialize(new HashMap<String, String>(sourcePref));
                if (e == null) continue;
                entries.add(e);
            }
            return entries;
        }

        public boolean put(Collection<? extends SourceEntry> entries) {
            ArrayList<Map<String, String>> setting = new ArrayList<Map<String, String>>(entries.size());
            for (SourceEntry sourceEntry : entries) {
                setting.add(this.serialize(sourceEntry));
            }
            return Main.pref.putListOfStructs(this.pref, setting);
        }

        public final Set<String> getActiveUrls() {
            HashSet<String> urls = new HashSet<String>();
            for (SourceEntry e : this.get()) {
                if (!e.active) continue;
                urls.add(e.url);
            }
            return urls;
        }
    }

    class FileOrUrlCellEditor
    extends JPanel
    implements TableCellEditor {
        private JosmTextField tfFileName;
        private CopyOnWriteArrayList<CellEditorListener> listeners;
        private String value;
        private boolean isFile;

        protected final void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.tfFileName = new JosmTextField();
            this.add((Component)this.tfFileName, gc);
            gc.gridx = 1;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 0.0;
            gc.weighty = 1.0;
            this.add(new JButton(new LaunchFileChooserAction()));
            this.tfFileName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    FileOrUrlCellEditor.this.tfFileName.selectAll();
                }
            });
        }

        public FileOrUrlCellEditor(boolean isFile) {
            this.isFile = isFile;
            this.listeners = new CopyOnWriteArrayList();
            this.build();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            if (l != null) {
                this.listeners.addIfAbsent(l);
            }
        }

        protected void fireEditingCanceled() {
            for (CellEditorListener l : this.listeners) {
                l.editingCanceled(new ChangeEvent(this));
            }
        }

        protected void fireEditingStopped() {
            for (CellEditorListener l : this.listeners) {
                l.editingStopped(new ChangeEvent(this));
            }
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.remove(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.value = this.tfFileName.getText();
            this.fireEditingStopped();
            return true;
        }

        public void setInitialValue(String initialValue) {
            this.value = initialValue;
            if (initialValue == null) {
                this.tfFileName.setText("");
            } else {
                this.tfFileName.setText(initialValue);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.setInitialValue((String)value);
            this.tfFileName.selectAll();
            return this;
        }

        class LaunchFileChooserAction
        extends AbstractAction {
            public LaunchFileChooserAction() {
                this.putValue("Name", "...");
                this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserManager fcm = new FileChooserManager(true).createFileChooser();
                if (!FileOrUrlCellEditor.this.isFile) {
                    fcm.getFileChooser().setFileSelectionMode(1);
                }
                SourceEditor.prepareFileChooser(FileOrUrlCellEditor.this.tfFileName.getText(), fcm.getFileChooser());
                AbstractFileChooser fc = fcm.openFileChooser(JOptionPane.getFrameForComponent(SourceEditor.this));
                if (fc != null) {
                    FileOrUrlCellEditor.this.tfFileName.setText(fc.getSelectedFile().toString());
                }
            }
        }
    }

    static class SourceEntryTableCellRenderer
    extends DefaultTableCellRenderer {
        SourceEntryTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            return super.getTableCellRendererComponent(table, this.fromSourceEntry((SourceEntry)value), isSelected, hasFocus, row, column);
        }

        private String fromSourceEntry(SourceEntry entry) {
            if (entry == null) {
                return null;
            }
            StringBuilder s = new StringBuilder("<html><b>");
            if (entry.title != null) {
                s.append(entry.title).append("</b> <span color=\"gray\">");
            }
            s.append(entry.url);
            if (entry.title != null) {
                s.append("</span>");
            }
            s.append("</html>");
            return s.toString();
        }
    }

    class SourceLoader
    extends PleaseWaitRunnable {
        private final String url;
        private final List<SourceProvider> sourceProviders;
        private BufferedReader reader;
        private boolean canceled;
        private final List<ExtendedSourceEntry> sources;

        public SourceLoader(String url, List<SourceProvider> sourceProviders) {
            super(I18n.tr(SourceEditor.this.getStr(I18nString.LOADING_SOURCES_FROM), url));
            this.sources = new ArrayList<ExtendedSourceEntry>();
            this.url = url;
            this.sourceProviders = sourceProviders;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            Utils.close(this.reader);
        }

        protected void warn(Exception e) {
            String emsg = e.getMessage() != null ? e.getMessage() : e.toString();
            emsg = emsg.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            final String msg = I18n.tr(SourceEditor.this.getStr(I18nString.FAILED_TO_LOAD_SOURCES_FROM), this.url, emsg);
            GuiHelper.runInEDT(new Runnable(){

                @Override
                public void run() {
                    HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Error", new Object[0]), 0, HelpUtil.ht(SourceEditor.this.getStr(I18nString.FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC)));
                }
            });
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            String lang = LanguageInfo.getLanguageCodeXML();
            try {
                String line;
                this.sources.addAll(SourceEditor.this.getDefault());
                for (SourceProvider provider : this.sourceProviders) {
                    for (SourceEntry src : provider.getSources()) {
                        if (!(src instanceof ExtendedSourceEntry)) continue;
                        this.sources.add((ExtendedSourceEntry)src);
                    }
                }
                InputStream stream = new CachedFile(this.url).getInputStream();
                this.reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                ExtendedSourceEntry last = null;
                while ((line = this.reader.readLine()) != null && !this.canceled) {
                    Matcher m;
                    if (line.trim().isEmpty()) continue;
                    if (line.startsWith("\t")) {
                        m = Pattern.compile("^\t([^:]+): *(.+)$").matcher(line);
                        if (!m.matches()) {
                            Main.error(I18n.tr(SourceEditor.this.getStr(I18nString.ILLEGAL_FORMAT_OF_ENTRY), this.url, line));
                            continue;
                        }
                        if (last == null) continue;
                        String key = m.group(1);
                        String value = m.group(2);
                        if ("author".equals(key) && last.author == null) {
                            last.author = value;
                            continue;
                        }
                        if ("version".equals(key)) {
                            last.version = value;
                            continue;
                        }
                        if ("link".equals(key) && last.link == null) {
                            last.link = value;
                            continue;
                        }
                        if ("description".equals(key) && last.description == null) {
                            last.description = value;
                            continue;
                        }
                        if ((lang + "shortdescription").equals(key) && last.title == null) {
                            last.title = value;
                            continue;
                        }
                        if ("shortdescription".equals(key) && last.title == null) {
                            last.title = value;
                            continue;
                        }
                        if ((lang + "title").equals(key) && last.title == null) {
                            last.title = value;
                            continue;
                        }
                        if ("title".equals(key) && last.title == null) {
                            last.title = value;
                            continue;
                        }
                        if ("name".equals(key) && last.name == null) {
                            last.name = value;
                            continue;
                        }
                        if ((lang + "author").equals(key)) {
                            last.author = value;
                            continue;
                        }
                        if ((lang + "link").equals(key)) {
                            last.link = value;
                            continue;
                        }
                        if ((lang + "description").equals(key)) {
                            last.description = value;
                            continue;
                        }
                        if (!"min-josm-version".equals(key)) continue;
                        try {
                            last.minJosmVersion = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    last = null;
                    m = Pattern.compile("^(.+);(.+)$").matcher(line);
                    if (m.matches()) {
                        last = new ExtendedSourceEntry(m.group(1), m.group(2));
                        this.sources.add(last);
                        continue;
                    }
                    Main.error(I18n.tr(SourceEditor.this.getStr(I18nString.ILLEGAL_FORMAT_OF_ENTRY), this.url, line));
                }
            }
            catch (IOException e) {
                if (this.canceled) {
                    return;
                }
                OsmTransferException ex = new OsmTransferException(e);
                ex.setUrl(this.url);
                this.warn(ex);
                return;
            }
        }

        @Override
        protected void finish() {
            Collections.sort(this.sources);
            SourceEditor.this.availableSourcesModel.setSources(this.sources);
        }
    }

    static class SourceEntryListCellRenderer
    extends JLabel
    implements ListCellRenderer<ExtendedSourceEntry> {
        SourceEntryListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ExtendedSourceEntry> list, ExtendedSourceEntry value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setFont(this.getFont().deriveFont(0));
            this.setOpaque(true);
            this.setToolTipText(value.getTooltip());
            return this;
        }
    }

    class EditIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditIconPathAction() {
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Edit the selected icon path", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblIconPaths.getSelectedRowCount() == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = SourceEditor.this.tblIconPaths.getSelectedRow();
            SourceEditor.this.tblIconPaths.editCellAt(row, 0);
        }
    }

    class RemoveIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveIconPathAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Remove the selected icon paths", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblIconPaths.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceEditor.this.iconPathsModel.removeSelected();
        }
    }

    class NewIconPathAction
    extends AbstractAction {
        public NewIconPathAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Add a new icon path", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceEditor.this.iconPathsModel.addPath("");
            SourceEditor.this.tblIconPaths.editCellAt(SourceEditor.this.iconPathsModel.getRowCount() - 1, 0);
        }
    }

    protected static class IconPathTableModel
    extends AbstractTableModel {
        private List<String> data;
        private DefaultListSelectionModel selectionModel;

        public IconPathTableModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.data = new ArrayList<String>();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.updatePath(rowIndex, (String)aValue);
        }

        public void setIconPaths(Collection<String> paths) {
            this.data.clear();
            if (paths != null) {
                this.data.addAll(paths);
            }
            this.sort();
            this.fireTableDataChanged();
        }

        public void addPath(String path) {
            if (path == null) {
                return;
            }
            this.data.add(path);
            this.sort();
            this.fireTableDataChanged();
            int idx = this.data.indexOf(path);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
        }

        public void updatePath(int pos, String path) {
            if (path == null) {
                return;
            }
            if (pos < 0 || pos >= this.getRowCount()) {
                return;
            }
            this.data.set(pos, path);
            this.sort();
            this.fireTableDataChanged();
            int idx = this.data.indexOf(path);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
        }

        public void removeSelected() {
            Iterator<String> it = this.data.iterator();
            int i = 0;
            while (it.hasNext()) {
                it.next();
                if (this.selectionModel.isSelectedIndex(i)) {
                    it.remove();
                }
                ++i;
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
        }

        protected void sort() {
            Collections.sort(this.data, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.isEmpty() && o2.isEmpty()) {
                        return 0;
                    }
                    if (o1.isEmpty()) {
                        return 1;
                    }
                    if (o2.isEmpty()) {
                        return -1;
                    }
                    return o1.compareTo(o2);
                }
            });
        }

        public List<String> getIconPaths() {
            return new ArrayList<String>(this.data);
        }
    }

    class ReloadSourcesAction
    extends AbstractAction {
        private final String url;
        private final List<SourceProvider> sourceProviders;

        public ReloadSourcesAction(String url, List<SourceProvider> sourceProviders) {
            this.putValue("Name", I18n.tr("Reload", new Object[0]));
            this.putValue("ShortDescription", I18n.tr(SourceEditor.this.getStr(I18nString.RELOAD_ALL_AVAILABLE), url));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            this.url = url;
            this.sourceProviders = sourceProviders;
            this.setEnabled(!Main.isOffline(OnlineResource.JOSM_WEBSITE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CachedFile.cleanup(this.url);
            SourceEditor.this.reloadAvailableSources(this.url, this.sourceProviders);
        }
    }

    class ResetAction
    extends AbstractAction {
        public ResetAction() {
            this.putValue("Name", I18n.tr("Reset", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Reset to default", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("preferences", "reset"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceEditor.this.activeSourcesModel.setActiveSources(SourceEditor.this.getDefault());
        }
    }

    class ActivateSourcesAction
    extends AbstractAction
    implements ListSelectionListener {
        public ActivateSourcesAction() {
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.ACTIVATE_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("preferences", "activate-right"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.lstAvailableSources.getSelectedIndices().length > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<ExtendedSourceEntry> sources = SourceEditor.this.availableSourcesModel.getSelected();
            int josmVersion = Version.getInstance().getVersion();
            if (josmVersion != 0) {
                ArrayList<String> messages = new ArrayList<String>();
                for (ExtendedSourceEntry entry : sources) {
                    if (entry.minJosmVersion == null || entry.minJosmVersion <= josmVersion) continue;
                    messages.add(I18n.tr("Entry ''{0}'' requires JOSM Version {1}. (Currently running: {2})", entry.title, Integer.toString(entry.minJosmVersion), Integer.toString(josmVersion)));
                }
                if (!messages.isEmpty()) {
                    ExtendedDialog dlg = new ExtendedDialog(Main.parent, I18n.tr("Warning", new Object[0]), new String[]{I18n.tr("Cancel", new Object[0]), I18n.tr("Continue anyway", new Object[0])});
                    dlg.setButtonIcons(new Icon[]{ImageProvider.get("cancel"), ImageProvider.overlay(ImageProvider.get("ok"), new ImageIcon(ImageProvider.get("warning-small").getImage().getScaledInstance(12, 12, 4)), ImageProvider.OverlayPosition.SOUTHEAST)});
                    dlg.setToolTipTexts(new String[]{I18n.tr("Cancel and return to the previous dialog", new Object[0]), I18n.tr("Ignore warning and install style anyway", new Object[0])});
                    dlg.setContent("<html>" + I18n.tr("Some entries have unmet dependencies:", new Object[0]) + "<br>" + Utils.join("<br>", messages) + "</html>");
                    dlg.setIcon(2);
                    if (dlg.showDialog().getValue() != 2) {
                        return;
                    }
                }
            }
            SourceEditor.this.activeSourcesModel.addExtendedSourceEntries(sources);
        }
    }

    class MoveUpDownAction
    extends AbstractAction
    implements ListSelectionListener,
    TableModelListener {
        final int increment;

        public MoveUpDownAction(boolean isDown) {
            this.increment = isDown ? 1 : -1;
            this.putValue("SmallIcon", isDown ? ImageProvider.get("dialogs", "down") : ImageProvider.get("dialogs", "up"));
            this.putValue("ShortDescription", isDown ? I18n.tr("Move the selected entry one row down.", new Object[0]) : I18n.tr("Move the selected entry one row up.", new Object[0]));
            this.updateEnabledState();
        }

        public final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.activeSourcesModel.canMove(this.increment));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceEditor.this.activeSourcesModel.move(this.increment);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.updateEnabledState();
        }
    }

    class EditActiveSourceAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditActiveSourceAction() {
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.EDIT_SOURCE_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblActiveSources.getSelectedRowCount() == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int pos = SourceEditor.this.tblActiveSources.getSelectedRow();
            if (pos < 0 || pos >= SourceEditor.this.tblActiveSources.getRowCount()) {
                return;
            }
            SourceEntry e = (SourceEntry)SourceEditor.this.activeSourcesModel.getValueAt(pos, 1);
            EditSourceEntryDialog editEntryDialog = new EditSourceEntryDialog(SourceEditor.this, I18n.tr("Edit source entry:", new Object[0]), e);
            editEntryDialog.showDialog();
            if (editEntryDialog.getValue() == 1) {
                if (e.title != null || !"".equals(editEntryDialog.getTitle())) {
                    e.title = editEntryDialog.getTitle();
                    if ("".equals(e.title)) {
                        e.title = null;
                    }
                }
                e.url = editEntryDialog.getURL();
                if (SourceEditor.this.canEnable) {
                    e.active = editEntryDialog.active();
                }
                SourceEditor.this.activeSourcesModel.fireTableRowsUpdated(pos, pos);
            }
        }
    }

    class RemoveActiveSourcesAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveActiveSourcesAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.REMOVE_SOURCE_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblActiveSources.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceEditor.this.activeSourcesModel.removeSelected();
        }
    }

    class NewActiveSourceAction
    extends AbstractAction {
        public NewActiveSourceAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.NEW_SOURCE_ENTRY_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EditSourceEntryDialog editEntryDialog = new EditSourceEntryDialog(SourceEditor.this, SourceEditor.this.getStr(I18nString.NEW_SOURCE_ENTRY), null);
            editEntryDialog.showDialog();
            if (editEntryDialog.getValue() == 1) {
                boolean active = true;
                if (SourceEditor.this.canEnable) {
                    active = editEntryDialog.active();
                }
                SourceEditor.this.activeSourcesModel.addSource(new SourceEntry(editEntryDialog.getURL(), null, editEntryDialog.getTitle(), active));
                SourceEditor.this.activeSourcesModel.fireTableDataChanged();
            }
        }
    }

    protected class EditSourceEntryDialog
    extends ExtendedDialog {
        private JosmTextField tfTitle;
        private JosmTextField tfURL;
        private JCheckBox cbActive;

        public EditSourceEntryDialog(Component parent, String title, SourceEntry e) {
            super(parent, title, new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0])});
            JPanel p = new JPanel(new GridBagLayout());
            this.tfTitle = new JosmTextField(60);
            p.add((Component)new JLabel(I18n.tr("Name (optional):", new Object[0])), GBC.std().insets(15, 0, 5, 5));
            p.add((Component)this.tfTitle, GBC.eol().insets(0, 0, 5, 5));
            this.tfURL = new JosmTextField(60);
            p.add((Component)new JLabel(I18n.tr("URL / File:", new Object[0])), GBC.std().insets(15, 0, 5, 0));
            p.add((Component)this.tfURL, GBC.std().insets(0, 0, 5, 5));
            JButton fileChooser = new JButton(new LaunchFileChooserAction());
            fileChooser.setMargin(new Insets(0, 0, 0, 0));
            p.add((Component)fileChooser, GBC.eol().insets(0, 0, 5, 5));
            if (e != null) {
                if (e.title != null) {
                    this.tfTitle.setText(e.title);
                }
                this.tfURL.setText(e.url);
            }
            if (SourceEditor.this.canEnable) {
                this.cbActive = new JCheckBox(I18n.tr("active", new Object[0]), e != null ? e.active : true);
                p.add((Component)this.cbActive, GBC.eol().insets(15, 0, 5, 0));
            }
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setContent(p);
            this.tfURL.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    EditSourceEntryDialog.this.updateOkButtonState();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    EditSourceEntryDialog.this.updateOkButtonState();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    EditSourceEntryDialog.this.updateOkButtonState();
                }
            });
        }

        private void updateOkButtonState() {
            ((JButton)this.buttons.get(0)).setEnabled(!Utils.strip(this.tfURL.getText()).isEmpty());
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            this.updateOkButtonState();
        }

        @Override
        public String getTitle() {
            return this.tfTitle.getText();
        }

        public String getURL() {
            return this.tfURL.getText();
        }

        public boolean active() {
            if (!SourceEditor.this.canEnable) {
                throw new UnsupportedOperationException();
            }
            return this.cbActive.isSelected();
        }

        class LaunchFileChooserAction
        extends AbstractAction {
            public LaunchFileChooserAction() {
                this.putValue("SmallIcon", ImageProvider.get("open"));
                this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtensionFileFilter ff;
                switch (SourceEditor.this.sourceType) {
                    case MAP_PAINT_STYLE: {
                        ff = new ExtensionFileFilter("xml,mapcss,css,zip", "xml", I18n.tr("Map paint style file (*.xml, *.mapcss, *.zip)", new Object[0]));
                        break;
                    }
                    case TAGGING_PRESET: {
                        ff = new ExtensionFileFilter("xml,zip", "xml", I18n.tr("Preset definition file (*.xml, *.zip)", new Object[0]));
                        break;
                    }
                    case TAGCHECKER_RULE: {
                        ff = new ExtensionFileFilter("validator.mapcss,zip", "validator.mapcss", I18n.tr("Tag checker rule (*.validator.mapcss, *.zip)", new Object[0]));
                        break;
                    }
                    default: {
                        Main.error("Unsupported source type: " + (Object)((Object)SourceEditor.this.sourceType));
                        return;
                    }
                }
                FileChooserManager fcm = new FileChooserManager(true).createFileChooser(true, null, Arrays.asList(ff, FileFilterAllFiles.getInstance()), ff, 0);
                SourceEditor.prepareFileChooser(EditSourceEntryDialog.this.tfURL.getText(), fcm.getFileChooser());
                AbstractFileChooser fc = fcm.openFileChooser(JOptionPane.getFrameForComponent(SourceEditor.this));
                if (fc != null) {
                    EditSourceEntryDialog.this.tfURL.setText(fc.getSelectedFile().toString());
                }
            }
        }
    }

    public static class ExtendedSourceEntry
    extends SourceEntry
    implements Comparable<ExtendedSourceEntry> {
        public String simpleFileName;
        public String version;
        public String author;
        public String link;
        public String description;
        public Integer minJosmVersion;

        public ExtendedSourceEntry(String simpleFileName, String url) {
            super(url, null, null, true);
            this.simpleFileName = simpleFileName;
        }

        public String getDisplayName() {
            return this.title == null ? this.simpleFileName : this.title;
        }

        private void appendRow(StringBuilder s, String th, String td) {
            s.append("<tr><th>").append(th).append("</th><td>").append(td).append("</td</tr>");
        }

        public String getTooltip() {
            StringBuilder s = new StringBuilder();
            this.appendRow(s, I18n.tr("Short Description:", new Object[0]), this.getDisplayName());
            this.appendRow(s, I18n.tr("URL:", new Object[0]), this.url);
            if (this.author != null) {
                this.appendRow(s, I18n.tr("Author:", new Object[0]), this.author);
            }
            if (this.link != null) {
                this.appendRow(s, I18n.tr("Webpage:", new Object[0]), this.link);
            }
            if (this.description != null) {
                this.appendRow(s, I18n.tr("Description:", new Object[0]), this.description);
            }
            if (this.version != null) {
                this.appendRow(s, I18n.tr("Version:", new Object[0]), this.version);
            }
            if (this.minJosmVersion != null) {
                this.appendRow(s, I18n.tr("Minimum JOSM Version:", new Object[0]), Integer.toString(this.minJosmVersion));
            }
            return "<html><style>th{text-align:right}td{width:400px}</style><table>" + s + "</table></html>";
        }

        @Override
        public String toString() {
            return "<html><b>" + this.getDisplayName() + "</b>" + (this.author == null ? "" : " <span color=\"gray\">" + I18n.tr("by {0}", this.author) + "</color>") + "</html>";
        }

        @Override
        public int compareTo(ExtendedSourceEntry o) {
            if (this.url.startsWith("resource") && !o.url.startsWith("resource")) {
                return -1;
            }
            if (o.url.startsWith("resource")) {
                return 1;
            }
            return this.getDisplayName().compareToIgnoreCase(o.getDisplayName());
        }
    }

    protected class ActiveSourcesModel
    extends AbstractTableModel {
        private List<SourceEntry> data;
        private DefaultListSelectionModel selectionModel;

        public ActiveSourcesModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.data = new ArrayList<SourceEntry>();
        }

        @Override
        public int getColumnCount() {
            return SourceEditor.this.canEnable ? 2 : 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (SourceEditor.this.canEnable && columnIndex == 0) {
                return this.data.get((int)rowIndex).active;
            }
            return this.data.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return SourceEditor.this.canEnable && columnIndex == 0;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (SourceEditor.this.canEnable && column == 0) {
                return Boolean.class;
            }
            return SourceEntry.class;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (row < 0 || row >= this.getRowCount() || aValue == null) {
                return;
            }
            if (SourceEditor.this.canEnable && column == 0) {
                this.data.get((int)row).active = !this.data.get((int)row).active;
            }
        }

        public void setActiveSources(Collection<? extends SourceEntry> sources) {
            this.data.clear();
            if (sources != null) {
                for (SourceEntry sourceEntry : sources) {
                    this.data.add(new SourceEntry(sourceEntry));
                }
            }
            this.fireTableDataChanged();
        }

        public void addSource(SourceEntry entry) {
            if (entry == null) {
                return;
            }
            this.data.add(entry);
            this.fireTableDataChanged();
            int idx = this.data.indexOf(entry);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
        }

        public void removeSelected() {
            Iterator<SourceEntry> it = this.data.iterator();
            int i = 0;
            while (it.hasNext()) {
                it.next();
                if (this.selectionModel.isSelectedIndex(i)) {
                    it.remove();
                }
                ++i;
            }
            this.fireTableDataChanged();
        }

        public void removeIdxs(Collection<Integer> idxs) {
            ArrayList<SourceEntry> newData = new ArrayList<SourceEntry>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (idxs.contains(i)) continue;
                newData.add(this.data.get(i));
            }
            this.data = newData;
            this.fireTableDataChanged();
        }

        public void addExtendedSourceEntries(List<ExtendedSourceEntry> sources) {
            if (sources == null) {
                return;
            }
            for (ExtendedSourceEntry info : sources) {
                this.data.add(new SourceEntry(info.url, info.name, info.getDisplayName(), true));
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (ExtendedSourceEntry info : sources) {
                int pos = this.data.indexOf(info);
                if (pos < 0) continue;
                this.selectionModel.addSelectionInterval(pos, pos);
            }
        }

        public List<SourceEntry> getSources() {
            return new ArrayList<SourceEntry>(this.data);
        }

        public boolean canMove(int i) {
            int[] sel = SourceEditor.this.tblActiveSources.getSelectedRows();
            if (sel.length == 0) {
                return false;
            }
            if (i < 0) {
                return sel[0] >= -i;
            }
            if (i > 0) {
                return sel[sel.length - 1] <= this.getRowCount() - 1 - i;
            }
            return true;
        }

        public void move(int i) {
            int[] sel;
            if (!this.canMove(i)) {
                return;
            }
            for (int row : sel = SourceEditor.this.tblActiveSources.getSelectedRows()) {
                SourceEntry t1 = this.data.get(row);
                SourceEntry t2 = this.data.get(row + i);
                this.data.set(row, t2);
                this.data.set(row + i, t1);
            }
            this.selectionModel.clearSelection();
            for (int row : sel) {
                this.selectionModel.addSelectionInterval(row + i, row + i);
            }
        }
    }

    protected static class AvailableSourcesListModel
    extends DefaultListModel<ExtendedSourceEntry> {
        private List<ExtendedSourceEntry> data = new ArrayList<ExtendedSourceEntry>();
        private DefaultListSelectionModel selectionModel;

        public AvailableSourcesListModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        public void setSources(List<ExtendedSourceEntry> sources) {
            this.data.clear();
            if (sources != null) {
                this.data.addAll(sources);
            }
            this.fireContentsChanged(this, 0, this.data.size());
        }

        @Override
        public ExtendedSourceEntry getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public void deleteSelected() {
            Iterator<ExtendedSourceEntry> it = this.data.iterator();
            int i = 0;
            while (it.hasNext()) {
                it.next();
                if (this.selectionModel.isSelectedIndex(i)) {
                    it.remove();
                }
                ++i;
            }
            this.fireContentsChanged(this, 0, this.data.size());
        }

        public List<ExtendedSourceEntry> getSelected() {
            ArrayList<ExtendedSourceEntry> ret = new ArrayList<ExtendedSourceEntry>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ret.add(this.data.get(i));
            }
            return ret;
        }
    }

    public static enum I18nString {
        AVAILABLE_SOURCES,
        ACTIVE_SOURCES,
        NEW_SOURCE_ENTRY_TOOLTIP,
        NEW_SOURCE_ENTRY,
        REMOVE_SOURCE_TOOLTIP,
        EDIT_SOURCE_TOOLTIP,
        ACTIVATE_TOOLTIP,
        RELOAD_ALL_AVAILABLE,
        LOADING_SOURCES_FROM,
        FAILED_TO_LOAD_SOURCES_FROM,
        FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC,
        ILLEGAL_FORMAT_OF_ENTRY;

    }
}

