/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.advanced.AdvancedPreference;
import org.openstreetmap.josm.gui.preferences.audio.AudioPreference;
import org.openstreetmap.josm.gui.preferences.display.ColorPreference;
import org.openstreetmap.josm.gui.preferences.display.DisplayPreference;
import org.openstreetmap.josm.gui.preferences.display.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.display.LafPreference;
import org.openstreetmap.josm.gui.preferences.display.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.BackupPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreference;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.remotecontrol.RemoteControlPreference;
import org.openstreetmap.josm.gui.preferences.server.AuthenticationPreference;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.preferences.server.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.shortcut.ShortcutPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTestsPreference;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class PreferenceTabbedPane
extends JTabbedPane
implements MouseWheelListener,
ChangeListener,
ExpertToggleAction.ExpertModeChangeListener {
    private final List<PreferenceTab> tabs = new ArrayList<PreferenceTab>();
    private static final Collection<PreferenceSettingFactory> settingsFactories = new LinkedList<PreferenceSettingFactory>();
    private static final PreferenceSettingFactory advancedPreferenceFactory = new AdvancedPreference.Factory();
    private final List<PreferenceSetting> settings = new ArrayList<PreferenceSetting>();
    private final List<PreferenceSetting> settingsInitialized = new ArrayList<PreferenceSetting>();
    List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting caller) {
        return this.createPreferenceTab(caller, false);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting caller, boolean inScrollPane) {
        PreferencePanel p;
        CheckParameterUtil.ensureParameterNotNull(caller);
        JComponent tab = p = new PreferencePanel(caller);
        if (inScrollPane) {
            PreferenceScrollPane sp = new PreferenceScrollPane(p);
            tab = sp;
        }
        this.tabs.add((PreferenceTab)((Object)tab));
        return p;
    }

    private void selectTabBy(TabIdentifier method, Object param) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            PreferenceTab tab;
            Component c = this.getComponentAt(i);
            if (!(c instanceof PreferenceTab) || !method.identify((tab = (PreferenceTab)((Object)c)).getTabPreferenceSetting(), param)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    public void selectTabByName(String name) {
        this.selectTabBy(new TabIdentifier(){

            @Override
            public boolean identify(TabPreferenceSetting tps, Object name) {
                return name != null && tps != null && tps.getIconName() != null && name.equals(tps.getIconName());
            }
        }, name);
    }

    public void selectTabByPref(Class<? extends TabPreferenceSetting> clazz) {
        this.selectTabBy(new TabIdentifier(){

            @Override
            public boolean identify(TabPreferenceSetting tps, Object clazz) {
                return tps.getClass().isAssignableFrom((Class)clazz);
            }
        }, clazz);
    }

    public boolean selectSubTabByPref(Class<? extends SubPreferenceSetting> clazz) {
        for (PreferenceSetting setting : this.settings) {
            if (!clazz.isInstance(setting)) continue;
            SubPreferenceSetting sub = (SubPreferenceSetting)setting;
            final TabPreferenceSetting tab = sub.getTabPreferenceSetting(this);
            this.selectTabBy(new TabIdentifier(){

                @Override
                public boolean identify(TabPreferenceSetting tps, Object unused) {
                    return tps.equals(tab);
                }
            }, null);
            return tab.selectSubTab(sub);
        }
        return false;
    }

    public final DisplayPreference getDisplayPreference() {
        return this.getSetting(DisplayPreference.class);
    }

    public final MapPreference getMapPreference() {
        return this.getSetting(MapPreference.class);
    }

    public final PluginPreference getPluginPreference() {
        return this.getSetting(PluginPreference.class);
    }

    public final ImageryPreference getImageryPreference() {
        return this.getSetting(ImageryPreference.class);
    }

    public final ShortcutPreference getShortcutPreference() {
        return this.getSetting(ShortcutPreference.class);
    }

    public final ServerAccessPreference getServerPreference() {
        return this.getSetting(ServerAccessPreference.class);
    }

    public final ValidatorPreference getValidatorPreference() {
        return this.getSetting(ValidatorPreference.class);
    }

    public void savePreferences() {
        final PluginPreference preference = this.getPluginPreference();
        final List<PluginInformation> toDownload = preference.getPluginsScheduledForUpdateOrDownload();
        final PluginDownloadTask task = toDownload != null && !toDownload.isEmpty() ? new PluginDownloadTask((Component)this, toDownload, I18n.tr("Download plugins", new Object[0])) : null;
        final Runnable continuation = new Runnable(){

            @Override
            public void run() {
                boolean requiresRestart = false;
                for (PreferenceSetting setting : PreferenceTabbedPane.this.settingsInitialized) {
                    if (!setting.ok()) continue;
                    requiresRestart = true;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                if (task != null && !task.isCanceled()) {
                    PluginHandler.refreshLocalUpdatedPluginInfo(task.getDownloadedPlugins());
                    sb.append(PluginPreference.buildDownloadSummary(task));
                }
                if (requiresRestart) {
                    sb.append(I18n.tr("You have to restart JOSM for some settings to take effect.", new Object[0]));
                    sb.append("<br/><br/>");
                    sb.append(I18n.tr("Would you like to restart now?", new Object[0]));
                }
                sb.append("</html>");
                if (requiresRestart) {
                    HelpAwareOptionPane.ButtonSpec[] options = RestartAction.getButtonSpecs();
                    if (0 == HelpAwareOptionPane.showOptionDialog(Main.parent, sb.toString(), I18n.tr("Restart", new Object[0]), 1, null, options, options[0], null)) {
                        Main.main.menu.restart.actionPerformed(null);
                    }
                } else if (task != null && !task.isCanceled()) {
                    JOptionPane.showMessageDialog(Main.parent, sb.toString(), I18n.tr("Warning", new Object[0]), 2);
                }
                List<PluginInformation> newPlugins = preference.getNewlyActivatedPlugins();
                if (newPlugins != null) {
                    boolean removed;
                    Collection<PluginInformation> downloadedPlugins = null;
                    if (task != null && !task.isCanceled()) {
                        downloadedPlugins = task.getDownloadedPlugins();
                    }
                    ArrayList<PluginInformation> toLoad = new ArrayList<PluginInformation>();
                    for (PluginInformation pi : newPlugins) {
                        if (toDownload.contains(pi) && downloadedPlugins != null && !downloadedPlugins.contains(pi) || !pi.canloadatruntime) continue;
                        toLoad.add(pi);
                    }
                    HashSet<PluginInformation> allPlugins = new HashSet<PluginInformation>(toLoad);
                    for (PluginProxy proxy : PluginHandler.pluginList) {
                        allPlugins.add(proxy.getPluginInformation());
                    }
                    do {
                        removed = false;
                        Iterator it = toLoad.iterator();
                        while (it.hasNext()) {
                            if (PluginHandler.checkRequiredPluginsPreconditions(null, allPlugins, (PluginInformation)it.next(), requiresRestart)) continue;
                            it.remove();
                            removed = true;
                        }
                    } while (removed);
                    if (!toLoad.isEmpty()) {
                        PluginHandler.loadPlugins(PreferenceTabbedPane.this, toLoad, null);
                    }
                }
                Main.parent.repaint();
            }
        };
        if (task != null) {
            Main.worker.submit(task);
            Main.worker.submit(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(continuation);
                }
            });
        } else {
            continuation.run();
        }
    }

    public PreferenceTabbedPane() {
        super(2, 1);
        super.addMouseWheelListener(this);
        super.getModel().addChangeListener(this);
        ExpertToggleAction.addExpertModeChangeListener(this);
    }

    public void buildGui() {
        ArrayList<PreferenceSettingFactory> factories = new ArrayList<PreferenceSettingFactory>(settingsFactories);
        factories.addAll(PluginHandler.getPreferenceSetting());
        factories.add(advancedPreferenceFactory);
        for (PreferenceSettingFactory factory : factories) {
            PreferenceSetting setting = factory.createPreferenceSetting();
            if (setting == null) continue;
            this.settings.add(setting);
        }
        this.addGUITabs(false);
    }

    private void addGUITabsForSetting(Icon icon, TabPreferenceSetting tps) {
        for (PreferenceTab tab : this.tabs) {
            if (!tab.getTabPreferenceSetting().equals(tps)) continue;
            this.insertGUITabsForSetting(icon, tps, this.getTabCount());
        }
    }

    private void insertGUITabsForSetting(Icon icon, TabPreferenceSetting tps, int index) {
        int position = index;
        for (PreferenceTab tab : this.tabs) {
            if (!tab.getTabPreferenceSetting().equals(tps)) continue;
            this.insertTab(null, icon, tab.getComponent(), tps.getTooltip(), position++);
        }
    }

    private void addGUITabs(boolean clear) {
        boolean expert = ExpertToggleAction.isExpert();
        Component sel = this.getSelectedComponent();
        if (clear) {
            this.removeAll();
        }
        for (PreferenceSetting setting : this.settings) {
            if (setting instanceof TabPreferenceSetting) {
                ImageIcon icon;
                TabPreferenceSetting tps = (TabPreferenceSetting)setting;
                if (!expert && tps.isExpert()) continue;
                String iconName = tps.getIconName();
                ImageIcon imageIcon = icon = iconName != null && iconName.length() > 0 ? ImageProvider.get("preferences", iconName) : null;
                if (icon != null && (icon.getIconHeight() != 48 || icon.getIconWidth() != 48)) {
                    icon = new ImageIcon(icon.getImage().getScaledInstance(48, 48, 1));
                }
                if (this.settingsInitialized.contains(tps)) {
                    this.addGUITabsForSetting(icon, tps);
                    continue;
                }
                this.addTab(null, icon, new PreferencePanel(tps), tps.getTooltip());
                continue;
            }
            if (setting instanceof SubPreferenceSetting) continue;
            Main.warn("Ignoring preferences " + setting);
        }
        try {
            if (sel != null) {
                this.setSelectedComponent(sel);
            }
        }
        catch (IllegalArgumentException e) {
            Main.warn(e);
        }
    }

    @Override
    public void expertChanged(boolean isExpert) {
        this.addGUITabs(true);
    }

    public List<PreferenceSetting> getSettings() {
        return this.settings;
    }

    public <T> T getSetting(Class<? extends T> clazz) {
        for (PreferenceSetting setting : this.settings) {
            if (!clazz.isAssignableFrom(setting.getClass())) continue;
            return (T)setting;
        }
        return null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent wev) {
        if (super.indexAtLocation(wev.getPoint().x, wev.getPoint().y) < 0) {
            return;
        }
        int newTab = super.getSelectedIndex() + wev.getWheelRotation();
        newTab = newTab < 0 ? 0 : newTab;
        newTab = newTab >= super.getTabCount() ? super.getTabCount() - 1 : newTab;
        super.setSelectedIndex(newTab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        PreferenceTab tab;
        TabPreferenceSetting preferenceSettings;
        int index = this.getSelectedIndex();
        Component sel = this.getSelectedComponent();
        if (index > -1 && sel instanceof PreferenceTab && !this.settingsInitialized.contains(preferenceSettings = (tab = (PreferenceTab)((Object)sel)).getTabPreferenceSetting())) {
            try {
                this.getModel().removeChangeListener(this);
                preferenceSettings.addGui(this);
                for (PreferenceSetting setting : this.settings) {
                    SubPreferenceSetting sps;
                    if (!(setting instanceof SubPreferenceSetting) || (sps = (SubPreferenceSetting)setting).getTabPreferenceSetting(this) != preferenceSettings) continue;
                    try {
                        sps.addGui(this);
                    }
                    catch (SecurityException ex) {
                        Main.error(ex);
                    }
                    catch (Exception ex) {
                        BugReportExceptionHandler.handleException(ex);
                    }
                    finally {
                        this.settingsInitialized.add(sps);
                    }
                }
                Icon icon = this.getIconAt(index);
                this.remove(index);
                this.insertGUITabsForSetting(icon, preferenceSettings, index);
                this.setSelectedIndex(index);
            }
            catch (SecurityException ex) {
                Main.error(ex);
            }
            catch (Exception ex) {
                BugReportExceptionHandler.handleException(ex);
            }
            finally {
                this.settingsInitialized.add(preferenceSettings);
                this.getModel().addChangeListener(this);
            }
        }
    }

    static {
        settingsFactories.add(new DisplayPreference.Factory());
        settingsFactories.add(new DrawingPreference.Factory());
        settingsFactories.add(new ColorPreference.Factory());
        settingsFactories.add(new LafPreference.Factory());
        settingsFactories.add(new LanguagePreference.Factory());
        settingsFactories.add(new ServerAccessPreference.Factory());
        settingsFactories.add(new AuthenticationPreference.Factory());
        settingsFactories.add(new ProxyPreference.Factory());
        settingsFactories.add(new MapPreference.Factory());
        settingsFactories.add(new ProjectionPreference.Factory());
        settingsFactories.add(new MapPaintPreference.Factory());
        settingsFactories.add(new TaggingPresetPreference.Factory());
        settingsFactories.add(new BackupPreference.Factory());
        settingsFactories.add(new PluginPreference.Factory());
        settingsFactories.add(Main.toolbar);
        settingsFactories.add(new AudioPreference.Factory());
        settingsFactories.add(new ShortcutPreference.Factory());
        settingsFactories.add(new ValidatorPreference.Factory());
        settingsFactories.add(new ValidatorTestsPreference.Factory());
        settingsFactories.add(new ValidatorTagCheckerRulesPreference.Factory());
        settingsFactories.add(new RemoteControlPreference.Factory());
        settingsFactories.add(new ImageryPreference.Factory());
    }

    private static interface TabIdentifier {
        public boolean identify(TabPreferenceSetting var1, Object var2);
    }

    public static final class PreferenceScrollPane
    extends JScrollPane
    implements PreferenceTab {
        private final TabPreferenceSetting preferenceSetting;

        private PreferenceScrollPane(Component view, TabPreferenceSetting preferenceSetting) {
            super(view);
            this.preferenceSetting = preferenceSetting;
        }

        private PreferenceScrollPane(PreferencePanel preferencePanel) {
            this(preferencePanel.getComponent(), preferencePanel.getTabPreferenceSetting());
        }

        @Override
        public final TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    public static final class PreferencePanel
    extends JPanel
    implements PreferenceTab {
        private final TabPreferenceSetting preferenceSetting;

        private PreferencePanel(TabPreferenceSetting preferenceSetting) {
            super(new GridBagLayout());
            CheckParameterUtil.ensureParameterNotNull(preferenceSetting);
            this.preferenceSetting = preferenceSetting;
            this.buildPanel();
        }

        protected void buildPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)new JLabel(this.preferenceSetting.getTitle()), GBC.eol().insets(0, 5, 0, 10).anchor(18));
            JLabel descLabel = new JLabel("<html>" + this.preferenceSetting.getDescription() + "</html>");
            descLabel.setFont(descLabel.getFont().deriveFont(2));
            this.add((Component)descLabel, GBC.eol().insets(5, 0, 5, 20).fill(2));
        }

        @Override
        public final TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    private static interface PreferenceTab {
        public TabPreferenceSetting getTabPreferenceSetting();

        public Component getComponent();
    }

    public static interface ValidationListener {
        public boolean validatePreferences();
    }
}

