/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class PreferenceDialog
extends JDialog {
    private PreferenceTabbedPane tpPreferences;
    private boolean canceled;

    protected JPanel buildActionPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        JCheckBox expert = new JCheckBox(I18n.tr("Expert mode", new Object[0]));
        expert.setSelected(ExpertToggleAction.isExpert());
        expert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpertToggleAction.getInstance().actionPerformed(null);
            }
        });
        JPanel btns = new JPanel(new FlowLayout(1));
        btns.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        btns.add(new SideButton(new OKAction()));
        btns.add(new SideButton(new CancelAction()));
        btns.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/Preferences"))));
        pnl.add((Component)expert, GBC.std().insets(5, 0, 0, 0));
        pnl.add((Component)btns, GBC.std().fill(2));
        return pnl;
    }

    protected final void build() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.tpPreferences = new PreferenceTabbedPane();
        c.add((Component)this.tpPreferences, "Center");
        this.tpPreferences.buildGui();
        this.tpPreferences.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        c.add((Component)this.buildActionPanel(), "South");
        this.addWindowListener(new WindowEventHandler());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new CancelAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/Preferences"));
    }

    public PreferenceDialog(Component parent) {
        super((Window)JOptionPane.getFrameForComponent(parent), I18n.tr("Preferences", new Object[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        this.setMinimumSize(new Dimension(600, 350));
        this.setMaximumSize(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public PreferenceTabbedPane getTabbedPane() {
        return this.tpPreferences;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            Insets i = this.getParent().getInsets();
            Dimension p = this.getParent().getSize();
            p = new Dimension(Math.min(p.width - i.left - i.right, 700), Math.min(p.height - i.top - i.bottom, 800));
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), p)).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public void selectPreferencesTabByName(String name) {
        this.tpPreferences.selectTabByName(name);
    }

    public void selectPreferencesTabByClass(Class<? extends TabPreferenceSetting> clazz) {
        this.tpPreferences.selectTabByPref(clazz);
    }

    public void selectSubPreferencesTabByClass(Class<? extends SubPreferenceSetting> clazz) {
        this.tpPreferences.selectSubTabByPref(clazz);
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            new CancelAction().cancel();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("OK", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Save the preferences and close the dialog", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            for (PreferenceTabbedPane.ValidationListener listener : ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners) {
                if (listener.validatePreferences()) continue;
                return;
            }
            PreferenceDialog.this.tpPreferences.savePreferences();
            ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners.clear();
            PreferenceDialog.this.setCanceled(false);
            PreferenceDialog.this.setVisible(false);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the preferences dialog and discard preference updates", new Object[0]));
        }

        public void cancel() {
            PreferenceDialog.this.setCanceled(true);
            PreferenceDialog.this.setVisible(false);
            ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners.clear();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.cancel();
        }
    }
}

