/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.DefaultPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.tools.GBC;

public abstract class DefaultTabPreferenceSetting
extends DefaultPreferenceSetting
implements TabPreferenceSetting {
    private final String iconName;
    private final String description;
    private final String title;
    private final JTabbedPane tabpane;
    private final Map<SubPreferenceSetting, Component> subSettingMap;

    public DefaultTabPreferenceSetting() {
        this(null, null, null);
    }

    public DefaultTabPreferenceSetting(String iconName, String title, String description) {
        this(iconName, title, description, false);
    }

    public DefaultTabPreferenceSetting(String iconName, String title, String description, boolean isExpert) {
        this(iconName, title, description, isExpert, null);
    }

    public DefaultTabPreferenceSetting(String iconName, String title, String description, boolean isExpert, JTabbedPane tabpane) {
        super(isExpert);
        this.iconName = iconName;
        this.description = description;
        this.title = title;
        this.tabpane = tabpane;
        this.subSettingMap = tabpane != null ? new HashMap() : null;
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    public String getTooltip() {
        if (this.getDescription() != null) {
            return "<html>" + this.getDescription() + "</html>";
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public final JTabbedPane getTabPane() {
        return this.tabpane;
    }

    protected final void createPreferenceTabWithScrollPane(PreferenceTabbedPane gui, JPanel panel) {
        GBC a = GBC.eol().insets(-5, 0, 0, 0);
        a.anchor = 13;
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(null);
        PreferenceTabbedPane.PreferencePanel tab = gui.createPreferenceTab(this);
        tab.add((Component)scrollPane, GBC.eol().fill(1));
        tab.add(GBC.glue(0, 10), a);
    }

    @Override
    public boolean selectSubTab(SubPreferenceSetting subPref) {
        Component tab;
        if (this.tabpane != null && subPref != null && (tab = this.getSubTab(subPref)) != null) {
            try {
                this.tabpane.setSelectedComponent(tab);
                return true;
            }
            catch (IllegalArgumentException e) {
                Main.debug(Main.getErrorMessage(e));
            }
        }
        return false;
    }

    @Override
    public final void addSubTab(SubPreferenceSetting sub, String title, Component component) {
        this.addSubTab(sub, title, component, null);
    }

    @Override
    public final void addSubTab(SubPreferenceSetting sub, String title, Component component, String tip) {
        if (this.tabpane != null && component != null) {
            this.tabpane.addTab(title, null, component, tip);
            this.registerSubTab(sub, component);
        }
    }

    @Override
    public final void registerSubTab(SubPreferenceSetting sub, Component component) {
        if (this.subSettingMap != null && sub != null && component != null) {
            this.subSettingMap.put(sub, component);
        }
    }

    @Override
    public final Component getSubTab(SubPreferenceSetting sub) {
        return this.subSettingMap != null ? this.subSettingMap.get(sub) : null;
    }
}

