/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.AccessTokenInfoPanel;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationClient;
import org.openstreetmap.josm.gui.oauth.RetrieveAccessTokenTask;
import org.openstreetmap.josm.gui.oauth.RetrieveRequestTokenTask;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class SemiAutomaticAuthorizationUI
extends AbstractAuthorizationUI {
    private AccessTokenInfoPanel pnlAccessTokenInfo;
    private OAuthToken requestToken;
    private RetrieveRequestTokenPanel pnlRetrieveRequestToken;
    private RetrieveAccessTokenPanel pnlRetrieveAccessToken;
    private ShowAccessTokenPanel pnlShowAccessToken;

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlRetrieveRequestToken = new RetrieveRequestTokenPanel();
        this.pnlRetrieveAccessToken = new RetrieveAccessTokenPanel();
        this.pnlShowAccessToken = new ShowAccessTokenPanel();
        this.add((Component)this.pnlRetrieveRequestToken, "Center");
    }

    public SemiAutomaticAuthorizationUI(String apiUrl) {
        super(apiUrl);
        this.build();
    }

    @Override
    public boolean isSaveAccessTokenToPreferences() {
        return this.pnlAccessTokenInfo.isSaveToPreferences();
    }

    protected void transitionToRetrieveAccessToken() {
        OsmOAuthAuthorizationClient client = new OsmOAuthAuthorizationClient(this.getAdvancedPropertiesPanel().getAdvancedParameters());
        String authoriseUrl = client.getAuthoriseUrl(this.requestToken);
        OpenBrowser.displayUrl(authoriseUrl);
        this.removeAll();
        this.pnlRetrieveAccessToken.setAuthoriseUrl(authoriseUrl);
        this.add((Component)this.pnlRetrieveAccessToken, "Center");
        this.pnlRetrieveAccessToken.invalidate();
        this.validate();
        this.repaint();
    }

    protected void transitionToRetrieveRequestToken() {
        this.requestToken = null;
        this.setAccessToken(null);
        this.removeAll();
        this.add((Component)this.pnlRetrieveRequestToken, "Center");
        this.pnlRetrieveRequestToken.invalidate();
        this.validate();
        this.repaint();
    }

    protected void transitionToShowAccessToken() {
        this.removeAll();
        this.add((Component)this.pnlShowAccessToken, "Center");
        this.pnlShowAccessToken.invalidate();
        this.validate();
        this.repaint();
        this.pnlShowAccessToken.setAccessToken(this.getAccessToken());
    }

    class TestAccessTokenAction
    extends AbstractAction {
        public TestAccessTokenAction() {
            this.putValue("Name", I18n.tr("Test Access Token", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
            this.putValue("ShortDescription", I18n.tr("Click to test the Access Token", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TestAccessTokenTask task = new TestAccessTokenTask(SemiAutomaticAuthorizationUI.this, SemiAutomaticAuthorizationUI.this.getApiUrl(), SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters(), SemiAutomaticAuthorizationUI.this.getAccessToken());
            Main.worker.submit(task);
        }
    }

    class RetrieveAccessTokenAction
    extends AbstractAction {
        public RetrieveAccessTokenAction() {
            this.putValue("Name", I18n.tr("Retrieve Access Token", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
            this.putValue("ShortDescription", I18n.tr("Click to retrieve an Access Token", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final RetrieveAccessTokenTask task = new RetrieveAccessTokenTask((Component)SemiAutomaticAuthorizationUI.this, SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters(), SemiAutomaticAuthorizationUI.this.requestToken);
            Main.worker.submit(task);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (task.isCanceled()) {
                        return;
                    }
                    if (task.getAccessToken() == null) {
                        return;
                    }
                    SemiAutomaticAuthorizationUI.this.setAccessToken(task.getAccessToken());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SemiAutomaticAuthorizationUI.this.transitionToShowAccessToken();
                        }
                    });
                }
            };
            Main.worker.submit(r);
        }
    }

    class RetrieveRequestTokenAction
    extends AbstractAction {
        public RetrieveRequestTokenAction() {
            this.putValue("Name", I18n.tr("Retrieve Request Token", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
            this.putValue("ShortDescription", I18n.tr("Click to retrieve a Request Token", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final RetrieveRequestTokenTask task = new RetrieveRequestTokenTask(SemiAutomaticAuthorizationUI.this, SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters());
            Main.worker.submit(task);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (task.isCanceled()) {
                        return;
                    }
                    if (task.getRequestToken() == null) {
                        return;
                    }
                    SemiAutomaticAuthorizationUI.this.requestToken = task.getRequestToken();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SemiAutomaticAuthorizationUI.this.transitionToRetrieveAccessToken();
                        }
                    });
                }
            };
            Main.worker.submit(r);
        }
    }

    class ShowAccessTokenPanel
    extends JPanel {
        protected JPanel buildTitlePanel() {
            JPanel pnl = new JPanel(new BorderLayout());
            JLabel lbl = new JLabel(I18n.tr("<html>Step 3/3: Successfully retrieved an Access Token</html>", new Object[0]));
            lbl.setFont(lbl.getFont().deriveFont(16.0f));
            pnl.add((Component)lbl, "Center");
            return pnl;
        }

        protected JPanel buildContentPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.weightx = 1.0;
            HtmlPanel html = new HtmlPanel();
            html.setText(I18n.tr("<html>JOSM has successfully retrieved an Access Token. You can now accept this token. JOSM will use it in the future for authentication and authorization to the OSM server.<br><br>The access token is: </html>", new Object[0]));
            pnl.add((Component)html, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.weightx = 1.0;
            gc.gridwidth = 1;
            pnl.add((Component)(SemiAutomaticAuthorizationUI.this.pnlAccessTokenInfo = new AccessTokenInfoPanel()), gc);
            SemiAutomaticAuthorizationUI.this.pnlAccessTokenInfo.setSaveToPreferences(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
            return pnl;
        }

        protected JPanel buildActionPanel() {
            JPanel pnl = new JPanel(new FlowLayout(0));
            pnl.add(new SideButton(new RestartAction()));
            pnl.add(new SideButton(new TestAccessTokenAction()));
            return pnl;
        }

        protected final void build() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.buildTitlePanel(), "North");
            this.add((Component)this.buildContentPanel(), "Center");
            this.add((Component)this.buildActionPanel(), "South");
        }

        public ShowAccessTokenPanel() {
            this.build();
        }

        public void setAccessToken(OAuthToken accessToken) {
            SemiAutomaticAuthorizationUI.this.pnlAccessTokenInfo.setAccessToken(accessToken);
        }

        class RestartAction
        extends AbstractAction {
            public RestartAction() {
                this.putValue("Name", I18n.tr("Restart", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Go back to step 1/3", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "previous"));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SemiAutomaticAuthorizationUI.this.transitionToRetrieveRequestToken();
            }
        }
    }

    private class RetrieveAccessTokenPanel
    extends JPanel {
        private JosmTextField tfAuthoriseUrl;

        protected JPanel buildTitlePanel() {
            JPanel pnl = new JPanel(new BorderLayout());
            JLabel lbl = new JLabel(I18n.tr("<html>Step 2/3: Authorize and retrieve an Access Token</html>", new Object[0]));
            lbl.setFont(lbl.getFont().deriveFont(16.0f));
            pnl.add((Component)lbl, "Center");
            return pnl;
        }

        protected JPanel buildContentPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.gridwidth = 2;
            HtmlPanel html = new HtmlPanel();
            html.setText(I18n.tr("<html>JOSM successfully retrieved a Request Token. JOSM is now launching an authorization page in an external browser. Please login with your OSM username and password and follow the instructions to authorize the Request Token. Then switch back to this dialog and click on <strong>{0}</strong><br><br>If launching the external browser fails you can copy the following authorize URL and paste it into the address field of your browser.</html>", I18n.tr("Request Access Token", new Object[0])));
            pnl.add((Component)html, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            pnl.add((Component)new JLabel(I18n.tr("Authorize URL:", new Object[0])), gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.tfAuthoriseUrl = new JosmTextField();
            pnl.add((Component)this.tfAuthoriseUrl, gc);
            this.tfAuthoriseUrl.setEditable(false);
            return pnl;
        }

        protected JPanel buildActionPanel() {
            JPanel pnl = new JPanel(new FlowLayout(0));
            pnl.add(new SideButton(new BackAction()));
            pnl.add(new SideButton(new RetrieveAccessTokenAction()));
            return pnl;
        }

        protected final void build() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.buildTitlePanel(), "North");
            this.add((Component)this.buildContentPanel(), "Center");
            this.add((Component)this.buildActionPanel(), "South");
        }

        public RetrieveAccessTokenPanel() {
            this.build();
        }

        public void setAuthoriseUrl(String url) {
            this.tfAuthoriseUrl.setText(url);
        }

        class BackAction
        extends AbstractAction {
            public BackAction() {
                this.putValue("Name", I18n.tr("Back", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Go back to step 1/3", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "previous"));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SemiAutomaticAuthorizationUI.this.transitionToRetrieveRequestToken();
            }
        }
    }

    private class RetrieveRequestTokenPanel
    extends JPanel {
        private JCheckBox cbShowAdvancedParameters;

        protected JPanel buildAdvancedParametersPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.insets = new Insets(0, 0, 0, 3);
            this.cbShowAdvancedParameters = new JCheckBox();
            pnl.add((Component)this.cbShowAdvancedParameters, gc);
            this.cbShowAdvancedParameters.setSelected(false);
            this.cbShowAdvancedParameters.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().setVisible(evt.getStateChange() == 1);
                }
            });
            gc.gridx = 1;
            gc.weightx = 1.0;
            JMultilineLabel lbl = new JMultilineLabel(I18n.tr("Display Advanced OAuth Parameters", new Object[0]));
            lbl.setFont(lbl.getFont().deriveFont(0));
            pnl.add((Component)lbl, gc);
            gc.gridy = 1;
            gc.gridx = 1;
            gc.insets = new Insets(3, 0, 3, 0);
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            pnl.add((Component)SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel(), gc);
            SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().setVisible(false);
            return pnl;
        }

        protected JPanel buildCommandPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.insets = new Insets(0, 0, 0, 3);
            HtmlPanel h = new HtmlPanel();
            h.setText(I18n.tr("<html>Please click on <strong>{0}</strong> to retrieve an OAuth Request Token from ''{1}''.</html>", I18n.tr("Retrieve Request Token", new Object[0]), SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters().getRequestTokenUrl()));
            pnl.add((Component)h, gc);
            JPanel pnl1 = new JPanel(new FlowLayout(0));
            pnl1.add(new SideButton(new RetrieveRequestTokenAction()));
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.gridy = 1;
            pnl.add((Component)pnl1, gc);
            return pnl;
        }

        protected final void build() {
            this.setLayout(new BorderLayout(0, 5));
            JLabel lbl = new JLabel(I18n.tr("<html>Step 1/3: Retrieve an OAuth Request Token</html>", new Object[0]));
            lbl.setFont(lbl.getFont().deriveFont(16.0f));
            this.add((Component)lbl, "North");
            this.add((Component)this.buildAdvancedParametersPanel(), "Center");
            this.add((Component)this.buildCommandPanel(), "South");
        }

        public RetrieveRequestTokenPanel() {
            this.build();
        }
    }
}

