/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.data.oauth.OsmPrivileges;
import org.openstreetmap.josm.gui.oauth.OsmLoginFailedException;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmOAuthAuthorizationClient {
    private final OAuthParameters oauthProviderParameters;
    private final OAuthConsumer consumer;
    private final OAuthProvider provider;
    private boolean canceled;
    private HttpURLConnection connection;

    public OsmOAuthAuthorizationClient() {
        this.oauthProviderParameters = OAuthParameters.createDefault(Main.pref.get("osm-server.url"));
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OsmOAuthAuthorizationClient(OAuthParameters parameters) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(parameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OsmOAuthAuthorizationClient(OAuthParameters parameters, OAuthToken requestToken) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(parameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
        this.consumer.setTokenWithSecret(requestToken.getKey(), requestToken.getSecret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        DefaultOAuthProvider p = (DefaultOAuthProvider)this.provider;
        this.canceled = true;
        if (p != null) {
            try {
                Field f = p.getClass().getDeclaredField("connection");
                f.setAccessible(true);
                HttpURLConnection con = (HttpURLConnection)f.get(p);
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                Main.error(e);
                Main.warn(I18n.tr("Failed to cancel running OAuth operation", new Object[0]));
            }
        }
        OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
        synchronized (osmOAuthAuthorizationClient) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    public OAuthToken getRequestToken(ProgressMonitor monitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Request Token from ''{0}''", this.oauthProviderParameters.getRequestTokenUrl()));
            this.provider.retrieveRequestToken(this.consumer, "", new String[0]);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthException e) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(e);
            }
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public OAuthToken getAccessToken(ProgressMonitor monitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Access Token from ''{0}''", this.oauthProviderParameters.getAccessTokenUrl()));
            this.provider.retrieveAccessToken(this.consumer, null, new String[0]);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthException e) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(e);
            }
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public String getAuthoriseUrl(OAuthToken requestToken) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oauthProviderParameters.getAuthoriseUrl()).append("?").append("oauth_token").append("=").append(requestToken.getKey());
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String extractToken(HttpURLConnection connection) {
        try (InputStream is = connection.getInputStream();
             BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String c;
            Matcher m;
            Pattern p = Pattern.compile(".*authenticity_token.*value=\"([^\"]+)\".*");
            do {
                if ((c = r.readLine()) == null) return null;
            } while (!(m = p.matcher(c)).find());
            String string = m.group(1);
            return string;
        }
        catch (IOException e) {
            Main.error(e);
            return null;
        }
    }

    protected SessionId extractOsmSession(HttpURLConnection connection) {
        List<String> setCookies = connection.getHeaderFields().get("Set-Cookie");
        if (setCookies == null) {
            return null;
        }
        for (String setCookie : setCookies) {
            String[] kvPairs = setCookie.split(";");
            if (kvPairs == null || kvPairs.length == 0) continue;
            for (String kvPair : kvPairs) {
                String[] kv = (kvPair = kvPair.trim()).split("=");
                if (kv == null || kv.length != 2 || !"_osm_session".equals(kv[0])) continue;
                String token = this.extractToken(connection);
                if (token == null) {
                    return null;
                }
                SessionId si = new SessionId();
                si.id = kv[1];
                si.token = token;
                return si;
            }
        }
        return null;
    }

    protected String buildPostRequest(Map<String, String> parameters) throws OsmOAuthAuthorizationException {
        try {
            StringBuilder sb = new StringBuilder();
            Iterator<Map.Entry<String, String>> it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                String value = entry.getValue();
                value = value == null ? "" : value;
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(value, "UTF-8"));
                if (!it.hasNext()) continue;
                sb.append("&");
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
    }

    public String buildOsmLoginUrl() throws OsmOAuthAuthorizationException {
        try {
            URL autUrl = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            URL url = new URL(Main.pref.get("oauth.protocol", "https"), autUrl.getHost(), autUrl.getPort(), "/login");
            return url.toString();
        }
        catch (MalformedURLException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
    }

    protected String buildOsmLogoutUrl() throws OsmOAuthAuthorizationException {
        try {
            URL autUrl = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            URL url = new URL("http", autUrl.getHost(), autUrl.getPort(), "/logout");
            return url.toString();
        }
        catch (MalformedURLException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionId fetchOsmWebsiteSessionId() throws OsmOAuthAuthorizationException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.buildOsmLoginUrl()).append("?cookie_test=true");
            URL url = new URL(sb.toString());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = Utils.openHttpConnection(url);
            }
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.connection.connect();
            SessionId sessionId = this.extractOsmSession(this.connection);
            if (sessionId == null) {
                throw new OsmOAuthAuthorizationException(I18n.tr("OSM website did not return a session cookie in response to ''{0}'',", url.toString()));
            }
            SessionId sessionId2 = sessionId;
            return sessionId2;
        }
        catch (IOException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchOAuthToken(SessionId sessionId, OAuthToken requestToken) throws OsmOAuthAuthorizationException {
        try {
            URL url = new URL(this.getAuthoriseUrl(requestToken));
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = Utils.openHttpConnection(url);
            }
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.connection.setRequestProperty("Cookie", "_osm_session=" + sessionId.id + "; _osm_username=" + sessionId.userName);
            this.connection.connect();
            sessionId.token = this.extractToken(this.connection);
            if (sessionId.token == null) {
                throw new OsmOAuthAuthorizationException(I18n.tr("OSM website did not return a session cookie in response to ''{0}'',", url.toString()));
            }
        }
        catch (IOException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticateOsmSession(SessionId sessionId, String userName, String password) throws OsmLoginFailedException {
        try {
            URL url = new URL(this.buildOsmLoginUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = Utils.openHttpConnection(url);
            }
            this.connection.setRequestMethod("POST");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("username", userName);
            parameters.put("password", password);
            parameters.put("referer", "/");
            parameters.put("commit", "Login");
            parameters.put("authenticity_token", sessionId.token);
            String request = this.buildPostRequest(parameters);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.connection.setRequestProperty("Content-Length", Integer.toString(request.length()));
            this.connection.setRequestProperty("Cookie", "_osm_session=" + sessionId.id);
            this.connection.setInstanceFollowRedirects(false);
            this.connection.connect();
            try (DataOutputStream dout = new DataOutputStream(this.connection.getOutputStream());){
                dout.writeBytes(request);
                dout.flush();
            }
            int retCode = this.connection.getResponseCode();
            if (retCode != 302) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authenticate user ''{0}'' with password ''***'' as OAuth user", userName));
            }
        }
        catch (OsmOAuthAuthorizationException e) {
            throw new OsmLoginFailedException(e.getCause());
        }
        catch (IOException e) {
            throw new OsmLoginFailedException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logoutOsmSession(SessionId sessionId) throws OsmOAuthAuthorizationException {
        try {
            URL url = new URL(this.buildOsmLogoutUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = Utils.openHttpConnection(url);
            }
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.connection.connect();
        }
        catch (IOException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAuthorisationRequest(SessionId sessionId, OAuthToken requestToken, OsmPrivileges privileges) throws OsmOAuthAuthorizationException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.fetchOAuthToken(sessionId, requestToken);
        parameters.put("oauth_token", requestToken.getKey());
        parameters.put("oauth_callback", "");
        parameters.put("authenticity_token", sessionId.token);
        if (privileges.isAllowWriteApi()) {
            parameters.put("allow_write_api", "yes");
        }
        if (privileges.isAllowWriteGpx()) {
            parameters.put("allow_write_gpx", "yes");
        }
        if (privileges.isAllowReadGpx()) {
            parameters.put("allow_read_gpx", "yes");
        }
        if (privileges.isAllowWritePrefs()) {
            parameters.put("allow_write_prefs", "yes");
        }
        if (privileges.isAllowReadPrefs()) {
            parameters.put("allow_read_prefs", "yes");
        }
        if (privileges.isAllowModifyNotes()) {
            parameters.put("allow_write_notes", "yes");
        }
        parameters.put("commit", "Save changes");
        String request = this.buildPostRequest(parameters);
        try {
            URL url = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = Utils.openHttpConnection(url);
            }
            this.connection.setRequestMethod("POST");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.connection.setRequestProperty("Content-Length", Integer.toString(request.length()));
            this.connection.setRequestProperty("Cookie", "_osm_session=" + sessionId.id + "; _osm_username=" + sessionId.userName);
            this.connection.setInstanceFollowRedirects(false);
            this.connection.connect();
            try (DataOutputStream dout = new DataOutputStream(this.connection.getOutputStream());){
                dout.writeBytes(request);
                dout.flush();
            }
            int retCode = this.connection.getResponseCode();
            if (retCode != 200) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authorize OAuth request  ''{0}''", requestToken.getKey()));
            }
        }
        catch (IOException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    public void authorise(OAuthToken requestToken, String osmUserName, String osmPassword, OsmPrivileges privileges, ProgressMonitor monitor) throws IllegalArgumentException, OsmOAuthAuthorizationException, OsmTransferCanceledException {
        CheckParameterUtil.ensureParameterNotNull(requestToken, "requestToken");
        CheckParameterUtil.ensureParameterNotNull(osmUserName, "osmUserName");
        CheckParameterUtil.ensureParameterNotNull(osmPassword, "osmPassword");
        CheckParameterUtil.ensureParameterNotNull(privileges, "privileges");
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr("Authorizing OAuth Request token ''{0}'' at the OSM website ...", requestToken.getKey()));
            monitor.setTicksCount(4);
            monitor.indeterminateSubTask(I18n.tr("Initializing a session at the OSM website...", new Object[0]));
            SessionId sessionId = this.fetchOsmWebsiteSessionId();
            sessionId.userName = osmUserName;
            if (this.canceled) {
                throw new OsmTransferCanceledException();
            }
            monitor.worked(1);
            monitor.indeterminateSubTask(I18n.tr("Authenticating the session for user ''{0}''...", osmUserName));
            this.authenticateOsmSession(sessionId, osmUserName, osmPassword);
            if (this.canceled) {
                throw new OsmTransferCanceledException();
            }
            monitor.worked(1);
            monitor.indeterminateSubTask(I18n.tr("Authorizing request token ''{0}''...", requestToken.getKey()));
            this.sendAuthorisationRequest(sessionId, requestToken, privileges);
            if (this.canceled) {
                throw new OsmTransferCanceledException();
            }
            monitor.worked(1);
            monitor.indeterminateSubTask(I18n.tr("Logging out session ''{0}''...", sessionId));
            this.logoutOsmSession(sessionId);
            if (this.canceled) {
                throw new OsmTransferCanceledException();
            }
            monitor.worked(1);
        }
        catch (OsmOAuthAuthorizationException e) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(e);
            }
            throw e;
        }
        finally {
            monitor.finishTask();
        }
    }

    private static class SessionId {
        String id;
        String token;
        String userName;

        private SessionId() {
        }
    }
}

