/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AdvancedOAuthPropertiesPanel
extends VerticallyScrollablePanel {
    private JCheckBox cbUseDefaults;
    private JosmTextField tfConsumerKey;
    private JosmTextField tfConsumerSecret;
    private JosmTextField tfRequestTokenURL;
    private JosmTextField tfAccessTokenURL;
    private JosmTextField tfAuthoriseURL;
    private UseDefaultItemListener ilUseDefault;
    private String apiUrl;

    protected final void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 0, 3, 3);
        gc.gridwidth = 2;
        this.cbUseDefaults = new JCheckBox(I18n.tr("Use default settings", new Object[0]));
        this.add((Component)this.cbUseDefaults, gc);
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        this.add((Component)new JLabel(I18n.tr("Consumer Key:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfConsumerKey = new JosmTextField();
        this.add((Component)this.tfConsumerKey, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfConsumerKey);
        gc.gridy = 2;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Consumer Secret:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfConsumerSecret = new JosmTextField();
        this.add((Component)this.tfConsumerSecret, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfConsumerSecret);
        gc.gridy = 3;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Request Token URL:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfRequestTokenURL = new JosmTextField();
        this.add((Component)this.tfRequestTokenURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfRequestTokenURL);
        gc.gridy = 4;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Access Token URL:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfAccessTokenURL = new JosmTextField();
        this.add((Component)this.tfAccessTokenURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAccessTokenURL);
        gc.gridy = 5;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Authorize URL:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfAuthoriseURL = new JosmTextField();
        this.add((Component)this.tfAuthoriseURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAuthoriseURL);
        this.ilUseDefault = new UseDefaultItemListener();
        this.cbUseDefaults.addItemListener(this.ilUseDefault);
    }

    protected boolean hasCustomSettings() {
        OAuthParameters params = OAuthParameters.createDefault(this.apiUrl);
        return !this.tfConsumerKey.getText().equals(params.getConsumerKey()) || !this.tfConsumerSecret.getText().equals(params.getConsumerSecret()) || !this.tfRequestTokenURL.getText().equals(params.getRequestTokenUrl()) || !this.tfAccessTokenURL.getText().equals(params.getAccessTokenUrl()) || !this.tfAuthoriseURL.getText().equals(params.getAuthoriseUrl());
    }

    protected boolean confirmOverwriteCustomSettings() {
        HelpAwareOptionPane.ButtonSpec[] buttons = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to reset the OAuth settings to default values", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to abort resetting to the OAuth default values", new Object[0]), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>JOSM is about to reset the OAuth settings to default values.<br>The current custom settings are not saved.</html>", new Object[0]), I18n.tr("Overwrite custom OAuth settings?", new Object[0]), 2, null, buttons, buttons[0], HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"));
        return ret == 0;
    }

    protected void resetToDefaultSettings() {
        this.cbUseDefaults.setSelected(true);
        OAuthParameters params = OAuthParameters.createDefault(this.apiUrl);
        this.tfConsumerKey.setText(params.getConsumerKey());
        this.tfConsumerSecret.setText(params.getConsumerSecret());
        this.tfRequestTokenURL.setText(params.getRequestTokenUrl());
        this.tfAccessTokenURL.setText(params.getAccessTokenUrl());
        this.tfAuthoriseURL.setText(params.getAuthoriseUrl());
        this.setChildComponentsEnabled(false);
    }

    protected void setChildComponentsEnabled(boolean enabled) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof JosmTextField) && !(c instanceof JLabel)) continue;
            c.setEnabled(enabled);
        }
    }

    public OAuthParameters getAdvancedParameters() {
        if (this.cbUseDefaults.isSelected()) {
            return OAuthParameters.createDefault(this.apiUrl);
        }
        OAuthParameters parameters = new OAuthParameters();
        parameters.setConsumerKey(this.tfConsumerKey.getText());
        parameters.setConsumerSecret(this.tfConsumerSecret.getText());
        parameters.setRequestTokenUrl(this.tfRequestTokenURL.getText());
        parameters.setAccessTokenUrl(this.tfAccessTokenURL.getText());
        parameters.setAuthoriseUrl(this.tfAuthoriseURL.getText());
        return parameters;
    }

    public void setAdvancedParameters(OAuthParameters parameters) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        if (parameters.equals(OAuthParameters.createDefault(this.apiUrl))) {
            this.cbUseDefaults.setSelected(true);
            this.setChildComponentsEnabled(false);
        } else {
            this.cbUseDefaults.setSelected(false);
            this.setChildComponentsEnabled(true);
            this.tfConsumerKey.setText(parameters.getConsumerKey() == null ? "" : parameters.getConsumerKey());
            this.tfConsumerSecret.setText(parameters.getConsumerSecret() == null ? "" : parameters.getConsumerSecret());
            this.tfRequestTokenURL.setText(parameters.getRequestTokenUrl() == null ? "" : parameters.getRequestTokenUrl());
            this.tfAccessTokenURL.setText(parameters.getAccessTokenUrl() == null ? "" : parameters.getAccessTokenUrl());
            this.tfAuthoriseURL.setText(parameters.getAuthoriseUrl() == null ? "" : parameters.getAuthoriseUrl());
        }
    }

    public AdvancedOAuthPropertiesPanel() {
        this.build();
    }

    public void initFromPreferences(Preferences pref2) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(pref2, "pref");
        this.setApiUrl(pref2.get("osm-server.url"));
        boolean useDefault = pref2.getBoolean("oauth.settings.use-default", true);
        this.ilUseDefault.setEnabled(false);
        if (useDefault) {
            this.resetToDefaultSettings();
        } else {
            this.cbUseDefaults.setSelected(false);
            this.tfConsumerKey.setText(pref2.get("oauth.settings.consumer-key", "F7zPYlVCqE2BUH9Hr4SsWZSOnrKjpug1EgqkbsSb"));
            this.tfConsumerSecret.setText(pref2.get("oauth.settings.consumer-secret", "rIkjpPcBNkMQxrqzcOvOC4RRuYupYr7k8mfP13H5"));
            this.tfRequestTokenURL.setText(pref2.get("oauth.settings.request-token-url", OAuthParameters.DEFAULT_REQUEST_TOKEN_URL));
            this.tfAccessTokenURL.setText(pref2.get("oauth.settings.access-token-url", OAuthParameters.DEFAULT_ACCESS_TOKEN_URL));
            this.tfAuthoriseURL.setText(pref2.get("oauth.settings.authorise-url", OAuthParameters.DEFAULT_AUTHORISE_URL));
            this.setChildComponentsEnabled(true);
        }
        this.ilUseDefault.setEnabled(true);
    }

    public void rememberPreferences(Preferences pref2) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(pref2, "pref");
        pref2.put("oauth.settings.use-default", this.cbUseDefaults.isSelected());
        if (this.cbUseDefaults.isSelected()) {
            pref2.put("oauth.settings.consumer-key", null);
            pref2.put("oauth.settings.consumer-secret", null);
            pref2.put("oauth.settings.request-token-url", null);
            pref2.put("oauth.settings.access-token-url", null);
            pref2.put("oauth.settings.authorise-url", null);
        } else {
            pref2.put("oauth.settings.consumer-key", this.tfConsumerKey.getText().trim());
            pref2.put("oauth.settings.consumer-secret", this.tfConsumerSecret.getText().trim());
            pref2.put("oauth.settings.request-token-url", this.tfRequestTokenURL.getText().trim());
            pref2.put("oauth.settings.access-token-url", this.tfAccessTokenURL.getText().trim());
            pref2.put("oauth.settings.authorise-url", this.tfAuthoriseURL.getText().trim());
        }
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        if (this.cbUseDefaults.isSelected()) {
            this.resetToDefaultSettings();
        }
    }

    class UseDefaultItemListener
    implements ItemListener {
        private boolean enabled;

        UseDefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!this.enabled) {
                return;
            }
            switch (e.getStateChange()) {
                case 1: {
                    if (AdvancedOAuthPropertiesPanel.this.hasCustomSettings() && !AdvancedOAuthPropertiesPanel.this.confirmOverwriteCustomSettings()) {
                        AdvancedOAuthPropertiesPanel.this.cbUseDefaults.setSelected(false);
                        return;
                    }
                    AdvancedOAuthPropertiesPanel.this.resetToDefaultSettings();
                    break;
                }
                case 2: {
                    AdvancedOAuthPropertiesPanel.this.setChildComponentsEnabled(true);
                }
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

