/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.xml;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.xml.AreaPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.IconPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.LinePrototype;
import org.openstreetmap.josm.gui.mappaint.xml.LinemodPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.XmlCondition;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSource;
import org.openstreetmap.josm.tools.ColorHelper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XmlStyleSourceHandler
extends DefaultHandler {
    private boolean inDoc;
    private boolean inRule;
    private boolean inCondition;
    private boolean inLine;
    private boolean inLineMod;
    private boolean inIcon;
    private boolean inArea;
    private boolean inScaleMax;
    private boolean inScaleMin;
    private boolean hadLine;
    private boolean hadLineMod;
    private boolean hadIcon;
    private boolean hadArea;
    private RuleElem rule = new RuleElem();
    XmlStyleSource style;

    public XmlStyleSourceHandler(XmlStyleSource style) {
        this.style = style;
        this.inArea = false;
        this.inIcon = false;
        this.inLine = false;
        this.inCondition = false;
        this.inRule = false;
        this.inDoc = false;
        this.rule.init();
    }

    Color convertColor(String colString) {
        int i = colString.indexOf(35);
        Color ret = i < 0 ? Main.pref.getColor("mappaint." + this.style.getPrefName() + "." + colString, Color.red) : (i == 0 ? ColorHelper.html2color(colString) : Main.pref.getColor("mappaint." + this.style.getPrefName() + "." + colString.substring(0, i), ColorHelper.html2color(colString.substring(i))));
        return ret;
    }

    @Override
    public void startDocument() {
        this.inDoc = true;
    }

    @Override
    public void endDocument() {
        this.inDoc = false;
    }

    private void error(String message) {
        String warning = this.style.getDisplayString() + " (" + this.rule.cond.key + "=" + this.rule.cond.value + "): " + message;
        Main.warn(warning);
        this.style.logError(new Exception(warning));
    }

    private void startElementLine(String qName, Attributes atts, LinePrototype line) {
        block20: for (int count = 0; count < atts.getLength(); ++count) {
            switch (atts.getQName(count)) {
                case "width": {
                    String val = atts.getValue(count);
                    if (val.startsWith("+") || val.startsWith("-") || val.endsWith("%")) continue block20;
                    line.setWidth(Integer.parseInt(val));
                    continue block20;
                }
                case "colour": {
                    line.color = this.convertColor(atts.getValue(count));
                    continue block20;
                }
                case "realwidth": {
                    line.realWidth = Integer.parseInt(atts.getValue(count));
                    continue block20;
                }
                case "dashed": {
                    Object dashed;
                    try {
                        String[] parts = atts.getValue(count).split(",");
                        dashed = new Float[parts.length];
                        for (int i = 0; i < parts.length; ++i) {
                            dashed[i] = Float.valueOf(Integer.parseInt(parts[i]));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        boolean isDashed = Boolean.parseBoolean(atts.getValue(count));
                        dashed = isDashed ? new Float[]{Float.valueOf(9.0f)} : null;
                    }
                    line.setDashed(dashed == null ? null : Arrays.asList(dashed));
                    continue block20;
                }
                case "dashedcolour": {
                    line.dashedColor = this.convertColor(atts.getValue(count));
                    continue block20;
                }
                case "priority": {
                    line.priority = Integer.parseInt(atts.getValue(count));
                    continue block20;
                }
                case "mode": {
                    if (line instanceof LinemodPrototype) continue block20;
                }
                default: {
                    this.error("The element \"" + qName + "\" has unknown attribute \"" + atts.getQName(count) + "\"!");
                }
            }
        }
    }

    private void startElementLinemod(String qName, Attributes atts, LinemodPrototype line) {
        this.startElementLine(qName, atts, line);
        block8: for (int count = 0; count < atts.getLength(); ++count) {
            switch (atts.getQName(count)) {
                case "width": {
                    String val = atts.getValue(count);
                    if (val.startsWith("+")) {
                        line.setWidth(Integer.parseInt(val.substring(1)));
                        line.widthMode = LinemodPrototype.WidthMode.OFFSET;
                        continue block8;
                    }
                    if (val.startsWith("-")) {
                        line.setWidth(Integer.parseInt(val));
                        line.widthMode = LinemodPrototype.WidthMode.OFFSET;
                        continue block8;
                    }
                    if (val.endsWith("%")) {
                        line.setWidth(Integer.parseInt(val.substring(0, val.length() - 1)));
                        line.widthMode = LinemodPrototype.WidthMode.PERCENT;
                        continue block8;
                    }
                    line.setWidth(Integer.parseInt(val));
                    continue block8;
                }
                case "mode": {
                    line.over = !"under".equals(atts.getValue(count));
                }
            }
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.inDoc) {
            switch (qName) {
                case "rule": {
                    this.inRule = true;
                    break;
                }
                case "rules": {
                    if (this.style.name == null) {
                        this.style.name = atts.getValue("name");
                    }
                    if (this.style.title == null) {
                        this.style.title = atts.getValue("shortdescription");
                    }
                    if (this.style.icon != null) break;
                    this.style.icon = atts.getValue("icon");
                    break;
                }
                case "scale_max": {
                    this.inScaleMax = true;
                    break;
                }
                case "scale_min": {
                    this.inScaleMin = true;
                    break;
                }
                case "condition": {
                    if (!this.inRule) break;
                    this.inCondition = true;
                    XmlCondition c = this.rule.cond;
                    if (c.key != null) {
                        if (this.rule.conditions == null) {
                            this.rule.conditions = new LinkedList<XmlCondition>();
                        }
                        this.rule.conditions.add(new XmlCondition(this.rule.cond));
                        c = new XmlCondition();
                        this.rule.conditions.add(c);
                    }
                    block52: for (int count = 0; count < atts.getLength(); ++count) {
                        switch (atts.getQName(count)) {
                            case "k": {
                                c.key = atts.getValue(count);
                                continue block52;
                            }
                            case "v": {
                                c.value = atts.getValue(count);
                                continue block52;
                            }
                            case "b": {
                                c.boolValue = atts.getValue(count);
                                continue block52;
                            }
                            default: {
                                this.error("The element \"" + qName + "\" has unknown attribute \"" + atts.getQName(count) + "\"!");
                            }
                        }
                    }
                    if (c.key != null) break;
                    this.error("The condition has no key!");
                    break;
                }
                case "line": {
                    this.inLine = true;
                    this.hadLine = true;
                    this.startElementLine(qName, atts, this.rule.line);
                    break;
                }
                case "linemod": {
                    this.inLineMod = true;
                    this.hadLineMod = true;
                    this.startElementLinemod(qName, atts, this.rule.linemod);
                    break;
                }
                case "icon": {
                    this.inIcon = true;
                    block53: for (int count = 0; count < atts.getLength(); ++count) {
                        switch (atts.getQName(count)) {
                            case "src": {
                                MapPaintStyles.IconReference icon = new MapPaintStyles.IconReference(atts.getValue(count), this.style);
                                this.hadIcon = icon != null;
                                this.rule.icon.icon = icon;
                                continue block53;
                            }
                            case "annotate": {
                                this.rule.icon.annotate = Boolean.parseBoolean(atts.getValue(count));
                                continue block53;
                            }
                            case "priority": {
                                this.rule.icon.priority = Integer.parseInt(atts.getValue(count));
                                continue block53;
                            }
                            default: {
                                this.error("The element \"" + qName + "\" has unknown attribute \"" + atts.getQName(count) + "\"!");
                            }
                        }
                    }
                    break;
                }
                case "area": {
                    this.inArea = true;
                    this.hadArea = true;
                    block54: for (int count = 0; count < atts.getLength(); ++count) {
                        switch (atts.getQName(count)) {
                            case "colour": {
                                this.rule.area.color = this.convertColor(atts.getValue(count));
                                continue block54;
                            }
                            case "closed": {
                                this.rule.area.closed = Boolean.parseBoolean(atts.getValue(count));
                                continue block54;
                            }
                            case "priority": {
                                this.rule.area.priority = Integer.parseInt(atts.getValue(count));
                                continue block54;
                            }
                            default: {
                                this.error("The element \"" + qName + "\" has unknown attribute \"" + atts.getQName(count) + "\"!");
                            }
                        }
                    }
                    break;
                }
                default: {
                    this.error("The element \"" + qName + "\" is unknown!");
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.inRule && "rule".equals(qName)) {
            if (this.hadLine) {
                this.style.add(this.rule.cond, this.rule.conditions, new LinePrototype(this.rule.line, new Range(this.rule.scaleMin, this.rule.scaleMax)));
            }
            if (this.hadLineMod) {
                this.style.add(this.rule.cond, this.rule.conditions, new LinemodPrototype(this.rule.linemod, new Range(this.rule.scaleMin, this.rule.scaleMax)));
            }
            if (this.hadIcon) {
                this.style.add(this.rule.cond, this.rule.conditions, new IconPrototype(this.rule.icon, new Range(this.rule.scaleMin, this.rule.scaleMax)));
            }
            if (this.hadArea) {
                this.style.add(this.rule.cond, this.rule.conditions, new AreaPrototype(this.rule.area, new Range(this.rule.scaleMin, this.rule.scaleMax)));
            }
            this.inRule = false;
            this.hadArea = false;
            this.hadIcon = false;
            this.hadLineMod = false;
            this.hadLine = false;
            this.rule.init();
        } else if (this.inCondition && "condition".equals(qName)) {
            this.inCondition = false;
        } else if (this.inLine && "line".equals(qName)) {
            this.inLine = false;
        } else if (this.inLineMod && "linemod".equals(qName)) {
            this.inLineMod = false;
        } else if (this.inIcon && "icon".equals(qName)) {
            this.inIcon = false;
        } else if (this.inArea && "area".equals(qName)) {
            this.inArea = false;
        } else if ("scale_max".equals(qName)) {
            this.inScaleMax = false;
        } else if ("scale_min".equals(qName)) {
            this.inScaleMin = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inScaleMax) {
            this.rule.scaleMax = Long.parseLong(new String(ch, start, length));
        } else if (this.inScaleMin) {
            this.rule.scaleMin = Long.parseLong(new String(ch, start, length));
        }
    }

    static class RuleElem {
        XmlCondition cond = new XmlCondition();
        Collection<XmlCondition> conditions;
        double scaleMax;
        double scaleMin;
        LinePrototype line = new LinePrototype();
        LinemodPrototype linemod = new LinemodPrototype();
        AreaPrototype area = new AreaPrototype();
        IconPrototype icon = new IconPrototype();

        RuleElem() {
        }

        public void init() {
            this.conditions = null;
            this.scaleMax = Double.POSITIVE_INFINITY;
            this.scaleMin = 0.0;
            this.line.init();
            this.cond.init();
            this.linemod.init();
            this.area.init();
            this.icon.init();
        }
    }
}

