/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.xml.AreaPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.IconPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.LinePrototype;
import org.openstreetmap.josm.gui.mappaint.xml.LinemodPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.Prototype;
import org.openstreetmap.josm.gui.mappaint.xml.XmlCondition;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSourceHandler;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlStyleSource
extends StyleSource
implements StyleKeys {
    public static final String XML_STYLE_MIME_TYPES = "application/xml, text/xml, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5";
    protected final Map<String, IconPrototype> icons = new HashMap<String, IconPrototype>();
    protected final Map<String, LinePrototype> lines = new HashMap<String, LinePrototype>();
    protected final Map<String, LinemodPrototype> modifiers = new HashMap<String, LinemodPrototype>();
    protected final Map<String, AreaPrototype> areas = new HashMap<String, AreaPrototype>();
    protected final List<IconPrototype> iconsList = new LinkedList<IconPrototype>();
    protected final List<LinePrototype> linesList = new LinkedList<LinePrototype>();
    protected final List<LinemodPrototype> modifiersList = new LinkedList<LinemodPrototype>();
    protected final List<AreaPrototype> areasList = new LinkedList<AreaPrototype>();

    public XmlStyleSource(String url, String name, String shortdescription) {
        super(url, name, shortdescription);
    }

    public XmlStyleSource(SourceEntry entry) {
        super(entry);
    }

    @Override
    protected void init() {
        super.init();
        this.icons.clear();
        this.lines.clear();
        this.modifiers.clear();
        this.areas.clear();
        this.iconsList.clear();
        this.linesList.clear();
        this.modifiersList.clear();
        this.areasList.clear();
    }

    @Override
    public void loadStyleSource() {
        this.init();
        try (InputStream in = this.getSourceInputStream();
             InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            XmlObjectParser parser = new XmlObjectParser(new XmlStyleSourceHandler(this));
            parser.startWithValidation(reader, Main.getXMLBase() + "/mappaint-style-1.0", "resource://data/mappaint-style.xsd");
            while (parser.hasNext()) {
            }
        }
        catch (IOException e) {
            Main.warn(I18n.tr("Failed to load Mappaint styles from ''{0}''. Exception was: {1}", this.url, e.toString()));
            Main.error(e);
            this.logError(e);
        }
        catch (SAXParseException e) {
            Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: [{1}:{2}] {3}", this.url, e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
            Main.error(e);
            this.logError(e);
        }
        catch (SAXException e) {
            Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, e.getMessage()));
            Main.error(e);
            this.logError(e);
        }
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        CachedFile cf = this.getCachedFile();
        InputStream zip = cf.findZipEntryInputStream("xml", "style");
        if (zip != null) {
            this.zipIcons = cf.getFile();
            return zip;
        }
        this.zipIcons = null;
        return cf.getInputStream();
    }

    @Override
    public CachedFile getCachedFile() throws IOException {
        return new CachedFile(this.url).setHttpAccept(XML_STYLE_MIME_TYPES);
    }

    private <T extends Prototype> T update(T current, T candidate, Double scale, MultiCascade mc) {
        if (this.requiresUpdate(current, candidate, scale, mc)) {
            return candidate;
        }
        return current;
    }

    private boolean requiresUpdate(Prototype current, Prototype candidate, Double scale, MultiCascade mc) {
        if (current == null || candidate.priority >= current.priority) {
            if (scale == null) {
                return true;
            }
            if (candidate.range.contains(scale)) {
                mc.range = Range.cut(mc.range, candidate.range);
                return true;
            }
            mc.range = mc.range.reduceAround(scale, candidate.range);
            return false;
        }
        return false;
    }

    private IconPrototype getNode(OsmPrimitive primitive, Double scale, MultiCascade mc) {
        IconPrototype icon = null;
        for (String key : primitive.keySet()) {
            String val = primitive.get(key);
            IconPrototype p = this.icons.get("n" + key + "=" + val);
            if (p != null) {
                icon = this.update(icon, p, scale, mc);
            }
            if ((p = this.icons.get("b" + key + "=" + OsmUtils.getNamedOsmBoolean(val))) != null) {
                icon = this.update(icon, p, scale, mc);
            }
            if ((p = this.icons.get("x" + key)) == null) continue;
            icon = this.update(icon, p, scale, mc);
        }
        for (IconPrototype s : this.iconsList) {
            if (!s.check(primitive)) continue;
            icon = this.update(icon, s, scale, mc);
        }
        return icon;
    }

    private void get(OsmPrimitive primitive, boolean closed, WayPrototypesRecord p, Double scale, MultiCascade mc) {
        String lineIdx = null;
        HashMap<String, LinemodPrototype> overlayMap = new HashMap<String, LinemodPrototype>();
        boolean isNotArea = primitive.isKeyFalse("area");
        for (String string : primitive.keySet()) {
            LinemodPrototype styleLinemod;
            LinePrototype styleLine;
            String val = primitive.get(string);
            String idx = "n" + string + "=" + val;
            AreaPrototype styleArea = this.areas.get(idx);
            if (!(styleArea == null || !closed && styleArea.closed || isNotArea)) {
                p.area = this.update(p.area, styleArea, scale, mc);
            }
            if ((styleLine = this.lines.get(idx)) != null && this.requiresUpdate(p.line, styleLine, scale, mc)) {
                p.line = styleLine;
                lineIdx = idx;
            }
            if ((styleLinemod = this.modifiers.get(idx)) != null && this.requiresUpdate(null, styleLinemod, scale, mc)) {
                overlayMap.put(idx, styleLinemod);
            }
            if (!((styleArea = this.areas.get(idx = "b" + string + "=" + OsmUtils.getNamedOsmBoolean(val))) == null || !closed && styleArea.closed || isNotArea)) {
                p.area = this.update(p.area, styleArea, scale, mc);
            }
            if ((styleLine = this.lines.get(idx)) != null && this.requiresUpdate(p.line, styleLine, scale, mc)) {
                p.line = styleLine;
                lineIdx = idx;
            }
            if ((styleLinemod = this.modifiers.get(idx)) != null && this.requiresUpdate(null, styleLinemod, scale, mc)) {
                overlayMap.put(idx, styleLinemod);
            }
            if (!((styleArea = this.areas.get(idx = "x" + string)) == null || !closed && styleArea.closed || isNotArea)) {
                p.area = this.update(p.area, styleArea, scale, mc);
            }
            if ((styleLine = this.lines.get(idx)) != null && this.requiresUpdate(p.line, styleLine, scale, mc)) {
                p.line = styleLine;
                lineIdx = idx;
            }
            if ((styleLinemod = this.modifiers.get(idx)) == null || !this.requiresUpdate(null, styleLinemod, scale, mc)) continue;
            overlayMap.put(idx, styleLinemod);
        }
        for (AreaPrototype areaPrototype : this.areasList) {
            if (!closed && areaPrototype.closed || isNotArea || !areaPrototype.check(primitive)) continue;
            p.area = this.update(p.area, areaPrototype, scale, mc);
        }
        for (LinePrototype linePrototype : this.linesList) {
            if (!linePrototype.check(primitive)) continue;
            p.line = this.update(p.line, linePrototype, scale, mc);
        }
        for (LinemodPrototype linemodPrototype : this.modifiersList) {
            if (!linemodPrototype.check(primitive) || !this.requiresUpdate(null, linemodPrototype, scale, mc)) continue;
            overlayMap.put(linemodPrototype.getCode(), linemodPrototype);
        }
        overlayMap.remove(lineIdx);
        if (!overlayMap.isEmpty()) {
            LinkedList<LinemodPrototype> tmp = new LinkedList<LinemodPrototype>();
            if (p.linemods != null) {
                tmp.addAll(p.linemods);
            }
            tmp.addAll(overlayMap.values());
            Collections.sort(tmp);
            p.linemods = tmp;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(XmlCondition c, Collection<XmlCondition> conditions, Prototype prot) {
        if (conditions != null) {
            prot.conditions = conditions;
            if (prot instanceof IconPrototype) {
                this.iconsList.add((IconPrototype)prot);
                return;
            } else if (prot instanceof LinemodPrototype) {
                this.modifiersList.add((LinemodPrototype)prot);
                return;
            } else if (prot instanceof LinePrototype) {
                this.linesList.add((LinePrototype)prot);
                return;
            } else {
                if (!(prot instanceof AreaPrototype)) throw new RuntimeException();
                this.areasList.add((AreaPrototype)prot);
            }
            return;
        } else {
            String key;
            prot.code = key = c.getKey();
            if (prot instanceof IconPrototype) {
                this.icons.put(key, (IconPrototype)prot);
                return;
            } else if (prot instanceof LinemodPrototype) {
                this.modifiers.put(key, (LinemodPrototype)prot);
                return;
            } else if (prot instanceof LinePrototype) {
                this.lines.put(key, (LinePrototype)prot);
                return;
            } else {
                if (!(prot instanceof AreaPrototype)) throw new RuntimeException();
                this.areas.put(key, (AreaPrototype)prot);
            }
        }
    }

    @Override
    public void apply(MultiCascade mc, OsmPrimitive osm, double scale, boolean pretendWayIsClosed) {
        Cascade def = mc.getOrCreateCascade("default");
        boolean useMinMaxScale = Main.pref.getBoolean("mappaint.zoomLevelDisplay", false);
        if (osm instanceof Node || osm instanceof Relation && "restriction".equals(osm.get("type"))) {
            IconPrototype icon = this.getNode(osm, useMinMaxScale ? Double.valueOf(scale) : null, mc);
            if (icon != null) {
                def.put("icon-image", icon.icon);
                if (osm instanceof Node && icon.annotate != null) {
                    if (icon.annotate.booleanValue()) {
                        def.put("text", Keyword.AUTO);
                    } else {
                        def.remove("text");
                    }
                }
            }
        } else if (osm instanceof Way || osm instanceof Relation && ((Relation)osm).isMultipolygon()) {
            Float refWidth;
            WayPrototypesRecord p = new WayPrototypesRecord();
            this.get(osm, pretendWayIsClosed || !(osm instanceof Way) || ((Way)osm).isClosed(), p, useMinMaxScale ? Double.valueOf(scale) : null, mc);
            if (p.line != null) {
                int alpha;
                def.put("width", new Float(p.line.getWidth()));
                def.putOrClear("real-width", p.line.realWidth != null ? new Float(p.line.realWidth.intValue()) : null);
                def.putOrClear("color", p.line.color);
                if (p.line.color != null && (alpha = p.line.color.getAlpha()) != 255) {
                    def.put("opacity", Utils.color_int2float(alpha));
                }
                def.putOrClear("dashes", p.line.getDashed());
                def.putOrClear("dashes-background-color", p.line.dashedColor);
            }
            if ((refWidth = def.get("width", null, Float.class)) != null && p.linemods != null) {
                int numOver = 0;
                int numUnder = 0;
                while (mc.hasLayer(String.format("over_%d", ++numOver))) {
                }
                while (mc.hasLayer(String.format("under_%d", ++numUnder))) {
                }
                for (LinemodPrototype mod : p.linemods) {
                    int alpha;
                    Cascade c;
                    String layer;
                    if (mod.over) {
                        layer = String.format("over_%d", numOver);
                        c = mc.getOrCreateCascade(layer);
                        c.put("object-z-index", new Float(numOver));
                        ++numOver;
                    } else {
                        layer = String.format("under_%d", numUnder);
                        c = mc.getOrCreateCascade(layer);
                        c.put("object-z-index", new Float(-numUnder));
                        ++numUnder;
                    }
                    c.put("width", new Float(mod.getWidth(refWidth.floatValue())));
                    c.putOrClear("color", mod.color);
                    if (mod.color != null && (alpha = mod.color.getAlpha()) != 255) {
                        c.put("opacity", Utils.color_int2float(alpha));
                    }
                    c.putOrClear("dashes", mod.getDashed());
                    c.putOrClear("dashes-background-color", mod.dashedColor);
                }
            }
            if (p.area != null) {
                def.putOrClear("fill-color", p.area.color);
                def.putOrClear("text-position", Keyword.CENTER);
                def.putOrClear("text", Keyword.AUTO);
                def.remove("fill-image");
            }
        }
    }

    private static class WayPrototypesRecord {
        public LinePrototype line;
        public List<LinemodPrototype> linemods;
        public AreaPrototype area;

        private WayPrototypesRecord() {
        }
    }
}

