/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.xml;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.xml.XmlCondition;

public abstract class Prototype {
    public Range range;
    public int priority;
    public String code;
    public Collection<XmlCondition> conditions = null;

    public Prototype(Range range) {
        this.range = range;
    }

    public Prototype() {
    }

    public String getCode() {
        if (this.code == null) {
            if (this.conditions == null || this.conditions.isEmpty()) {
                this.code = "";
            } else {
                StringBuilder sb = new StringBuilder();
                for (XmlCondition r : this.conditions) {
                    r.appendCode(sb);
                }
                this.code = sb.toString();
            }
        }
        return this.code;
    }

    public boolean check(OsmPrimitive primitive) {
        if (this.conditions == null) {
            return true;
        }
        for (XmlCondition r : this.conditions) {
            String k = primitive.get(r.key);
            if (k == null || r.value != null && !k.equals(r.value)) {
                return false;
            }
            String bv = OsmUtils.getNamedOsmBoolean(r.boolValue);
            if (bv == null || bv.equals(OsmUtils.getNamedOsmBoolean(k))) continue;
            return false;
        }
        return true;
    }
}

