/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.xml;

import java.awt.Color;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.xml.Prototype;
import org.openstreetmap.josm.tools.I18n;

public class LinePrototype
extends Prototype {
    protected int width;
    public Integer realWidth;
    public Color color;
    protected List<Float> dashed;
    public Color dashedColor;

    public LinePrototype(LinePrototype s, Range range) {
        super(range);
        this.width = s.width;
        this.realWidth = s.realWidth;
        this.color = s.color;
        this.dashed = s.dashed;
        this.dashedColor = s.dashedColor;
        this.priority = s.priority;
        this.conditions = s.conditions;
    }

    public LinePrototype() {
        this.init();
    }

    public void init() {
        this.priority = 0;
        this.range = Range.ZERO_TO_INFINITY;
        this.width = -1;
        this.realWidth = null;
        this.dashed = null;
        this.dashedColor = null;
        this.color = PaintColors.UNTAGGED.get();
    }

    public List<Float> getDashed() {
        return this.dashed;
    }

    public void setDashed(List<Float> dashed) {
        if (dashed == null || dashed.isEmpty()) {
            this.dashed = null;
            return;
        }
        boolean found = false;
        for (Float f : dashed) {
            if (f == null) {
                this.dashed = null;
                return;
            }
            if (f.floatValue() > 0.0f) {
                found = true;
            }
            if (!(f.floatValue() < 0.0f)) continue;
            Main.error(I18n.tr("Illegal dash pattern, values must be positive", new Object[0]));
            this.dashed = null;
            return;
        }
        if (found) {
            this.dashed = dashed;
        } else {
            Main.error(I18n.tr("Illegal dash pattern, at least one value must be > 0", new Object[0]));
        }
    }

    public int getWidth() {
        if (this.width == -1) {
            return MapPaintSettings.INSTANCE.getDefaultSegmentWidth();
        }
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

