/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.TokenMgrError;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSStyleSource
extends StyleSource {
    public static final String MAPCSS_STYLE_MIME_TYPES = "text/x-mapcss, text/mapcss, text/css; q=0.9, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5";
    public final List<MapCSSRule> rules = new ArrayList<MapCSSRule>();
    public final MapCSSRuleIndex nodeRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex wayRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex wayNoAreaRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex relationRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex multipolygonRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex canvasRules = new MapCSSRuleIndex();
    private Color backgroundColorOverride;
    private String css = null;
    private ZipFile zipFile;
    public static final ReadWriteLock STYLE_SOURCE_LOCK;
    public static final Set<String> SUPPORTED_KEYS;

    public MapCSSStyleSource(String url, String name, String shortdescription) {
        super(url, name, shortdescription);
    }

    public MapCSSStyleSource(SourceEntry entry) {
        super(entry);
    }

    public MapCSSStyleSource(String css) throws IllegalArgumentException {
        super(null, null, null);
        CheckParameterUtil.ensureParameterNotNull(css);
        this.css = css;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadStyleSource() {
        STYLE_SOURCE_LOCK.writeLock().lock();
        try {
            this.init();
            this.rules.clear();
            this.nodeRules.clear();
            this.wayRules.clear();
            this.wayNoAreaRules.clear();
            this.relationRules.clear();
            this.multipolygonRules.clear();
            this.canvasRules.clear();
            try (InputStream in = this.getSourceInputStream();){
                try {
                    MapCSSParser preprocessor = new MapCSSParser(in, "UTF-8", MapCSSParser.LexicalState.PREPROCESSOR);
                    String mapcss = preprocessor.pp_root(this);
                    ByteArrayInputStream in2 = new ByteArrayInputStream(mapcss.getBytes(StandardCharsets.UTF_8));
                    MapCSSParser parser = new MapCSSParser(in2, "UTF-8", MapCSSParser.LexicalState.DEFAULT);
                    parser.sheet(this);
                    this.loadMeta();
                    this.loadCanvas();
                    this.loadSettings();
                }
                finally {
                    this.closeSourceInputStream(in);
                }
            }
            catch (IOException e) {
                Main.warn(I18n.tr("Failed to load Mappaint styles from ''{0}''. Exception was: {1}", this.url, e.toString()));
                Main.error(e);
                this.logError(e);
            }
            catch (TokenMgrError e) {
                Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, e.getMessage()));
                Main.error(e);
                this.logError(e);
            }
            catch (ParseException e) {
                Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, e.getMessage()));
                Main.error(e);
                this.logError(new ParseException(e.getMessage()));
            }
            block38: for (MapCSSRule r : this.rules) {
                String base;
                Selector selRightmost = r.selector;
                while (selRightmost instanceof Selector.ChildOrParentSelector) {
                    selRightmost = ((Selector.ChildOrParentSelector)selRightmost).right;
                }
                MapCSSRule optRule = new MapCSSRule(r.selector.optimizedBaseCheck(), r.declaration);
                switch (base = ((Selector.GeneralSelector)selRightmost).getBase()) {
                    case "node": {
                        this.nodeRules.add(optRule);
                        continue block38;
                    }
                    case "way": {
                        this.wayNoAreaRules.add(optRule);
                        this.wayRules.add(optRule);
                        continue block38;
                    }
                    case "area": {
                        this.wayRules.add(optRule);
                        this.multipolygonRules.add(optRule);
                        continue block38;
                    }
                    case "relation": {
                        this.relationRules.add(optRule);
                        this.multipolygonRules.add(optRule);
                        continue block38;
                    }
                    case "*": {
                        this.nodeRules.add(optRule);
                        this.wayRules.add(optRule);
                        this.wayNoAreaRules.add(optRule);
                        this.relationRules.add(optRule);
                        this.multipolygonRules.add(optRule);
                        continue block38;
                    }
                    case "canvas": {
                        this.canvasRules.add(r);
                        continue block38;
                    }
                    case "meta": 
                    case "setting": {
                        continue block38;
                    }
                }
                RuntimeException e = new RuntimeException(MessageFormat.format("Unknown MapCSS base selector {0}", base));
                Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, e.getMessage()));
                Main.error(e);
                this.logError(e);
            }
            this.nodeRules.initIndex();
            this.wayRules.initIndex();
            this.wayNoAreaRules.initIndex();
            this.relationRules.initIndex();
            this.multipolygonRules.initIndex();
            this.canvasRules.initIndex();
        }
        finally {
            STYLE_SOURCE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        if (this.css != null) {
            return new ByteArrayInputStream(this.css.getBytes(StandardCharsets.UTF_8));
        }
        CachedFile cf = this.getCachedFile();
        if (this.isZip) {
            File file = cf.getFile();
            this.zipFile = new ZipFile(file, StandardCharsets.UTF_8);
            this.zipIcons = file;
            ZipEntry zipEntry = this.zipFile.getEntry(this.zipEntryPath);
            return this.zipFile.getInputStream(zipEntry);
        }
        this.zipFile = null;
        this.zipIcons = null;
        return cf.getInputStream();
    }

    @Override
    public CachedFile getCachedFile() throws IOException {
        return new CachedFile(this.url).setHttpAccept(MAPCSS_STYLE_MIME_TYPES);
    }

    @Override
    public void closeSourceInputStream(InputStream is) {
        super.closeSourceInputStream(is);
        if (this.isZip) {
            Utils.close(this.zipFile);
        }
    }

    private void loadMeta() {
        Cascade c = this.constructSpecial("meta");
        String pTitle = c.get("title", null, String.class);
        if (this.title == null) {
            this.title = pTitle;
        }
        String pIcon = c.get("icon", null, String.class);
        if (this.icon == null) {
            this.icon = pIcon;
        }
    }

    private void loadCanvas() {
        Cascade c = this.constructSpecial("canvas");
        this.backgroundColorOverride = c.get("fill-color", null, Color.class);
        if (this.backgroundColorOverride == null) {
            this.backgroundColorOverride = c.get("background-color", null, Color.class);
            if (this.backgroundColorOverride != null) {
                Main.warn(I18n.tr("Detected deprecated ''{0}'' in ''{1}'' which will be removed shortly. Use ''{2}'' instead.", "canvas{background-color}", this.url, "fill-color"));
            }
        }
    }

    private void loadSettings() {
        this.settings.clear();
        this.settingValues.clear();
        MultiCascade mc = new MultiCascade();
        Node n = new Node();
        String code = LanguageInfo.getJOSMLocaleCode();
        n.put("lang", code);
        Environment env = new Environment(n, mc, "default", this);
        for (MapCSSRule mapCSSRule : this.rules) {
            Selector.GeneralSelector gs;
            if (!(mapCSSRule.selector instanceof Selector.GeneralSelector) || !(gs = (Selector.GeneralSelector)mapCSSRule.selector).getBase().equals("setting") || !gs.matchesConditions(env)) continue;
            env.layer = null;
            env.layer = gs.getSubpart().getId(env);
            mapCSSRule.execute(env);
        }
        for (Map.Entry entry : mc.getLayers()) {
            if ("default".equals(entry.getKey())) {
                Main.warn("setting requires layer identifier e.g. 'setting::my_setting {...}'");
                continue;
            }
            Cascade c = (Cascade)entry.getValue();
            String type = c.get("type", null, String.class);
            StyleSetting.BooleanStyleSetting set = null;
            if ("boolean".equals(type)) {
                set = StyleSetting.BooleanStyleSetting.create(c, this, (String)entry.getKey());
            } else {
                Main.warn("Unkown setting type: " + type);
            }
            if (set == null) continue;
            this.settings.add(set);
            this.settingValues.put(entry.getKey(), set.getValue());
        }
    }

    private Cascade constructSpecial(String type) {
        MultiCascade mc = new MultiCascade();
        Node n = new Node();
        String code = LanguageInfo.getJOSMLocaleCode();
        n.put("lang", code);
        Environment env = new Environment(n, mc, "default", this);
        for (MapCSSRule r : this.rules) {
            Selector.GeneralSelector gs;
            if (!(r.selector instanceof Selector.GeneralSelector) || !(gs = (Selector.GeneralSelector)r.selector).getBase().equals(type) || !gs.matchesConditions(env)) continue;
            r.execute(env);
        }
        return mc.getCascade("default");
    }

    @Override
    public Color getBackgroundColorOverride() {
        return this.backgroundColorOverride;
    }

    @Override
    public void apply(MultiCascade mc, OsmPrimitive osm, double scale, boolean pretendWayIsClosed) {
        MapCSSRule r;
        Environment env = new Environment(osm, mc, null, this);
        MapCSSRuleIndex matchingRuleIndex = osm instanceof Node ? this.nodeRules : (osm instanceof Way ? (osm.isKeyFalse("area") ? this.wayNoAreaRules : this.wayRules) : (((Relation)osm).isMultipolygon() ? this.multipolygonRules : (osm.hasKey("#canvas") ? this.canvasRules : this.relationRules)));
        int lastDeclUsed = -1;
        PriorityQueue<MapCSSRule> candidates = matchingRuleIndex.getRuleCandidates(osm);
        while ((r = candidates.poll()) != null) {
            env.clearSelectorMatchingInformation();
            env.layer = null;
            String sub = env.layer = r.selector.getSubpart().getId(env);
            if (!r.selector.matches(env)) continue;
            Selector s = r.selector;
            if (!s.getRange().contains(scale)) {
                mc.range = mc.range.reduceAround(scale, s.getRange());
                continue;
            }
            mc.range = Range.cut(mc.range, s.getRange());
            if (r.declaration.idx == lastDeclUsed) continue;
            lastDeclUsed = r.declaration.idx;
            if ("*".equals(sub)) {
                for (Map.Entry<String, Cascade> entry : mc.getLayers()) {
                    env.layer = entry.getKey();
                    if ("*".equals(env.layer)) continue;
                    r.execute(env);
                }
            }
            env.layer = sub;
            r.execute(env);
        }
    }

    public boolean evalSupportsDeclCondition(String feature, Object val) {
        if (feature == null) {
            return false;
        }
        if (SUPPORTED_KEYS.contains(feature)) {
            return true;
        }
        switch (feature) {
            case "user-agent": {
                String s = Cascade.convertTo(val, String.class);
                return "josm".equals(s);
            }
            case "min-josm-version": {
                Float v = Cascade.convertTo(val, Float.class);
                return v != null && Math.round(v.floatValue()) <= Version.getInstance().getVersion();
            }
            case "max-josm-version": {
                Float v = Cascade.convertTo(val, Float.class);
                return v != null && Math.round(v.floatValue()) >= Version.getInstance().getVersion();
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return Utils.join("\n", this.rules);
    }

    static {
        Field[] declaredFields;
        STYLE_SOURCE_LOCK = new ReentrantReadWriteLock();
        SUPPORTED_KEYS = new HashSet<String>();
        for (Field field : declaredFields = StyleKeys.class.getDeclaredFields()) {
            try {
                SUPPORTED_KEYS.add((String)field.get(null));
                if (field.getName().toLowerCase().replace("_", "-").equals(field.get(null))) continue;
                throw new RuntimeException(field.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
        }
        for (LineElemStyle.LineType lineType : LineElemStyle.LineType.values()) {
            SUPPORTED_KEYS.add(lineType.prefix + "color");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-background-color");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-background-opacity");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-offset");
            SUPPORTED_KEYS.add(lineType.prefix + "linecap");
            SUPPORTED_KEYS.add(lineType.prefix + "linejoin");
            SUPPORTED_KEYS.add(lineType.prefix + "miterlimit");
            SUPPORTED_KEYS.add(lineType.prefix + "offset");
            SUPPORTED_KEYS.add(lineType.prefix + "opacity");
            SUPPORTED_KEYS.add(lineType.prefix + "real-width");
            SUPPORTED_KEYS.add(lineType.prefix + "width");
        }
    }

    public static class MapCSSRuleIndex {
        public final List<MapCSSRule> rules = new ArrayList<MapCSSRule>();
        public final Map<String, Map<String, Set<MapCSSRule>>> index = new HashMap<String, Map<String, Set<MapCSSRule>>>();
        public final ArrayList<MapCSSRule> remaining = new ArrayList();

        public void add(MapCSSRule rule) {
            this.rules.add(rule);
        }

        public void initIndex() {
            for (MapCSSRule r : this.rules) {
                Set<MapCSSRule> rulesWithMatchingKeyValue;
                Selector selRightmost = r.selector;
                while (selRightmost instanceof Selector.ChildOrParentSelector) {
                    selRightmost = ((Selector.ChildOrParentSelector)selRightmost).right;
                }
                Selector.OptimizedGeneralSelector s = (Selector.OptimizedGeneralSelector)selRightmost;
                if (s.conds == null) {
                    this.remaining.add(r);
                    continue;
                }
                ArrayList sk = new ArrayList(Utils.filteredCollection(s.conds, Condition.SimpleKeyValueCondition.class));
                if (sk.isEmpty()) {
                    this.remaining.add(r);
                    continue;
                }
                Condition.SimpleKeyValueCondition c = (Condition.SimpleKeyValueCondition)sk.get(sk.size() - 1);
                Map<String, Set<MapCSSRule>> rulesWithMatchingKey = this.index.get(c.k);
                if (rulesWithMatchingKey == null) {
                    rulesWithMatchingKey = new HashMap<String, Set<MapCSSRule>>();
                    this.index.put(c.k, rulesWithMatchingKey);
                }
                if ((rulesWithMatchingKeyValue = rulesWithMatchingKey.get(c.v)) == null) {
                    rulesWithMatchingKeyValue = new HashSet<MapCSSRule>();
                    rulesWithMatchingKey.put(c.v, rulesWithMatchingKeyValue);
                }
                rulesWithMatchingKeyValue.add(r);
            }
            Collections.sort(this.remaining);
        }

        public PriorityQueue<MapCSSRule> getRuleCandidates(OsmPrimitive osm) {
            PriorityQueue<MapCSSRule> ruleCandidates = new PriorityQueue<MapCSSRule>(this.remaining);
            for (Map.Entry<String, String> e : osm.getKeys().entrySet()) {
                Set<MapCSSRule> rs;
                Map<String, Set<MapCSSRule>> v = this.index.get(e.getKey());
                if (v == null || (rs = v.get(e.getValue())) == null) continue;
                ruleCandidates.addAll(rs);
            }
            return ruleCandidates;
        }

        public void clear() {
            this.rules.clear();
            this.index.clear();
            this.remaining.clear();
        }
    }
}

