/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;

public abstract class Condition {
    public static final EnumSet<Op> COMPARISON_OPERATERS = EnumSet.of(Op.GREATER_OR_EQUAL, Op.GREATER, Op.LESS_OR_EQUAL, Op.LESS);

    public abstract boolean applies(Environment var1);

    public static Condition createKeyValueCondition(String k, String v, Op op, Context context, boolean considerValAsKey) {
        switch (context) {
            case PRIMITIVE: {
                if (KeyValueRegexpCondition.SUPPORTED_OPS.contains((Object)op) && !considerValAsKey) {
                    return new KeyValueRegexpCondition(k, v, op, false);
                }
                if (!considerValAsKey && op.equals((Object)Op.EQ)) {
                    return new SimpleKeyValueCondition(k, v);
                }
                return new KeyValueCondition(k, v, op, considerValAsKey);
            }
            case LINK: {
                if (considerValAsKey) {
                    throw new MapCSSException("''considerValAsKey'' not supported in LINK context");
                }
                if ("role".equalsIgnoreCase(k)) {
                    return new RoleCondition(v, op);
                }
                if ("index".equalsIgnoreCase(k)) {
                    return new IndexCondition(v, op);
                }
                throw new MapCSSException(MessageFormat.format("Expected key ''role'' or ''index'' in link context. Got ''{0}''.", k));
            }
        }
        throw new AssertionError();
    }

    public static Condition createKeyCondition(String k, boolean not, KeyMatchType matchType, Context context) {
        switch (context) {
            case PRIMITIVE: {
                return new KeyCondition(k, not, matchType);
            }
            case LINK: {
                if (matchType != null) {
                    throw new MapCSSException("Question mark operator ''?'' and regexp match not supported in LINK context");
                }
                if (not) {
                    return new RoleCondition(k, Op.NEQ);
                }
                return new RoleCondition(k, Op.EQ);
            }
        }
        throw new AssertionError();
    }

    public static PseudoClassCondition createPseudoClassCondition(String id, boolean not, Context context) {
        return new PseudoClassCondition(id, not, context);
    }

    public static ClassCondition createClassCondition(String id, boolean not, Context context) {
        return new ClassCondition(id, not);
    }

    public static ExpressionCondition createExpressionCondition(Expression e, Context context) {
        return new ExpressionCondition(e);
    }

    public static class ExpressionCondition
    extends Condition {
        private final Expression e;

        public ExpressionCondition(Expression e) {
            this.e = e;
        }

        @Override
        public boolean applies(Environment env) {
            Boolean b = Cascade.convertTo(this.e.evaluate(env), Boolean.class);
            return b != null && b != false;
        }

        public String toString() {
            return "[" + this.e + "]";
        }
    }

    public static class PseudoClassCondition
    extends Condition {
        public final String id;
        public final boolean not;

        public PseudoClassCondition(String id, boolean not, Context context) {
            this.id = id;
            this.not = not;
            CheckParameterUtil.ensureThat(!"sameTags".equals(id) || Context.LINK.equals((Object)context), "sameTags only supported in LINK context");
        }

        @Override
        public boolean applies(Environment e) {
            return this.not ^ this.appliesImpl(e);
        }

        public boolean appliesImpl(Environment e) {
            switch (this.id) {
                case "closed": {
                    if (e.osm instanceof Way && ((Way)e.osm).isClosed()) {
                        return true;
                    }
                    if (!(e.osm instanceof Relation) || !((Relation)e.osm).isMultipolygon()) break;
                    return true;
                }
                case "modified": {
                    return e.osm.isModified() || e.osm.isNewOrUndeleted();
                }
                case "new": {
                    return e.osm.isNew();
                }
                case "connection": {
                    return e.osm instanceof Node && ((Node)e.osm).isConnectionNode();
                }
                case "tagged": {
                    return e.osm.isTagged();
                }
                case "sameTags": {
                    return e.osm.hasSameInterestingTags(Utils.firstNonNull(e.child, e.parent));
                }
                case "areaStyle": {
                    return ElemStyles.hasAreaElemStyle(e.osm, false);
                }
                case "unconnected": {
                    return e.osm instanceof Node && OsmPrimitive.getFilteredList(e.osm.getReferrers(), Way.class).isEmpty();
                }
                case "righthandtraffic": {
                    return ExpressionFactory.Functions.is_right_hand_traffic(e);
                }
            }
            return false;
        }

        public String toString() {
            return ":" + (this.not ? "!" : "") + this.id;
        }
    }

    public static class ClassCondition
    extends Condition {
        public final String id;
        public final boolean not;

        public ClassCondition(String id, boolean not) {
            this.id = id;
            this.not = not;
        }

        @Override
        public boolean applies(Environment env) {
            return env != null && env.getCascade(env.layer) != null && this.not ^ env.getCascade(env.layer).containsKey(this.id);
        }

        public String toString() {
            return (this.not ? "!" : "") + "." + this.id;
        }
    }

    public static class KeyCondition
    extends Condition {
        public final String label;
        public final boolean negateResult;
        public final KeyMatchType matchType;
        public Predicate<String> containsPattern;

        public KeyCondition(String label, boolean negateResult, KeyMatchType matchType) {
            this.label = label;
            this.negateResult = negateResult;
            this.matchType = matchType;
            this.containsPattern = KeyMatchType.REGEX.equals((Object)matchType) ? Predicates.stringContainsPattern(Pattern.compile(label)) : null;
        }

        @Override
        public boolean applies(Environment e) {
            switch (e.getContext()) {
                case PRIMITIVE: {
                    if (KeyMatchType.TRUE.equals((Object)this.matchType)) {
                        return e.osm.isKeyTrue(this.label) ^ this.negateResult;
                    }
                    if (KeyMatchType.FALSE.equals((Object)this.matchType)) {
                        return e.osm.isKeyFalse(this.label) ^ this.negateResult;
                    }
                    if (KeyMatchType.REGEX.equals((Object)this.matchType)) {
                        return Utils.exists(e.osm.keySet(), this.containsPattern) ^ this.negateResult;
                    }
                    return e.osm.hasKey(this.label) ^ this.negateResult;
                }
                case LINK: {
                    Utils.ensure(false, "Illegal state: KeyCondition not supported in LINK context", new Object[0]);
                    return false;
                }
            }
            throw new AssertionError();
        }

        public Tag asTag() {
            return new Tag(this.label);
        }

        public String toString() {
            return "[" + (this.negateResult ? "!" : "") + this.label + "]";
        }
    }

    public static enum KeyMatchType {
        EQ,
        TRUE,
        FALSE,
        REGEX;

    }

    public static class IndexCondition
    extends Condition {
        public final String index;
        public final Op op;

        public IndexCondition(String index, Op op) {
            this.index = index;
            this.op = op;
        }

        @Override
        public boolean applies(Environment env) {
            if (env.index == null) {
                return false;
            }
            return this.op.eval(Integer.toString(env.index + 1), this.index);
        }
    }

    public static class RoleCondition
    extends Condition {
        public final String role;
        public final Op op;

        public RoleCondition(String role, Op op) {
            this.role = role;
            this.op = op;
        }

        @Override
        public boolean applies(Environment env) {
            String testRole = env.getRole();
            if (testRole == null) {
                return false;
            }
            return this.op.eval(testRole, this.role);
        }
    }

    public static class KeyValueRegexpCondition
    extends KeyValueCondition {
        public final Pattern pattern;
        public static final EnumSet<Op> SUPPORTED_OPS = EnumSet.of(Op.REGEX, Op.NREGEX);

        public KeyValueRegexpCondition(String k, String v, Op op, boolean considerValAsKey) {
            super(k, v, op, considerValAsKey);
            CheckParameterUtil.ensureThat(!considerValAsKey, "considerValAsKey is not supported");
            CheckParameterUtil.ensureThat(SUPPORTED_OPS.contains((Object)op), "Op must be REGEX or NREGEX");
            this.pattern = Pattern.compile(v);
        }

        @Override
        public boolean applies(Environment env) {
            String value = env.osm.get(this.k);
            if (Op.REGEX.equals((Object)this.op)) {
                return value != null && this.pattern.matcher(value).find();
            }
            if (Op.NREGEX.equals((Object)this.op)) {
                return value == null || !this.pattern.matcher(value).find();
            }
            throw new IllegalStateException();
        }
    }

    public static class KeyValueCondition
    extends Condition {
        public final String k;
        public final String v;
        public final Op op;
        public boolean considerValAsKey;

        public KeyValueCondition(String k, String v, Op op, boolean considerValAsKey) {
            this.k = k;
            this.v = v;
            this.op = op;
            this.considerValAsKey = considerValAsKey;
        }

        @Override
        public boolean applies(Environment env) {
            return this.op.eval(env.osm.get(this.k), this.considerValAsKey ? env.osm.get(this.v) : this.v);
        }

        public Tag asTag() {
            return new Tag(this.k, this.v);
        }

        public String toString() {
            return "[" + this.k + "'" + (Object)((Object)this.op) + "'" + this.v + "]";
        }
    }

    public static class SimpleKeyValueCondition
    extends Condition {
        public final String k;
        public final String v;

        public SimpleKeyValueCondition(String k, String v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public boolean applies(Environment e) {
            return this.v.equals(e.osm.get(this.k));
        }

        public Tag asTag() {
            return new Tag(this.k, this.v);
        }

        public String toString() {
            return '[' + this.k + '=' + this.v + ']';
        }
    }

    public static enum Context {
        PRIMITIVE,
        LINK;

    }

    public static enum Op {
        EQ,
        NEQ,
        GREATER_OR_EQUAL,
        GREATER,
        LESS_OR_EQUAL,
        LESS,
        REGEX,
        NREGEX,
        ONE_OF,
        BEGINS_WITH,
        ENDS_WITH,
        CONTAINS;

        private static final Set<Op> NEGATED_OPS;

        public boolean eval(String testString, String prototypeString) {
            float test_float;
            if (testString == null && !NEGATED_OPS.contains((Object)this)) {
                return false;
            }
            switch (this) {
                case EQ: {
                    return Objects.equals(testString, prototypeString);
                }
                case NEQ: {
                    return !Objects.equals(testString, prototypeString);
                }
                case REGEX: 
                case NREGEX: {
                    boolean contains = Pattern.compile(prototypeString).matcher(testString).find();
                    return REGEX.equals((Object)this) ? contains : !contains;
                }
                case ONE_OF: {
                    return Arrays.asList(testString.split("\\s*;\\s*")).contains(prototypeString);
                }
                case BEGINS_WITH: {
                    return testString.startsWith(prototypeString);
                }
                case ENDS_WITH: {
                    return testString.endsWith(prototypeString);
                }
                case CONTAINS: {
                    return testString.contains(prototypeString);
                }
            }
            try {
                test_float = Float.parseFloat(testString);
            }
            catch (NumberFormatException e) {
                return false;
            }
            float prototype_float = Float.parseFloat(prototypeString);
            switch (this) {
                case GREATER_OR_EQUAL: {
                    return test_float >= prototype_float;
                }
                case GREATER: {
                    return test_float > prototype_float;
                }
                case LESS_OR_EQUAL: {
                    return test_float <= prototype_float;
                }
                case LESS: {
                    return test_float < prototype_float;
                }
            }
            throw new AssertionError();
        }

        static {
            NEGATED_OPS = EnumSet.of(NEQ, NREGEX);
        }
    }
}

