/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.LabelCompositionStrategy;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class TextElement
implements StyleKeys {
    public static final LabelCompositionStrategy AUTO_LABEL_COMPOSITION_STRATEGY = new LabelCompositionStrategy.DeriveLabelFromNameTagsCompositionStrategy();
    public LabelCompositionStrategy labelCompositionStrategy;
    public Font font;
    public int xOffset;
    public int yOffset;
    public Color color;
    public Float haloRadius;
    public Color haloColor;

    public TextElement(LabelCompositionStrategy strategy, Font font, int xOffset, int yOffset, Color color, Float haloRadius, Color haloColor) {
        CheckParameterUtil.ensureParameterNotNull(font);
        CheckParameterUtil.ensureParameterNotNull(color);
        this.labelCompositionStrategy = strategy;
        this.font = font;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.color = color;
        this.haloRadius = haloRadius;
        this.haloColor = haloColor;
    }

    public TextElement(TextElement other) {
        this.labelCompositionStrategy = other.labelCompositionStrategy;
        this.font = other.font;
        this.xOffset = other.xOffset;
        this.yOffset = other.yOffset;
        this.color = other.color;
        this.haloColor = other.haloColor;
        this.haloRadius = other.haloRadius;
    }

    protected static LabelCompositionStrategy buildLabelCompositionStrategy(Cascade c, boolean defaultAnnotate) {
        MapPaintStyles.TagKeyReference tkr = c.get("text", null, MapPaintStyles.TagKeyReference.class, true);
        if (tkr != null) {
            return new LabelCompositionStrategy.TagLookupCompositionStrategy(tkr.key);
        }
        Keyword keyword = c.get("text", null, Keyword.class, true);
        if (Keyword.AUTO.equals(keyword)) {
            return AUTO_LABEL_COMPOSITION_STRATEGY;
        }
        String text = c.get("text", null, String.class, true);
        if (text != null) {
            return new LabelCompositionStrategy.StaticLabelCompositionStrategy(text);
        }
        return defaultAnnotate ? AUTO_LABEL_COMPOSITION_STRATEGY : null;
    }

    public static TextElement create(Environment env, Color defaultTextColor, boolean defaultAnnotate) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(defaultTextColor);
        Cascade c = env.mc.getCascade(env.layer);
        LabelCompositionStrategy strategy = TextElement.buildLabelCompositionStrategy(c, defaultAnnotate);
        if (strategy == null) {
            return null;
        }
        String s = strategy.compose(env.osm);
        if (s == null) {
            return null;
        }
        Font font = ElemStyle.getFont(c, s);
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        float[] offset = c.get("text-offset", null, float[].class);
        if (offset != null) {
            if (offset.length == 1) {
                yOffset = offset[0];
            } else if (offset.length >= 2) {
                xOffset = offset[0];
                yOffset = offset[1];
            }
        }
        xOffset = c.get("text-offset-x", Float.valueOf(xOffset), Float.class).floatValue();
        yOffset = c.get("text-offset-y", Float.valueOf(yOffset), Float.class).floatValue();
        Color color = c.get("text-color", defaultTextColor, Color.class);
        float alpha = c.get("text-opacity", Float.valueOf(1.0f), Float.class).floatValue();
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), Utils.color_float2int(Float.valueOf(alpha)));
        Float haloRadius = c.get("text-halo-radius", null, Float.class);
        if (haloRadius != null && haloRadius.floatValue() <= 0.0f) {
            haloRadius = null;
        }
        Color haloColor = null;
        if (haloRadius != null) {
            haloColor = c.get("text-halo-color", Utils.complement(color), Color.class);
            float haloAlpha = c.get("text-halo-opacity", Float.valueOf(1.0f), Float.class).floatValue();
            haloColor = new Color(haloColor.getRed(), haloColor.getGreen(), haloColor.getBlue(), Utils.color_float2int(Float.valueOf(haloAlpha)));
        }
        return new TextElement(strategy, font, (int)xOffset, -((int)yOffset), color, haloRadius, haloColor);
    }

    public String getString(OsmPrimitive osm) {
        if (this.labelCompositionStrategy == null) {
            return null;
        }
        return this.labelCompositionStrategy.compose(osm);
    }

    public String toString() {
        return "TextElement{" + this.toStringImpl() + '}';
    }

    protected String toStringImpl() {
        StringBuilder sb = new StringBuilder();
        sb.append("labelCompositionStrategy=" + this.labelCompositionStrategy);
        sb.append(" font=" + this.font);
        if (this.xOffset != 0) {
            sb.append(" xOffset=" + this.xOffset);
        }
        if (this.yOffset != 0) {
            sb.append(" yOffset=" + this.yOffset);
        }
        sb.append(" color=" + Utils.toString(this.color));
        if (this.haloRadius != null) {
            sb.append(" haloRadius=" + this.haloRadius);
            sb.append(" haloColor=" + this.haloColor);
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.labelCompositionStrategy != null ? this.labelCompositionStrategy.hashCode() : 0);
        hash = 79 * hash + this.font.hashCode();
        hash = 79 * hash + this.xOffset;
        hash = 79 * hash + this.yOffset;
        hash = 79 * hash + this.color.hashCode();
        hash = 79 * hash + (this.haloRadius != null ? Float.floatToIntBits(this.haloRadius.floatValue()) : 0);
        hash = 79 * hash + (this.haloColor != null ? this.haloColor.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TextElement other = (TextElement)obj;
        return Objects.equals(this.labelCompositionStrategy, other.labelCompositionStrategy) && Objects.equals(this.font, other.font) && this.xOffset == other.xOffset && this.yOffset == other.yOffset && Objects.equals(this.color, other.color) && Objects.equals(this.haloRadius, other.haloRadius) && Objects.equals(this.haloColor, other.haloColor);
    }
}

