/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;

public interface StyleSetting {
    public void addMenuEntry(JMenu var1);

    public Object getValue();

    public static class BooleanStyleSetting
    implements StyleSetting {
        public final StyleSource parentStyle;
        public final String prefKey;
        public final String label;
        public final boolean def;

        public BooleanStyleSetting(StyleSource parentStyle, String prefKey, String label, boolean def) {
            this.parentStyle = parentStyle;
            this.prefKey = prefKey;
            this.label = label;
            this.def = def;
        }

        @Override
        public void addMenuEntry(JMenu menu) {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem();
            AbstractAction a = new AbstractAction(this.label){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean b = item.isSelected();
                    if (b == BooleanStyleSetting.this.def) {
                        Main.pref.put(BooleanStyleSetting.this.prefKey, null);
                    } else {
                        Main.pref.put(BooleanStyleSetting.this.prefKey, b);
                    }
                    Main.worker.submit(new MapPaintStyles.MapPaintStyleLoader(Arrays.asList(BooleanStyleSetting.this.parentStyle)));
                }
            };
            item.setAction(a);
            item.setSelected((Boolean)this.getValue());
            menu.add(item);
        }

        public static BooleanStyleSetting create(Cascade c, StyleSource parentStyle, String key) {
            String label = c.get("label", null, String.class);
            if (label == null) {
                Main.warn("property 'label' required for boolean style setting");
                return null;
            }
            Boolean def = c.get("default", null, Boolean.class);
            if (def == null) {
                Main.warn("property 'default' required for boolean style setting");
                return null;
            }
            String prefKey = parentStyle.url + ":boolean:" + key;
            return new BooleanStyleSetting(parentStyle, prefKey, label, def);
        }

        @Override
        public Object getValue() {
            String val = Main.pref.get(this.prefKey, null);
            if (val == null) {
                return this.def;
            }
            return Boolean.parseBoolean(val);
        }
    }
}

