/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.tools.Pair;

public final class StyleCache {
    private final List<Double> bd;
    private final List<StyleList> data;
    private static final Storage<StyleCache> internPool = new Storage();
    public static final StyleCache EMPTY_STYLECACHE = new StyleCache().intern();

    private StyleCache() {
        this.bd = new ArrayList<Double>();
        this.bd.add(0.0);
        this.bd.add(Double.POSITIVE_INFINITY);
        this.data = new ArrayList<StyleList>();
        this.data.add(null);
    }

    private StyleCache(StyleCache s) {
        this.bd = new ArrayList<Double>(s.bd);
        this.data = new ArrayList<StyleList>(s.data);
    }

    public StyleList get(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale must be <= 0 but is " + scale);
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.bd.get(i) < scale) || !(scale <= this.bd.get(i + 1))) continue;
            return this.data.get(i);
        }
        throw new AssertionError();
    }

    public Pair<StyleList, Range> getWithRange(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale must be <= 0 but is " + scale);
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.bd.get(i) < scale) || !(scale <= this.bd.get(i + 1))) continue;
            return new Pair<StyleList, Range>(this.data.get(i), new Range(this.bd.get(i), this.bd.get(i + 1)));
        }
        throw new AssertionError();
    }

    public StyleCache put(StyleList sl, Range r) {
        return this.put(sl, r.getLower(), r.getUpper());
    }

    public StyleCache put(StyleList sl, double lower, double upper) {
        StyleCache s = new StyleCache(this);
        s.putImpl(sl, lower, upper);
        s.consistencyTest();
        return s.intern();
    }

    private void putImpl(StyleList sl, double lower, double upper) {
        int i = 0;
        while (this.bd.get(i) < lower) {
            ++i;
        }
        if (this.bd.get(i) == lower) {
            if (upper > this.bd.get(i + 1)) {
                throw new RangeViolatedError();
            }
            if (this.data.get(i) != null) {
                throw new AssertionError((Object)"the new range must be within a subrange that has no data");
            }
            if (this.bd.get(i + 1) == upper) {
                this.data.set(i, sl);
            } else {
                this.bd.add(i + 1, upper);
                this.data.add(i, sl);
            }
            return;
        }
        if (this.bd.get(i) < upper) {
            throw new AssertionError((Object)"the new range must be within a single subrange");
        }
        if (this.data.get(i - 1) != null) {
            throw new AssertionError();
        }
        this.bd.add(i, lower);
        this.data.add(i, sl);
        if (this.bd.get(i + 1) > upper) {
            this.bd.add(i + 1, upper);
            this.data.add(i + 1, null);
        }
    }

    public void consistencyTest() {
        if (this.bd.size() < 2) {
            throw new AssertionError();
        }
        if (this.data.size() < 1) {
            throw new AssertionError();
        }
        if (this.bd.size() != this.data.size() + 1) {
            throw new AssertionError();
        }
        if (this.bd.get(0) != 0.0) {
            throw new AssertionError();
        }
        if (this.bd.get(this.bd.size() - 1) != Double.POSITIVE_INFINITY) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.data.size() - 1; ++i) {
            if (this.bd.get(i) >= this.bd.get(i + 1)) {
                throw new AssertionError();
            }
        }
    }

    public StyleCache intern() {
        return internPool.putUnique(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StyleCache other = (StyleCache)obj;
        return this.bd.equals(other.bd) && this.data.equals(other.data);
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + this.bd.hashCode();
        hash = 23 * hash + this.data.hashCode();
        return hash;
    }

    public String toString() {
        return "SC{" + this.bd + ' ' + this.data + '}';
    }

    public static class RangeViolatedError
    extends Error {
    }

    public static class StyleList
    implements Iterable<ElemStyle> {
        private List<ElemStyle> lst;

        public StyleList() {
            this.lst = new ArrayList<ElemStyle>();
        }

        public StyleList(ElemStyle ... init) {
            this.lst = new ArrayList<ElemStyle>(Arrays.asList(init));
        }

        public StyleList(Collection<ElemStyle> sl) {
            this.lst = new ArrayList<ElemStyle>(sl);
        }

        public StyleList(StyleList sl, ElemStyle s) {
            this.lst = new ArrayList<ElemStyle>(sl.lst);
            this.lst.add(s);
        }

        @Override
        public Iterator<ElemStyle> iterator() {
            return this.lst.iterator();
        }

        public boolean isEmpty() {
            return this.lst.isEmpty();
        }

        public int size() {
            return this.lst.size();
        }

        public String toString() {
            return this.lst.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StyleList other = (StyleList)obj;
            return Objects.equals(this.lst, other.lst);
        }

        public int hashCode() {
            return this.lst.hashCode();
        }
    }
}

