/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RepeatImageElemStyle
extends ElemStyle
implements StyleKeys {
    public MapImage pattern;
    public float offset;
    public float spacing;
    public float phase;
    public LineImageAlignment align;

    public RepeatImageElemStyle(Cascade c, MapImage pattern, float offset, float spacing, float phase, LineImageAlignment align) {
        super(c, 2.9f);
        CheckParameterUtil.ensureParameterNotNull(pattern);
        CheckParameterUtil.ensureParameterNotNull((Object)align);
        this.pattern = pattern;
        this.offset = offset;
        this.spacing = spacing;
        this.phase = phase;
        this.align = align;
    }

    public static RepeatImageElemStyle create(Environment env) {
        MapImage pattern = NodeElemStyle.createIcon(env, REPEAT_IMAGE_KEYS);
        if (pattern == null) {
            return null;
        }
        Cascade c = env.mc.getCascade(env.layer);
        float offset = c.get("repeat-image-offset", Float.valueOf(0.0f), Float.class).floatValue();
        float spacing = c.get("repeat-image-spacing", Float.valueOf(0.0f), Float.class).floatValue();
        float phase = -c.get("repeat-image-phase", Float.valueOf(0.0f), Float.class).floatValue();
        LineImageAlignment align = LineImageAlignment.CENTER;
        Keyword alignKW = c.get("repeat-image-align", Keyword.CENTER, Keyword.class);
        if ("top".equals(alignKW.val)) {
            align = LineImageAlignment.TOP;
        } else if ("bottom".equals(alignKW.val)) {
            align = LineImageAlignment.BOTTOM;
        }
        return new RepeatImageElemStyle(c, pattern, offset, spacing, phase, align);
    }

    @Override
    public void paintPrimitive(OsmPrimitive primitive, MapPaintSettings paintSettings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        Way w = (Way)primitive;
        painter.drawRepeatImage(w, this.pattern, painter.isInactiveMode() || w.isDisabled(), this.offset, this.spacing, this.phase, this.align);
    }

    @Override
    public boolean isProperLineStyle() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RepeatImageElemStyle other = (RepeatImageElemStyle)obj;
        if (!this.pattern.equals(other.pattern)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.spacing != other.spacing) {
            return false;
        }
        if (this.phase != other.phase) {
            return false;
        }
        return this.align == other.align;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + this.pattern.hashCode();
        hash = 83 * hash + Float.floatToIntBits(this.offset);
        hash = 83 * hash + Float.floatToIntBits(this.spacing);
        hash = 83 * hash + Float.floatToIntBits(this.phase);
        hash = 83 * hash + this.align.hashCode();
        return hash;
    }

    @Override
    public String toString() {
        return "RepeatImageStyle{" + super.toString() + "pattern=[" + this.pattern + "], offset=" + this.offset + ", spacing=" + this.spacing + ", phase=" + -this.phase + ", align=" + (Object)((Object)this.align) + "}";
    }

    public static enum LineImageAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

