/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

public class Range {
    private final double lower;
    private final double upper;
    public static final Range ZERO_TO_INFINITY = new Range(0.0, Double.POSITIVE_INFINITY);

    public Range(double lower, double upper) {
        if (lower < 0.0 || lower >= upper) {
            throw new IllegalArgumentException("Invalid range: " + lower + "-" + upper);
        }
        this.lower = lower;
        this.upper = upper;
    }

    public boolean contains(double x) {
        return this.lower < x && x <= this.upper;
    }

    public static Range cut(Range a, Range b) {
        if (b.lower >= a.upper || b.upper <= a.lower) {
            throw new IllegalArgumentException("Ranges do not overlap: " + a + " - " + b);
        }
        return new Range(Math.max(a.lower, b.lower), Math.min(a.upper, b.upper));
    }

    public Range reduceAround(double x, Range other) {
        if (!this.contains(x)) {
            throw new IllegalArgumentException(x + " is not inside " + this);
        }
        if (other.contains(x)) {
            throw new IllegalArgumentException(x + " is inside " + other);
        }
        if (x < other.lower && other.lower < this.upper) {
            return new Range(this.lower, other.lower);
        }
        if (this.lower < other.upper && other.upper < x) {
            return new Range(other.upper, this.upper);
        }
        return this;
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public String toString() {
        return String.format("|s%s-%s", this.lower, this.upper);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (Double.compare(range.lower, this.lower) != 0) {
            return false;
        }
        return Double.compare(range.upper, this.upper) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.lower);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.upper);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

