/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.Objects;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.BoxTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.tools.Utils;

public class NodeElemStyle
extends ElemStyle
implements StyleKeys {
    public final MapImage mapImage;
    public final Symbol symbol;
    public static final NodeElemStyle SIMPLE_NODE_ELEMSTYLE;
    public static final BoxTextElemStyle.BoxProvider SIMPLE_NODE_ELEMSTYLE_BOXPROVIDER;
    public static final StyleCache.StyleList DEFAULT_NODE_STYLELIST;
    public static final StyleCache.StyleList DEFAULT_NODE_STYLELIST_TEXT;

    protected NodeElemStyle(Cascade c, MapImage mapImage, Symbol symbol, float default_major_z_index) {
        super(c, default_major_z_index);
        this.mapImage = mapImage;
        this.symbol = symbol;
    }

    public static NodeElemStyle create(Environment env) {
        return NodeElemStyle.create(env, 4.0f, false);
    }

    private static NodeElemStyle create(Environment env, float default_major_z_index, boolean allowDefault) {
        Cascade c = env.mc.getCascade(env.layer);
        MapImage mapImage = NodeElemStyle.createIcon(env, ICON_KEYS);
        Symbol symbol = null;
        if (mapImage == null) {
            symbol = NodeElemStyle.createSymbol(env);
        }
        if (!allowDefault && symbol == null && mapImage == null) {
            return null;
        }
        return new NodeElemStyle(c, mapImage, symbol, default_major_z_index);
    }

    public static MapImage createIcon(Environment env, String[] keys) {
        Cascade c = env.mc.getCascade(env.layer);
        MapPaintStyles.IconReference iconRef = c.get(keys[0], null, MapPaintStyles.IconReference.class, true);
        if (iconRef == null) {
            return null;
        }
        Cascade c_def = env.mc.getCascade("default");
        Float widthOnDefault = c_def.get(keys[1], null, Float.class);
        if (widthOnDefault != null && widthOnDefault.floatValue() <= 0.0f) {
            widthOnDefault = null;
        }
        Float widthF = NodeElemStyle.getWidth(c, keys[1], widthOnDefault);
        Float heightOnDefault = c_def.get(keys[2], null, Float.class);
        if (heightOnDefault != null && heightOnDefault.floatValue() <= 0.0f) {
            heightOnDefault = null;
        }
        Float heightF = NodeElemStyle.getWidth(c, keys[2], heightOnDefault);
        int width = widthF == null ? -1 : Math.round(widthF.floatValue());
        int height = heightF == null ? -1 : Math.round(heightF.floatValue());
        float offsetXF = 0.0f;
        float offsetYF = 0.0f;
        if (keys[4] != null) {
            offsetXF = c.get(keys[4], Float.valueOf(0.0f), Float.class).floatValue();
            offsetYF = c.get(keys[5], Float.valueOf(0.0f), Float.class).floatValue();
        }
        MapImage mapImage = new MapImage(iconRef.iconName, iconRef.source);
        mapImage.width = width;
        mapImage.height = height;
        mapImage.offsetX = Math.round(offsetXF);
        mapImage.offsetY = Math.round(offsetYF);
        mapImage.alpha = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.icon-image-alpha", 255)));
        Integer pAlpha = Utils.color_float2int(c.get(keys[3], null, Float.TYPE));
        if (pAlpha != null) {
            mapImage.alpha = pAlpha;
        }
        return mapImage;
    }

    private static Symbol createSymbol(Environment env) {
        Integer fillAlpha;
        Float size;
        SymbolShape shape;
        Cascade c = env.mc.getCascade(env.layer);
        Cascade c_def = env.mc.getCascade("default");
        Keyword shapeKW = c.get("symbol-shape", null, Keyword.class);
        if (shapeKW == null) {
            return null;
        }
        if ("square".equals(shapeKW.val)) {
            shape = SymbolShape.SQUARE;
        } else if ("circle".equals(shapeKW.val)) {
            shape = SymbolShape.CIRCLE;
        } else if ("triangle".equals(shapeKW.val)) {
            shape = SymbolShape.TRIANGLE;
        } else if ("pentagon".equals(shapeKW.val)) {
            shape = SymbolShape.PENTAGON;
        } else if ("hexagon".equals(shapeKW.val)) {
            shape = SymbolShape.HEXAGON;
        } else if ("heptagon".equals(shapeKW.val)) {
            shape = SymbolShape.HEPTAGON;
        } else if ("octagon".equals(shapeKW.val)) {
            shape = SymbolShape.OCTAGON;
        } else if ("nonagon".equals(shapeKW.val)) {
            shape = SymbolShape.NONAGON;
        } else if ("decagon".equals(shapeKW.val)) {
            shape = SymbolShape.DECAGON;
        } else {
            return null;
        }
        Float sizeOnDefault = c_def.get("symbol-size", null, Float.class);
        if (sizeOnDefault != null && sizeOnDefault.floatValue() <= 0.0f) {
            sizeOnDefault = null;
        }
        if ((size = NodeElemStyle.getWidth(c, "symbol-size", sizeOnDefault)) == null) {
            size = Float.valueOf(10.0f);
        }
        if (size.floatValue() <= 0.0f) {
            return null;
        }
        Float strokeWidthOnDefault = NodeElemStyle.getWidth(c_def, "symbol-stroke-width", null);
        Float strokeWidth = NodeElemStyle.getWidth(c, "symbol-stroke-width", strokeWidthOnDefault);
        Color strokeColor = c.get("symbol-stroke-color", null, Color.class);
        if (strokeWidth == null && strokeColor != null) {
            strokeWidth = Float.valueOf(1.0f);
        } else if (strokeWidth != null && strokeColor == null) {
            strokeColor = Color.ORANGE;
        }
        BasicStroke stroke = null;
        if (strokeColor != null) {
            Integer strokeAlpha = Utils.color_float2int(c.get("symbol-stroke-opacity", null, Float.class));
            if (strokeAlpha != null) {
                strokeColor = new Color(strokeColor.getRed(), strokeColor.getGreen(), strokeColor.getBlue(), strokeAlpha);
            }
            stroke = new BasicStroke(strokeWidth.floatValue());
        }
        Color fillColor = c.get("symbol-fill-color", null, Color.class);
        if (stroke == null && fillColor == null) {
            fillColor = Color.BLUE;
        }
        if (fillColor != null && (fillAlpha = Utils.color_float2int(c.get("symbol-fill-opacity", null, Float.class))) != null) {
            fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), fillAlpha);
        }
        return new Symbol(shape, Math.round(size.floatValue()), stroke, strokeColor, fillColor);
    }

    @Override
    public void paintPrimitive(OsmPrimitive primitive, MapPaintSettings settings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        if (primitive instanceof Node) {
            Node n = (Node)primitive;
            if (this.mapImage != null && painter.isShowIcons()) {
                painter.drawNodeIcon(n, this.mapImage, painter.isInactiveMode() || n.isDisabled(), selected, member);
            } else if (this.symbol != null) {
                Color strokeColor;
                Color fillColor = this.symbol.fillColor;
                if (fillColor != null) {
                    if (painter.isInactiveMode() || n.isDisabled()) {
                        fillColor = settings.getInactiveColor();
                    } else if (selected) {
                        fillColor = settings.getSelectedColor(fillColor.getAlpha());
                    } else if (member) {
                        fillColor = settings.getRelationSelectedColor(fillColor.getAlpha());
                    }
                }
                if ((strokeColor = this.symbol.strokeColor) != null) {
                    if (painter.isInactiveMode() || n.isDisabled()) {
                        strokeColor = settings.getInactiveColor();
                    } else if (selected) {
                        strokeColor = settings.getSelectedColor(strokeColor.getAlpha());
                    } else if (member) {
                        strokeColor = settings.getRelationSelectedColor(strokeColor.getAlpha());
                    }
                }
                painter.drawNodeSymbol(n, this.symbol, fillColor, strokeColor);
            } else {
                boolean isConnection = n.isConnectionNode();
                Color color = painter.isInactiveMode() || n.isDisabled() ? settings.getInactiveColor() : (selected ? settings.getSelectedColor() : (member ? settings.getRelationSelectedColor() : (isConnection ? (n.isTagged() ? settings.getTaggedConnectionColor() : settings.getConnectionColor()) : (n.isTagged() ? settings.getTaggedColor() : settings.getNodeColor()))));
                int size = Utils.max(selected ? settings.getSelectedNodeSize() : 0, n.isTagged() ? settings.getTaggedNodeSize() : 0, isConnection ? settings.getConnectionNodeSize() : 0, settings.getUnselectedNodeSize());
                boolean fill = selected && settings.isFillSelectedNode() || n.isTagged() && settings.isFillTaggedNode() || isConnection && settings.isFillConnectionNode() || settings.isFillUnselectedNode();
                painter.drawNode(n, color, size, fill);
            }
        } else if (primitive instanceof Relation && this.mapImage != null) {
            painter.drawRestriction((Relation)primitive, this.mapImage, painter.isInactiveMode() || primitive.isDisabled());
        }
    }

    public BoxTextElemStyle.BoxProvider getBoxProvider() {
        if (this.mapImage != null) {
            return this.mapImage.getBoxProvider();
        }
        if (this.symbol != null) {
            return new BoxTextElemStyle.SimpleBoxProvider(new Rectangle(-this.symbol.size / 2, -this.symbol.size / 2, this.symbol.size, this.symbol.size));
        }
        int size = Utils.max(Main.pref.getInteger("mappaint.node.selected-size", 5), Main.pref.getInteger("mappaint.node.unselected-size", 3), Main.pref.getInteger("mappaint.node.connection-size", 5), Main.pref.getInteger("mappaint.node.tagged-size", 3));
        return new BoxTextElemStyle.SimpleBoxProvider(new Rectangle(-size / 2, -size / 2, size, size));
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 17 * hash + (this.mapImage != null ? this.mapImage.hashCode() : 0);
        hash = 17 * hash + (this.symbol != null ? this.symbol.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        NodeElemStyle other = (NodeElemStyle)obj;
        if (!Objects.equals(this.mapImage, other.mapImage)) {
            return false;
        }
        return Objects.equals(this.symbol, other.symbol);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("NodeElemStyle{");
        s.append(super.toString());
        if (this.mapImage != null) {
            s.append(" icon=[" + this.mapImage + "]");
        }
        if (this.symbol != null) {
            s.append(" symbol=[" + this.symbol + "]");
        }
        s.append('}');
        return s.toString();
    }

    static {
        MultiCascade mc = new MultiCascade();
        mc.getOrCreateCascade("default");
        SIMPLE_NODE_ELEMSTYLE = NodeElemStyle.create(new Environment(null, mc, "default", null), 4.1f, true);
        if (SIMPLE_NODE_ELEMSTYLE == null) {
            throw new AssertionError();
        }
        SIMPLE_NODE_ELEMSTYLE_BOXPROVIDER = SIMPLE_NODE_ELEMSTYLE.getBoxProvider();
        DEFAULT_NODE_STYLELIST = new StyleCache.StyleList(SIMPLE_NODE_ELEMSTYLE);
        DEFAULT_NODE_STYLELIST_TEXT = new StyleCache.StyleList(SIMPLE_NODE_ELEMSTYLE, BoxTextElemStyle.SIMPLE_NODE_TEXT_ELEMSTYLE);
    }

    public static class Symbol {
        public SymbolShape symbol;
        public int size;
        public Stroke stroke;
        public Color strokeColor;
        public Color fillColor;

        public Symbol(SymbolShape symbol, int size, Stroke stroke, Color strokeColor, Color fillColor) {
            if (stroke != null && strokeColor == null) {
                throw new IllegalArgumentException("Stroke given without color");
            }
            if (stroke == null && fillColor == null) {
                throw new IllegalArgumentException("Either a stroke or a fill color must be given");
            }
            this.symbol = symbol;
            this.size = size;
            this.stroke = stroke;
            this.strokeColor = strokeColor;
            this.fillColor = fillColor;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Symbol other = (Symbol)obj;
            return this.symbol == other.symbol && this.size == other.size && Objects.equals(this.stroke, other.stroke) && Objects.equals(this.strokeColor, other.strokeColor) && Objects.equals(this.fillColor, other.fillColor);
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + this.symbol.hashCode();
            hash = 67 * hash + this.size;
            hash = 67 * hash + (this.stroke != null ? this.stroke.hashCode() : 0);
            hash = 67 * hash + (this.strokeColor != null ? this.strokeColor.hashCode() : 0);
            hash = 67 * hash + (this.fillColor != null ? this.fillColor.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "symbol=" + (Object)((Object)this.symbol) + " size=" + this.size + (this.stroke != null ? " stroke=" + this.stroke + " strokeColor=" + this.strokeColor : "") + (this.fillColor != null ? " fillColor=" + this.fillColor : "");
        }
    }

    public static enum SymbolShape {
        SQUARE,
        CIRCLE,
        TRIANGLE,
        PENTAGON,
        HEXAGON,
        HEPTAGON,
        OCTAGON,
        NONAGON,
        DECAGON;

    }
}

