/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class MultiCascade
implements StyleKeys {
    private Map<String, Cascade> layers = new HashMap<String, Cascade>();
    public Range range = Range.ZERO_TO_INFINITY;

    public Cascade getOrCreateCascade(String layer) {
        CheckParameterUtil.ensureParameterNotNull(layer);
        Cascade c = this.layers.get(layer);
        if (c == null) {
            if (this.layers.containsKey("*")) {
                c = this.layers.get("*").clone();
            } else {
                c = new Cascade();
                if (!"default".equals(layer) && !"*".equals(layer)) {
                    c.put("modifier", true);
                }
            }
            this.layers.put(layer, c);
        }
        return c;
    }

    public Cascade getCascade(String layer) {
        Cascade c;
        if (layer == null) {
            layer = "default";
        }
        if ((c = this.layers.get(layer)) == null) {
            c = new Cascade();
            if (!"default".equals(layer) && !"*".equals(layer)) {
                c.put("modifier", true);
            }
        }
        return c;
    }

    public Collection<Map.Entry<String, Cascade>> getLayers() {
        return this.layers.entrySet();
    }

    public boolean hasLayer(String layer) {
        return this.layers.containsKey(layer);
    }
}

